/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.docks.screens;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.project.client.docks.screens.PreviewDiagramScreen;
import org.kie.workbench.common.stunner.client.widgets.presenters.Viewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPreview;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class PreviewDiagramScreenTest {
    @Mock
    private SessionManager clientSessionManager;
    @Mock
    private SessionDiagramPreview<AbstractSession> sessionPreview;
    private ManagedInstance<SessionDiagramPreview<AbstractSession>> sessionPreviews;
    @Mock
    private IsWidget previewWidget;
    @Mock
    private AbstractSession session;
    @Mock
    private PreviewDiagramScreen.View view;
    @Captor
    private ArgumentCaptor<SessionViewer.SessionViewerCallback> sessionViewerCallbackArgumentCaptor;
    private PreviewDiagramScreen tested;

    @Before
    public void setup() {
        Mockito.when((Object)this.clientSessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.sessionPreview.getView()).thenReturn((Object)this.previewWidget);
        Mockito.when((Object)this.sessionPreview.getInstance()).thenReturn((Object)this.session);
        this.sessionPreviews = new ManagedInstanceStub((Object[])new SessionDiagramPreview[]{this.sessionPreview});
        this.tested = (PreviewDiagramScreen)Mockito.spy((Object)new PreviewDiagramScreen(this.clientSessionManager, this.sessionPreviews, this.view));
    }

    @Test
    public void testOnOpen() {
        this.tested.onOpen();
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).showPreview((ClientSession)Matchers.any());
    }

    @Test
    public void testOnClose() {
        this.tested.onClose();
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).closePreview();
    }

    @Test
    public void testOnCanvasSessionOpened() {
        SessionOpenedEvent event = (SessionOpenedEvent)Mockito.mock(SessionOpenedEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        this.tested.onCanvasSessionOpened(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).showPreview((ClientSession)this.session);
    }

    @Test
    public void testOnCanvasSessionDestroyed() {
        SessionDestroyedEvent event = (SessionDestroyedEvent)Mockito.mock(SessionDestroyedEvent.class);
        this.tested.onCanvasSessionDestroyed(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).closePreview();
    }

    @Test
    public void testOnSessionDiagramOpenedEvent() {
        SessionDiagramOpenedEvent event = (SessionDiagramOpenedEvent)Mockito.mock(SessionDiagramOpenedEvent.class);
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        this.tested.onSessionDiagramOpenedEvent(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).showPreview((ClientSession)this.session);
    }

    @Test
    public void testView() {
        Assert.assertEquals((Object)this.view, (Object)this.tested.getWidget());
    }

    @Test
    public void testShowPreview() {
        this.tested.showPreview((ClientSession)this.session);
        ((SessionDiagramPreview)Mockito.verify(this.sessionPreview)).open(Matchers.eq((Object)this.session), Mockito.anyInt(), Mockito.anyInt(), (Viewer.Callback)this.sessionViewerCallbackArgumentCaptor.capture());
        SessionViewer.SessionViewerCallback sessionViewerCallback = (SessionViewer.SessionViewerCallback)this.sessionViewerCallbackArgumentCaptor.getValue();
        sessionViewerCallback.onSuccess();
        ((SessionDiagramPreview)Mockito.verify(this.sessionPreview, (VerificationMode)Mockito.never())).clear();
        ((PreviewDiagramScreen.View)Mockito.verify((Object)this.view)).setPreviewWidget(this.previewWidget);
    }

    @Test
    public void testClose() {
        this.tested.showPreview((ClientSession)this.session);
        this.tested.closePreview();
        ((PreviewDiagramScreen.View)Mockito.verify((Object)this.view)).clearPreviewWidget();
        ((SessionDiagramPreview)Mockito.verify(this.sessionPreview)).destroy();
    }
}

