/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.DMNContentResource;
import org.kie.workbench.common.dmn.api.DMNContentService;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.client.marshaller.DMNMarshallerService;
import org.kie.workbench.common.dmn.project.client.editor.DMNClientProjectDiagramService;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramSavedEvent;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.service.DiagramLookupService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNClientProjectDiagramServiceTest {
    @Mock
    private ShapeManager shapeManager;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private CallerMock<ProjectDiagramService> diagramServiceCaller;
    @Mock
    private CallerMock<DiagramLookupService> diagramLookupServiceCaller;
    @Mock
    private CallerMock<DMNContentService> dmnContentServiceCaller;
    @Mock
    private DMNContentService dmnContentService;
    @Mock
    private EventSourceMock<SessionDiagramSavedEvent> saveEvent;
    @Mock
    private DMNMarshallerService dmnMarshallerService;
    @Mock
    private Path path;
    @Mock
    private ServiceCallback<ProjectDiagram> projectDiagramCallback;
    @Mock
    private ServiceCallback<Diagram> diagramCallback;
    @Mock
    private RemoteCallback<DMNContentResource> resourceRemoteCallback;
    @Mock
    private ServiceCallback<String> stringCallback;
    @Captor
    private ArgumentCaptor<ProjectDiagramImpl> projectDiagramArgumentCaptor;
    @Captor
    private ArgumentCaptor<ServiceCallback<String>> serviceCallbackArgumentCaptor;
    private DMNClientProjectDiagramService service;

    @Before
    public void setup() {
        this.service = (DMNClientProjectDiagramService)Mockito.spy((Object)new DMNClientProjectDiagramService(this.shapeManager, this.sessionManager, this.diagramServiceCaller, this.diagramLookupServiceCaller, this.saveEvent, this.dmnContentServiceCaller, this.dmnMarshallerService));
    }

    @Test
    public void testGetByPath() {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        Mockito.when((Object)this.dmnContentServiceCaller.call(this.resourceRemoteCallback)).thenReturn((Object)this.dmnContentService);
        ((DMNClientProjectDiagramService)Mockito.doReturn(this.resourceRemoteCallback).when((Object)this.service)).onProjectContent(this.projectDiagramCallback);
        this.service.getByPath(this.path, this.projectDiagramCallback);
        ((DMNContentService)Mockito.verify((Object)this.dmnContentService)).getProjectContent(this.path, defSetId);
    }

    @Test
    public void testOnProjectContent() {
        DMNContentResource resource = (DMNContentResource)Mockito.mock(DMNContentResource.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String content = "<dmn />";
        Mockito.when((Object)resource.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)resource.getContent()).thenReturn((Object)"<dmn />");
        ((DMNClientProjectDiagramService)Mockito.doReturn(this.diagramCallback).when((Object)this.service)).getMarshallerCallback(resource, this.projectDiagramCallback);
        this.service.onProjectContent(this.projectDiagramCallback).callback((Object)resource);
        ((DMNMarshallerService)Mockito.verify((Object)this.dmnMarshallerService)).unmarshall(metadata, "<dmn />", this.diagramCallback);
    }

    @Test
    public void testGetMarshallerCallback() {
        DMNContentResource resource = (DMNContentResource)Mockito.mock(DMNContentResource.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ProjectMetadata projectMetadata = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        String name = "name";
        Mockito.when((Object)diagram.getName()).thenReturn((Object)"name");
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)resource.getMetadata()).thenReturn((Object)projectMetadata);
        this.service.getMarshallerCallback(resource, this.projectDiagramCallback).onSuccess((Object)diagram);
        ((ServiceCallback)Mockito.verify(this.projectDiagramCallback)).onSuccess(this.projectDiagramArgumentCaptor.capture());
        ProjectDiagramImpl projectDiagram = (ProjectDiagramImpl)this.projectDiagramArgumentCaptor.getValue();
        Assert.assertEquals((Object)"name", (Object)projectDiagram.getName());
        Assert.assertEquals((Object)graph, (Object)projectDiagram.getGraph());
        Assert.assertEquals((Object)projectMetadata, (Object)projectDiagram.getMetadata());
    }

    @Test
    public void testSaveOrUpdate() {
        Path path = (Path)Mockito.mock(Path.class);
        ProjectDiagram diagram = (ProjectDiagram)Mockito.mock(ProjectDiagram.class);
        org.guvnor.common.services.shared.metadata.model.Metadata metadata = (org.guvnor.common.services.shared.metadata.model.Metadata)Mockito.mock(org.guvnor.common.services.shared.metadata.model.Metadata.class);
        String comment = "comment";
        String xml = "<dmn />";
        ((DMNClientProjectDiagramService)Mockito.doReturn(this.stringCallback).when((Object)this.service)).onSaveAsXmlComplete(diagram, this.projectDiagramCallback);
        ((DMNClientProjectDiagramService)Mockito.doNothing().when((Object)this.service)).saveAsXml((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (org.guvnor.common.services.shared.metadata.model.Metadata)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ServiceCallback)ArgumentMatchers.any());
        this.service.saveOrUpdate(path, diagram, metadata, "comment", this.projectDiagramCallback);
        ((DMNMarshallerService)Mockito.verify((Object)this.dmnMarshallerService)).marshall((Diagram)ArgumentMatchers.eq((Object)diagram), (ServiceCallback)this.serviceCallbackArgumentCaptor.capture());
        ((ServiceCallback)this.serviceCallbackArgumentCaptor.getValue()).onSuccess((Object)"<dmn />");
        ((DMNClientProjectDiagramService)Mockito.verify((Object)this.service)).saveAsXml(path, "<dmn />", metadata, "comment", this.stringCallback);
    }

    @Test
    public void testAsProjectDiagramImpl() {
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        DMNContentResource resource = (DMNContentResource)Mockito.mock(DMNContentResource.class);
        ProjectMetadata metadata = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        Mockito.when((Object)diagram.getName()).thenReturn((Object)"Traffic Violation.dmn");
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)resource.getMetadata()).thenReturn((Object)metadata);
        ProjectDiagramImpl projectDiagram = this.service.asProjectDiagramImpl(diagram, resource);
        Assert.assertEquals((Object)"Traffic Violation", (Object)projectDiagram.getName());
        Assert.assertEquals((Object)graph, (Object)projectDiagram.getGraph());
        Assert.assertEquals((Object)metadata, (Object)projectDiagram.getMetadata());
    }
}

