/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLElement;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.common.LazyCanvasFocusUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectToolbarStateHandler;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.client.widgets.editor.StunnerEditor;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.project.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@DiagramEditor
@WorkbenchEditor(identifier="DMNDiagramEditor", supportedTypes={DMNDiagramResourceType.class})
public class DMNDiagramEditor
extends AbstractProjectDiagramEditor<DMNDiagramResourceType> {
    public static final String EDITOR_ID = "DMNDiagramEditor";
    protected static final int DATA_TYPES_PAGE_INDEX = 2;
    private final SessionManager sessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    private final DecisionNavigatorDock decisionNavigatorDock;
    private final LayoutHelper layoutHelper;
    private final OpenDiagramLayoutExecutor openDiagramLayoutExecutor;
    private final DataTypesPage dataTypesPage;
    private final IncludedModelsPage includedModelsPage;
    private final DMNEditorSearchIndex editorSearchIndex;
    private final SearchBarComponent<DMNSearchableElement> searchBarComponent;
    private final MonacoFEELInitializer feelInitializer;
    private final DRDNameChanger drdNameChanger;
    private final LazyCanvasFocusUtils lazyCanvasFocusUtils;
    private final DMNDiagramsSession diagramsSession;
    private final DecisionNavigatorPresenter decisionNavigatorPresenter;

    @Inject
    public DMNDiagramEditor(AbstractProjectDiagramEditor.View view, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, @DMNEditor DocumentationView documentationView, DMNDiagramResourceType resourceType, DMNEditorMenuSessionItems menuSessionItems, ProjectMessagesListener projectMessagesListener, ClientTranslationService translationService, @DMNEditor ClientProjectDiagramService projectDiagramServices, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller, StunnerEditor stunnerEditor, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, DecisionNavigatorDock decisionNavigatorDock, LayoutHelper layoutHelper, OpenDiagramLayoutExecutor openDiagramLayoutExecutor, DataTypesPage dataTypesPage, IncludedModelsPage includedModelsPage, DMNEditorSearchIndex editorSearchIndex, SearchBarComponent<DMNSearchableElement> searchBarComponent, MonacoFEELInitializer feelInitializer, DRDNameChanger drdNameChanger, LazyCanvasFocusUtils lazyCanvasFocusUtils, DMNDiagramsSession diagramsSession, DecisionNavigatorPresenter decisionNavigatorPresenter) {
        super(view, onDiagramFocusEvent, onDiagramLostFocusEvent, documentationView, (ClientResourceType)resourceType, (AbstractDiagramEditorMenuSessionItems)menuSessionItems, projectMessagesListener, translationService, projectDiagramServices, projectDiagramResourceServiceCaller, stunnerEditor);
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.decisionNavigatorDock = decisionNavigatorDock;
        this.layoutHelper = layoutHelper;
        this.openDiagramLayoutExecutor = openDiagramLayoutExecutor;
        this.dataTypesPage = dataTypesPage;
        this.includedModelsPage = includedModelsPage;
        this.editorSearchIndex = editorSearchIndex;
        this.searchBarComponent = searchBarComponent;
        this.feelInitializer = feelInitializer;
        this.drdNameChanger = drdNameChanger;
        this.lazyCanvasFocusUtils = lazyCanvasFocusUtils;
        this.diagramsSession = diagramsSession;
        this.decisionNavigatorPresenter = decisionNavigatorPresenter;
    }

    @PostConstruct
    public void init() {
        super.init();
        this.getMenuSessionItems().setErrorConsumer(e -> this.hideLoadingViews());
        this.editorSearchIndex.setCurrentAssetHashcodeSupplier(this.getGetCurrentContentHashSupplier());
        this.editorSearchIndex.setIsDataTypesTabActiveSupplier(this.getIsDataTypesTabActiveSupplier());
    }

    private void setupSessionHeaderContainer() {
        SessionDiagramPresenter presenter = this.getStunnerEditor().getPresenter();
        this.drdNameChanger.setSessionPresenterView(presenter.getView());
        presenter.getView().setSessionHeaderContainer(this.getWidget(this.drdNameChanger.getElement()));
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.doStartUp(path, place);
        this.decisionNavigatorDock.init("LibraryPerspective");
    }

    public void initialiseKieEditorForSession(ProjectDiagram diagram) {
        this.onDiagramLoad();
        this.superInitialiseKieEditorForSession(diagram);
        this.kieView.getMultiPage().addPage((Page)this.dataTypesPage);
        this.kieView.getMultiPage().addPage((Page)this.includedModelsPage);
        this.kieView.addOverviewPage(this.overviewWidget, () -> this.overviewWidget.refresh(this.versionRecordManager.getVersion()));
        this.setupSearchComponent();
    }

    void superInitialiseKieEditorForSession(ProjectDiagram diagram) {
        super.initialiseKieEditorForSession(diagram);
    }

    protected void resetEditorPages(Overview overview) {
        this.overviewWidget.setContent(overview, this.versionRecordManager.getPathToLatest());
        this.resetMetadata(overview);
        this.kieView.clear();
        this.kieView.addMainEditorPage((IsWidget)this.baseView);
    }

    protected void resetEditorPagesOnLoadError(Overview overview) {
        super.resetEditorPages(overview);
    }

    public void showDocks() {
        super.showDocks();
        this.decisionNavigatorDock.open();
    }

    public Annotation[] getDockQualifiers() {
        return new Annotation[]{new Annotation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return DMNEditor.class;
            }
        }};
    }

    public void hideDocks() {
        super.hideDocks();
        this.decisionNavigatorDock.close();
        this.decisionNavigatorDock.resetContent();
    }

    public void onMultiPageEditorSelectedPageEvent(@Observes MultiPageEditorSelectedPageEvent event) {
        if (this.isSameSession()) {
            this.searchBarComponent.disableSearch();
        }
    }

    public void onRefreshFormPropertiesEvent(@Observes RefreshFormPropertiesEvent event) {
        if (this.isSameSession()) {
            this.searchBarComponent.disableSearch();
        }
    }

    Supplier<Boolean> getIsDataTypesTabActiveSupplier() {
        return () -> {
            int selectedPageIndex = this.kieView.getMultiPage().selectedPage();
            return selectedPageIndex == 2;
        };
    }

    Supplier<Integer> getGetCurrentContentHashSupplier() {
        return this::getCurrentContentHash;
    }

    protected Integer getCurrentContentHash() {
        if (Objects.isNull(this.diagramsSession.getDMNDiagrams()) || this.diagramsSession.getDMNDiagrams().isEmpty()) {
            return super.getCurrentContentHash();
        }
        int hash = 0;
        for (DMNDiagramTuple dmnDiagram : this.diagramsSession.getDMNDiagrams()) {
            hash = HashUtil.combineHashCodes((int[])new int[]{hash, dmnDiagram.getStunnerDiagram().hashCode(), dmnDiagram.getDMNDiagram().hashCode()});
        }
        return hash;
    }

    public boolean isSaveAllowedAfterValidationFailed(Violation.Type maxSeverity) {
        return true;
    }

    void setupSearchComponent() {
        HTMLElement element = this.searchBarComponent.getView().getElement();
        this.searchBarComponent.init((EditorSearchIndex)this.editorSearchIndex);
        this.kieView.getMultiPage().addTabBarWidget(this.getWidget(element));
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.kieView.getMultiPage().selectPage(2);
    }

    public void open(ProjectDiagram diagram, final SessionPresenter.SessionPresenterCallback callback) {
        final AbstractSession currentSession = !this.getStunnerEditor().isClosed() ? (AbstractSession)this.getStunnerEditor().getSession() : null;
        this.layoutHelper.applyLayout((Diagram)diagram, (LayoutExecutor)this.openDiagramLayoutExecutor);
        this.feelInitializer.initializeFEELEditor();
        this.decisionNavigatorPresenter.setIsRefreshComponentsViewSuspended(true);
        super.open(diagram, new SessionPresenter.SessionPresenterCallback(){

            public void onSuccess() {
                DMNDiagramEditor.this.setupSessionHeaderContainer();
                callback.onSuccess();
                if (null != currentSession) {
                    currentSession.close();
                }
                DMNDiagramEditor.this.decisionNavigatorPresenter.setIsRefreshComponentsViewSuspended(false);
                DMNDiagramEditor.this.decisionNavigatorPresenter.refreshComponentsView();
            }

            public void onError(ClientRuntimeError error) {
                DMNDiagramEditor.this.decisionNavigatorPresenter.setIsRefreshComponentsViewSuspended(false);
                callback.onError(error);
            }
        });
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
        super.doClose();
        this.dataTypesPage.disableShortcuts();
        super.onClose();
    }

    void onDiagramLoad() {
        if (null != this.getStunnerEditor().getCanvasHandler()) {
            ExpressionEditorView.Presenter expressionEditor = ((DMNSession)this.getStunnerEditor().getSession()).getExpressionEditor();
            expressionEditor.setToolbarStateHandler((ToolbarStateHandler)new DMNProjectToolbarStateHandler(this.getMenuSessionItems()));
            this.decisionNavigatorDock.reload();
            this.dataTypesPage.reload();
            this.includedModelsPage.reload();
            this.lazyCanvasFocusUtils.releaseFocus();
        }
    }

    @OnFocus
    public void onFocus() {
        if (!this.getStunnerEditor().isClosed()) {
            this.getStunnerEditor().focus();
            this.onDiagramLoad();
        }
        this.dataTypesPage.onFocus();
        this.dataTypesPage.enableShortcuts();
    }

    @OnLostFocus
    public void onLostFocus() {
        if (!this.getStunnerEditor().isClosed()) {
            this.getStunnerEditor().lostFocus();
        }
        this.dataTypesPage.onLostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getStunnerEditor().getCurrentContentHash()));
    }

    public String getEditorIdentifier() {
        return EDITOR_ID;
    }

    public void onDataTypeEditModeToggle(@Observes DataTypeEditModeToggleEvent event) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)this.getOnDataTypeEditModeToggleCallback(event), (double)250.0, (Object[])new Object[0]);
    }

    DomGlobal.SetTimeoutCallbackFn getOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        return e -> {
            if (event.isEditModeEnabled()) {
                this.disableMenuItem(MenuItems.SAVE);
            } else {
                this.enableMenuItem(MenuItems.SAVE);
            }
        };
    }

    void onEditExpressionEvent(@Observes EditExpressionEvent event) {
        this.searchBarComponent.disableSearch();
        if (this.isSameSession(event.getSession())) {
            DMNSession session = (DMNSession)this.getStunnerEditor().getSession();
            ExpressionEditorView.Presenter expressionEditor = session.getExpressionEditor();
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)session.getCanvasHandler()), (Command)new NavigateToExpressionEditorCommand(expressionEditor, (SessionPresenter)this.getStunnerEditor().getPresenter(), this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, event.getNodeUUID(), event.getHasExpression(), event.getHasName(), event.isOnlyVisualChangeAllowed()));
        }
    }

    ElementWrapperWidget<?> getWidget(HTMLElement element) {
        return ElementWrapperWidget.getWidget((HTMLElement)element);
    }

    private boolean isSameSession() {
        return this.isSameSession(this.sessionManager.getCurrentSession());
    }
}

