/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import elemental2.dom.HTMLElement;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.common.LazyCanvasFocusUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.project.client.editor.DMNDiagramEditor;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.client.widgets.editor.StunnerEditor;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorTest;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.widgets.client.docks.DefaultEditorDock;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={PathPlaceRequest.class})
public class DMNDiagramEditorTest
extends AbstractProjectDiagramEditorTest {
    @Mock
    private PlaceRequest currentPlace;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNEditorSession dmnEditorSession;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    private EditExpressionEvent editExpressionEvent;
    @Mock
    private DMNEditorMenuSessionItems dmnProjectMenuSessionItems;
    @Mock
    private LayoutHelper layoutHelper;
    @Mock
    private OpenDiagramLayoutExecutor layoutExecutor;
    @Mock
    private DataTypesPage dataTypesPage;
    @Mock
    private IncludedModelsPage includedModelsPage;
    @Mock
    private MultiPageEditor multiPage;
    @Mock
    private DefaultEditorDock docks;
    @Mock
    private DMNEditorSearchIndex editorSearchIndex;
    @Mock
    private SearchBarComponent<DMNSearchableElement> searchBarComponent;
    @Mock
    private SearchBarComponent.View searchBarComponentView;
    @Mock
    private HTMLElement searchBarComponentViewElement;
    @Mock
    private MonacoFEELInitializer feelInitializer;
    @Mock
    private ElementWrapperWidget searchBarComponentWidget;
    @Mock
    private HTMLElement drdNameChangerElement;
    @Mock
    private DRDNameChanger drdNameChanger;
    @Mock
    private LazyCanvasFocusUtils lazyCanvasFocusUtils;
    @Mock
    private ElementWrapperWidget drdNameWidget;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Captor
    private ArgumentCaptor<Consumer<String>> errorConsumerCaptor;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    @Mock
    private SessionPresenter.View presenterView;
    @Mock
    private SessionDiagramPresenter presenter;
    @Mock
    private DecisionNavigatorPresenter decisionNavigatorPresenter;
    private DMNDiagramEditor diagramEditor;

    @Before
    public void before() {
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)this.multiPage);
    }

    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.stunnerEditor.getSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.searchBarComponent.getView()).thenReturn((Object)this.searchBarComponentView);
        Mockito.when((Object)this.searchBarComponentView.getElement()).thenReturn((Object)this.searchBarComponentViewElement);
        Mockito.when((Object)this.drdNameChanger.getElement()).thenReturn((Object)this.drdNameChangerElement);
        Mockito.when((Object)this.dmnProjectMenuSessionItems.setErrorConsumer((Consumer)Mockito.any())).thenReturn((Object)this.dmnProjectMenuSessionItems);
        Mockito.when((Object)this.dmnProjectMenuSessionItems.setLoadingCompleted((Command)Mockito.any())).thenReturn((Object)this.dmnProjectMenuSessionItems);
        Mockito.when((Object)this.dmnProjectMenuSessionItems.setLoadingStarts((Command)Mockito.any())).thenReturn((Object)this.dmnProjectMenuSessionItems);
        DMNDiagramResourceType resourceType = (DMNDiagramResourceType)Mockito.mock(DMNDiagramResourceType.class);
        Mockito.when((Object)resourceType.getSuffix()).thenReturn((Object)"dmn");
        Mockito.when((Object)resourceType.getShortName()).thenReturn((Object)"DMN");
        this.diagramEditor = (DMNDiagramEditor)Mockito.spy((Object)new DMNDiagramEditor(this.view, this.onDiagramFocusEvent, this.onDiagramLostFocusEvent, this.documentationView, resourceType, this.dmnProjectMenuSessionItems, this.projectMessagesListener, this.translationService, this.projectDiagramServices, this.projectDiagramResourceServiceCaller, this.stunnerEditor, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, (Event)this.refreshFormPropertiesEvent, this.decisionNavigatorDock, this.layoutHelper, this.layoutExecutor, this.dataTypesPage, this.includedModelsPage, this.editorSearchIndex, (SearchBarComponent)this.searchBarComponent, this.feelInitializer, this.drdNameChanger, this.lazyCanvasFocusUtils, this.dmnDiagramsSession, this.decisionNavigatorPresenter){
            {
                this.docks = DMNDiagramEditorTest.this.docks;
                this.fileMenuBuilder = DMNDiagramEditorTest.this.fileMenuBuilder;
                this.workbenchContext = DMNDiagramEditorTest.this.workbenchContext;
                this.projectController = DMNDiagramEditorTest.this.projectController;
                this.versionRecordManager = DMNDiagramEditorTest.this.versionRecordManager;
                this.alertsButtonMenuItemBuilder = DMNDiagramEditorTest.this.alertsButtonMenuItemBuilder;
                this.kieView = DMNDiagramEditorTest.this.kieView;
                this.overviewWidget = DMNDiagramEditorTest.this.overviewWidget;
                this.notification = DMNDiagramEditorTest.this.notification;
                this.placeManager = DMNDiagramEditorTest.this.placeManager;
                this.changeTitleNotification = DMNDiagramEditorTest.this.changeTitleNotification;
                this.savePopUpPresenter = DMNDiagramEditorTest.this.savePopUpPresenter;
                this.saveAndRenameCommandBuilder = DMNDiagramEditorTest.this.saveAndRenameCommandBuilder;
            }
        });
        ((DMNDiagramEditor)Mockito.doReturn((Object)this.searchBarComponentWidget).when((Object)this.diagramEditor)).getWidget((HTMLElement)ArgumentMatchers.any());
        ((DMNDiagramEditor)Mockito.doReturn((Object)this.drdNameWidget).when((Object)this.diagramEditor)).getWidget((HTMLElement)ArgumentMatchers.eq((Object)this.drdNameChangerElement));
        ((StunnerEditor)Mockito.doNothing().when((Object)this.stunnerEditor)).focus();
        ((StunnerEditor)Mockito.doNothing().when((Object)this.stunnerEditor)).lostFocus();
        Mockito.when((Object)this.presenter.getView()).thenReturn((Object)this.presenterView);
        Mockito.when((Object)this.stunnerEditor.getPresenter()).thenReturn((Object)this.presenter);
        Mockito.when((Object)this.stunnerEditor.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.stunnerEditor.getView()).thenReturn((Object)this.view);
    }

    @Test
    public void testInit() {
        Supplier<Boolean> isDataTypesTabActiveSupplier = () -> true;
        Supplier<Integer> currentContentHashSupplier = () -> 123;
        ((DMNDiagramEditor)Mockito.doReturn(isDataTypesTabActiveSupplier).when((Object)this.diagramEditor)).getIsDataTypesTabActiveSupplier();
        ((DMNDiagramEditor)Mockito.doReturn(currentContentHashSupplier).when((Object)this.diagramEditor)).getGetCurrentContentHashSupplier();
        this.diagramEditor.init();
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.dmnProjectMenuSessionItems, (VerificationMode)Mockito.atLeast((int)1))).setErrorConsumer((Consumer)this.errorConsumerCaptor.capture());
        ((Consumer)this.errorConsumerCaptor.getValue()).accept("ERROR");
        ((AbstractProjectDiagramEditor.View)Mockito.verify((Object)this.view)).hideBusyIndicator();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).showMessage((String)Mockito.any());
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).showError((String)Mockito.any());
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex)).setIsDataTypesTabActiveSupplier(isDataTypesTabActiveSupplier);
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex)).setCurrentAssetHashcodeSupplier(currentContentHashSupplier);
    }

    @Test
    public void testGetIsDataTypesTabActiveSupplierWhenDataTypesTabIsActive() {
        Mockito.when((Object)this.multiPage.selectedPage()).thenReturn((Object)2);
        Assert.assertTrue((boolean)((Boolean)this.diagramEditor.getIsDataTypesTabActiveSupplier().get()));
    }

    @Test
    public void testGetIsDataTypesTabActiveSupplierWhenDataTypesTabIsNotActive() {
        Mockito.when((Object)this.multiPage.selectedPage()).thenReturn((Object)3);
        Assert.assertFalse((boolean)((Boolean)this.diagramEditor.getIsDataTypesTabActiveSupplier().get()));
    }

    @Test
    public void testOnStartup() {
        this.diagramEditor.onStartup(this.filePath, this.currentPlace);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init((String)ArgumentMatchers.eq((Object)"LibraryPerspective"));
    }

    @Test
    public void testOnClose() {
        this.diagramEditor.onClose();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).disableShortcuts();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).clear();
    }

    @Test
    public void testInitialiseKieEditorForSession() {
        this.diagramEditor.initialiseKieEditorForSession(this.diagram);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addPage((Page)this.dataTypesPage);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addPage((Page)this.includedModelsPage);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).setupSearchComponent();
    }

    @Test
    public void testInitialiseKieEditorForSessionWhenInitializingKieEditorForSessionThenDiagramAlreadyLoaded() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.diagramEditor});
        this.diagramEditor.initialiseKieEditorForSession(this.diagram);
        ((DMNDiagramEditor)inOrder.verify((Object)this.diagramEditor)).onDiagramLoad();
        ((DMNDiagramEditor)inOrder.verify((Object)this.diagramEditor)).superInitialiseKieEditorForSession((ProjectDiagram)ArgumentMatchers.any());
    }

    @Test
    public void testSetupSearchComponent() {
        this.diagramEditor.setupSearchComponent();
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).init((EditorSearchIndex)this.editorSearchIndex);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addTabBarWidget((IsWidget)this.searchBarComponentWidget);
    }

    @Test
    public void testOnFocus() {
        Mockito.when((Object)this.stunnerEditor.isClosed()).thenReturn((Object)false);
        this.diagramEditor.onFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor)).focus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).lostFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).onDiagramLoad();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).onLostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).enableShortcuts();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).disableShortcuts();
    }

    @Test
    public void testOnFocusWithClosedEditor() {
        Mockito.when((Object)this.stunnerEditor.isClosed()).thenReturn((Object)true);
        this.diagramEditor.onFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).focus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).lostFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor, (VerificationMode)Mockito.never())).onDiagramLoad();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).enableShortcuts();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).onLostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).disableShortcuts();
    }

    @Test
    public void testOnLostFocus() {
        Mockito.when((Object)this.stunnerEditor.isClosed()).thenReturn((Object)false);
        this.diagramEditor.onLostFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor)).lostFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).focus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onLostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).onFocus();
    }

    @Test
    public void testOnLostFocusWithClosedEditor() {
        Mockito.when((Object)this.stunnerEditor.isClosed()).thenReturn((Object)true);
        this.diagramEditor.onLostFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).lostFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.never())).focus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onLostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).onFocus();
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.diagramEditor.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).selectPage(2);
    }

    @Test
    public void testOnDataTypeEditModeToggleWhenEditModeIsEnabled() {
        DataTypeEditModeToggleEvent editModeToggleEvent = (DataTypeEditModeToggleEvent)Mockito.mock(DataTypeEditModeToggleEvent.class);
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).disableMenuItem((MenuItems)ArgumentMatchers.any());
        Mockito.when((Object)editModeToggleEvent.isEditModeEnabled()).thenReturn((Object)true);
        this.diagramEditor.getOnDataTypeEditModeToggleCallback(editModeToggleEvent).onInvoke(new Object[0]);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).disableMenuItem(MenuItems.SAVE);
    }

    @Test
    public void testOnDataTypeEditModeToggleWhenEditModeIsNotEnabled() {
        DataTypeEditModeToggleEvent editModeToggleEvent = (DataTypeEditModeToggleEvent)Mockito.mock(DataTypeEditModeToggleEvent.class);
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).enableMenuItem((MenuItems)ArgumentMatchers.any());
        Mockito.when((Object)editModeToggleEvent.isEditModeEnabled()).thenReturn((Object)false);
        this.diagramEditor.getOnDataTypeEditModeToggleCallback(editModeToggleEvent).onInvoke(new Object[0]);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).enableMenuItem(MenuItems.SAVE);
    }

    @Test
    public void testShowDocks() {
        this.diagramEditor.showDocks();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).open();
        ((DefaultEditorDock)Mockito.verify((Object)this.docks)).show();
    }

    @Test
    public void testHideDocks() {
        this.diagramEditor.hideDocks();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
        ((DefaultEditorDock)Mockito.verify((Object)this.docks)).hide();
    }

    public void testDocksQualifiers() {
        Annotation[] qualifiers = this.diagramEditor.getDockQualifiers();
        Assert.assertEquals((long)1L, (long)qualifiers.length);
        Assert.assertEquals(DMNEditor.class, qualifiers[0].annotationType());
    }

    @Test
    public void testOnEditExpressionEvent() {
        Mockito.when((Object)this.editExpressionEvent.getSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.diagramEditor.open(this.diagram);
        this.diagramEditor.onEditExpressionEvent(this.editExpressionEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)((AbstractCanvasHandler)ArgumentMatchers.eq((Object)this.canvasHandler)), (org.kie.workbench.common.stunner.core.command.Command)Mockito.any());
    }

    @Test
    public void testCloseExistingSessionIfAny() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.stunnerEditor.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.stunnerEditor.getSession()).thenReturn((Object)this.dmnEditorSession);
        this.diagramEditor.open(this.diagram);
        ((DMNEditorSession)Mockito.verify((Object)this.dmnEditorSession, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNotNull() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.diagramEditor.open(this.diagram);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.atLeast((int)1))).reload();
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.expressionEditor, (VerificationMode)Mockito.atLeast((int)1))).setToolbarStateHandler((ToolbarStateHandler)Mockito.any());
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.atLeast((int)1))).reload();
        ((LayoutHelper)Mockito.verify((Object)this.layoutHelper)).applyLayout((Diagram)this.diagram, (LayoutExecutor)this.layoutExecutor);
        ((IncludedModelsPage)Mockito.verify((Object)this.includedModelsPage, (VerificationMode)Mockito.atLeast((int)1))).reload();
        ((LazyCanvasFocusUtils)Mockito.verify((Object)this.lazyCanvasFocusUtils, (VerificationMode)Mockito.atLeast((int)1))).releaseFocus();
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNull() {
        Mockito.when((Object)this.stunnerEditor.getCanvasHandler()).thenReturn(null);
        this.diagramEditor.onDiagramLoad();
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.expressionEditor, (VerificationMode)Mockito.never())).setToolbarStateHandler((ToolbarStateHandler)Mockito.any());
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).reload();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).open();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).reload();
        ((IncludedModelsPage)Mockito.verify((Object)this.includedModelsPage, (VerificationMode)Mockito.never())).reload();
        ((LazyCanvasFocusUtils)Mockito.verify((Object)this.lazyCanvasFocusUtils, (VerificationMode)Mockito.never())).releaseFocus();
    }

    @Test
    public void testOnMultiPageEditorSelectedPageEvent() {
        this.diagramEditor.open(this.diagram);
        this.diagramEditor.onMultiPageEditorSelectedPageEvent((MultiPageEditorSelectedPageEvent)Mockito.mock(MultiPageEditorSelectedPageEvent.class));
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testOnRefreshFormPropertiesEvent() {
        this.diagramEditor.onRefreshFormPropertiesEvent((RefreshFormPropertiesEvent)Mockito.mock(RefreshFormPropertiesEvent.class));
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testTabContentOrdering() {
        Mockito.when((Object)this.documentationView.isEnabled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.documentationView.initialize((Diagram)this.diagram)).thenReturn((Object)this.documentationView);
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)this.multiPage);
        this.diagramEditor.open(this.diagram);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.kieView, this.multiPage});
        ((KieEditorWrapperView)inOrder.verify((Object)this.kieView)).addMainEditorPage((IsWidget)this.view);
        ((KieEditorWrapperView)inOrder.verify((Object)this.kieView)).addPage((Page)Mockito.any());
        ((MultiPageEditor)inOrder.verify((Object)this.multiPage)).addPage((Page)this.dataTypesPage);
        ((MultiPageEditor)inOrder.verify((Object)this.multiPage)).addPage((Page)this.includedModelsPage);
        ((KieEditorWrapperView)inOrder.verify((Object)this.kieView)).addOverviewPage((OverviewWidgetPresenter)ArgumentMatchers.eq((Object)this.overviewWidget), (com.google.gwt.user.client.Command)Mockito.any());
    }

    @Test
    public void testLoadContentWithInvalidFile() {
        super.testLoadContentWithInvalidFile();
        ((MonacoFEELInitializer)Mockito.verify((Object)this.feelInitializer, (VerificationMode)Mockito.never())).initializeFEELEditor();
    }

    @Test
    public void testSaveEvenIfValidationNotSuccessful() {
        Assert.assertTrue((boolean)this.diagramEditor.isSaveAllowedAfterValidationFailed(Violation.Type.INFO));
        Assert.assertTrue((boolean)this.diagramEditor.isSaveAllowedAfterValidationFailed(Violation.Type.WARNING));
        Assert.assertTrue((boolean)this.diagramEditor.isSaveAllowedAfterValidationFailed(Violation.Type.ERROR));
    }
}

