/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import javax.enterprise.event.Event;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.project.client.editor.DMNDiagramEditor;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorTest;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={PathPlaceRequest.class})
public class DMNDiagramEditorTest
extends AbstractProjectDiagramEditorTest {
    @Mock
    private PlaceRequest currentPlace;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private DecisionNavigatorDock decisionNavigatorDock;
    private DMNDiagramEditor diagramEditor;

    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.resourceType.getSuffix()).thenReturn((Object)"dmn");
    }

    protected DMNDiagramResourceType mockResourceType() {
        DMNDiagramResourceType resourceType = (DMNDiagramResourceType)Mockito.mock(DMNDiagramResourceType.class);
        Mockito.when((Object)resourceType.getSuffix()).thenReturn((Object)"dmn");
        Mockito.when((Object)resourceType.getShortName()).thenReturn((Object)"DMN");
        return resourceType;
    }

    protected AbstractProjectDiagramEditor createDiagramEditor() {
        this.diagramEditor = (DMNDiagramEditor)Mockito.spy((Object)new DMNDiagramEditor(this.view, this.placeManager, this.errorPopupPresenter, (Event)this.changeTitleNotificationEvent, this.savePopUpPresenter, (DMNDiagramResourceType)this.getResourceType(), this.clientProjectDiagramService, this.sessionEditorPresenters, this.sessionViewerPresenters, this.getMenuSessionItems(), (Event)this.onDiagramFocusEvent, (Event)this.onDiagramLostFocusEvent, this.projectMessagesListener, this.diagramClientErrorHandler, this.translationService, this.xmlEditorView, this.projectDiagramResourceServiceCaller, this.decisionNavigatorDock){
            {
                this.fileMenuBuilder = DMNDiagramEditorTest.this.fileMenuBuilder;
                this.workbenchContext = DMNDiagramEditorTest.this.workbenchContext;
                this.projectController = DMNDiagramEditorTest.this.projectController;
                this.versionRecordManager = DMNDiagramEditorTest.this.versionRecordManager;
                DMNDiagramEditorTest.this.sessionEditorPresenters = DMNDiagramEditorTest.this.sessionEditorPresenters;
                this.alertsButtonMenuItemBuilder = DMNDiagramEditorTest.this.alertsButtonMenuItemBuilder;
                this.kieView = DMNDiagramEditorTest.this.kieView;
                this.overviewWidget = DMNDiagramEditorTest.this.overviewWidget;
                this.notification = DMNDiagramEditorTest.this.notification;
            }
        });
        return this.diagramEditor;
    }

    @Test
    public void testOnStartup() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoStartUp(this.filePath, this.currentPlace);
        this.diagramEditor.onStartup(this.filePath, this.currentPlace);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoStartUp(this.filePath, this.currentPlace);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("LibraryPerspective");
    }

    @Test
    public void testOnClose() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superOnClose();
        this.diagramEditor.onClose();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superOnClose();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNotNull() {
        Mockito.when((Object)this.editorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.open();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).setupContent((CanvasHandler)Matchers.eq((Object)this.canvasHandler));
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).open();
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNull() {
        this.diagramEditor.onDiagramLoad();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).setupContent((CanvasHandler)Matchers.any());
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).open();
    }

    @Test
    public void testOnFocus() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoFocus();
        this.diagramEditor.onFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).onDiagramLoad();
    }

    public void testOpen() {
    }

    public void testFormatTitle() {
    }
}

