/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class PointUtils {
    private PointUtils() {
    }

    public static JSIPoint point2dToDMNDIPoint(Point2D point2d) {
        JSIPoint result = new JSIPoint();
        result.setX(point2d.getX());
        result.setY(point2d.getY());
        return result;
    }

    public static Point2D dmndiPointToPoint2D(JSIPoint dmndiPoint) {
        Point2D result = new Point2D(dmndiPoint.getX(), dmndiPoint.getY());
        return result;
    }

    public static void convertToAbsoluteBounds(Node<?, ?> targetNode) {
        PointUtils.convertBounds(targetNode, (base, delta) -> base + delta);
    }

    public static void convertToRelativeBounds(Node<?, ?> targetNode) {
        PointUtils.convertBounds(targetNode, (base, delta) -> base - delta);
    }

    private static void convertBounds(Node<?, ?> targetNode, BiFunction<Double, Double, Double> convertor) {
        if (targetNode.getContent() instanceof View) {
            View targetNodeView = (View)targetNode.getContent();
            double boundsX = PointUtils.xOfBound(PointUtils.upperLeftBound(targetNodeView));
            double boundsY = PointUtils.yOfBound(PointUtils.upperLeftBound(targetNodeView));
            double boundsWidth = PointUtils.xOfBound(PointUtils.lowerRightBound(targetNodeView)) - boundsX;
            double boundsHeight = PointUtils.yOfBound(PointUtils.lowerRightBound(targetNodeView)) - boundsY;
            List inEdges = targetNode.getInEdges();
            for (Edge e : inEdges) {
                if (!(e.getContent() instanceof Child)) continue;
                Node sourceNode = e.getSourceNode();
                View sourceView = (View)sourceNode.getContent();
                Bound sourceViewULBound = sourceView.getBounds().getUpperLeft();
                double dx = sourceViewULBound.getX();
                double dy = sourceViewULBound.getY();
                boundsX = convertor.apply(boundsX, dx);
                boundsY = convertor.apply(boundsY, dy);
                targetNodeView.setBounds(Bounds.create((double)boundsX, (double)boundsY, (double)(boundsX + boundsWidth), (double)(boundsY + boundsHeight)));
                break;
            }
        }
    }

    public static double xOfShape(JSIDMNShape shape) {
        return PointUtils.extractValue(shape, bounds -> {
            JSIBounds _bounds = (JSIBounds)Js.uncheckedCast((Object)bounds);
            return _bounds.getX();
        });
    }

    public static double yOfShape(JSIDMNShape shape) {
        return PointUtils.extractValue(shape, bounds -> {
            JSIBounds _bounds = (JSIBounds)Js.uncheckedCast((Object)bounds);
            return _bounds.getY();
        });
    }

    public static double widthOfShape(JSIDMNShape shape) {
        return PointUtils.extractValue(shape, bounds -> {
            JSIBounds _bounds = (JSIBounds)Js.uncheckedCast((Object)bounds);
            return _bounds.getWidth();
        });
    }

    public static double heightOfShape(JSIDMNShape shape) {
        return PointUtils.extractValue(shape, bounds -> {
            JSIBounds _bounds = (JSIBounds)Js.uncheckedCast((Object)bounds);
            return _bounds.getHeight();
        });
    }

    public static Bound upperLeftBound(View view) {
        return PointUtils.extractBounds(view, Bounds::getUpperLeft);
    }

    public static Bound lowerRightBound(View view) {
        return PointUtils.extractBounds(view, Bounds::getLowerRight);
    }

    public static double xOfBound(Bound bound) {
        return PointUtils.extractBound(bound, Bound::getX);
    }

    public static double yOfBound(Bound bound) {
        return PointUtils.extractBound(bound, Bound::getY);
    }

    private static double extractValue(JSIDMNShape shape, Function<JSIBounds, Double> extractor) {
        JSIDMNShape _shape;
        if (Objects.nonNull(shape) && Objects.nonNull((_shape = (JSIDMNShape)Js.uncheckedCast((Object)shape)).getBounds())) {
            JSIBounds bounds = (JSIBounds)Js.uncheckedCast((Object)_shape.getBounds());
            return extractor.apply(bounds);
        }
        return 0.0;
    }

    private static Bound extractBounds(View view, Function<Bounds, Bound> extractor) {
        if (Objects.nonNull(view) && Objects.nonNull(view.getBounds())) {
            return extractor.apply(view.getBounds());
        }
        return null;
    }

    private static double extractBound(Bound bound, Function<Bound, Double> extractor) {
        if (Objects.nonNull(bound)) {
            return extractor.apply(bound);
        }
        return 0.0;
    }
}

