/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.editor;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.DMNEditorMenuItemsBuilder;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.session.DMNEditorSessionCommands;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CutSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToJpgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPdfSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPngSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToRawFormatSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToSvgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.PasteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.PerformAutomaticLayoutCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RedoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SwitchGridSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.UndoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.VisitGraphSessionCommand;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class DMNEditorMenuSessionItemsTest {
    @Mock
    private FileMenuBuilder fileMenuBuilder;
    @Mock
    private DMNEditorMenuItemsBuilder itemsBuilder;
    @Mock
    private DMNEditorSessionCommands sessionCommands;
    @Mock
    private ClientTranslationService translationService;
    @GwtMock
    private Button button;
    private DMNEditorMenuSessionItems sessionItems;

    @Before
    public void setup() {
        this.sessionItems = (DMNEditorMenuSessionItems)Mockito.spy((Object)new DMNEditorMenuSessionItems(this.itemsBuilder, this.sessionCommands));
        Mockito.when((Object)this.fileMenuBuilder.addNewTopLevelMenu((MenuItem)Matchers.any(MenuItem.class))).thenReturn((Object)this.fileMenuBuilder);
        Mockito.when((Object)this.sessionItems.getTranslationService()).thenReturn((Object)this.translationService);
        Mockito.when((Object)this.translationService.getValue(Matchers.anyString())).thenAnswer(i -> i.getArguments()[0]);
    }

    @Test
    public void testPopulateMenu() {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((DMNEditorMenuSessionItems)Mockito.doNothing().when((Object)this.sessionItems)).superPopulateMenu((FileMenuBuilder)Matchers.any());
        ((DMNEditorMenuSessionItems)Mockito.doReturn((Object)menuItem).when((Object)this.sessionItems)).newPerformAutomaticLayout();
        this.sessionItems.populateMenu(this.fileMenuBuilder);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).addPerformAutomaticLayout((FileMenuBuilder)Matchers.any());
    }

    @Test
    public void testPerformAutomaticLayoutMenuItem() {
        PerformAutomaticLayoutCommand command = (PerformAutomaticLayoutCommand)Mockito.mock(PerformAutomaticLayoutCommand.class);
        ArgumentCaptor clickHandlerArgumentCaptor = ArgumentCaptor.forClass(ClickHandler.class);
        Mockito.when((Object)this.sessionCommands.getPerformAutomaticLayoutCommand()).thenReturn((Object)command);
        this.sessionItems.newPerformAutomaticLayout();
        ((Button)Mockito.verify((Object)this.button)).setSize(ButtonSize.SMALL);
        ((Button)Mockito.verify((Object)this.button)).setTitle("org.kie.workbench.common.stunner.core.client.toolbox.PerformAutomaticLayout");
        ((Button)Mockito.verify((Object)this.button)).setIcon(IconType.SITEMAP);
        ((Button)Mockito.verify((Object)this.button)).addClickHandler((ClickHandler)clickHandlerArgumentCaptor.capture());
        ClickHandler clickHandler = (ClickHandler)clickHandlerArgumentCaptor.getValue();
        clickHandler.onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((PerformAutomaticLayoutCommand)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testEnableMenu() {
        this.testMenu(true);
    }

    @Test
    public void testDisableMenu() {
        this.testMenu(false);
    }

    private void testMenu(boolean enabled) {
        this.sessionItems.setEnabled(enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ClearSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(VisitGraphSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(SwitchGridSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ValidateSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ExportToJpgSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ExportToPngSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ExportToSvgSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ExportToPdfSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(ExportToRawFormatSessionCommand.class, enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(DeleteSelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(UndoSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(RedoSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(CopySelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(CutSelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(PasteSelectionSessionCommand.class, false);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)this.sessionItems)).setItemEnabled(PerformAutomaticLayoutCommand.class, enabled);
    }
}

