/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.DMNClientDiagramServiceImpl;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNClientDiagramServiceImplTest {
    private DMNClientDiagramServiceImpl service;

    @Before
    public void setup() {
        this.service = (DMNClientDiagramServiceImpl)Mockito.spy((Object)new DMNClientDiagramServiceImpl());
    }

    @Test
    public void testTransformWhenFileIsNew() {
        String fileName = "file.dmn";
        String xml = "";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        String title = "file";
        ((DMNClientDiagramServiceImpl)Mockito.doNothing().when((Object)this.service)).doNewDiagram("file", callback);
        this.service.transform("file.dmn", "", callback);
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.service)).doNewDiagram("file", callback);
    }

    @Test
    public void testTransformWhenFileIsNotNew() {
        String fileName = "file.dmn";
        String xml = "xml";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        String title = "title";
        ((DMNClientDiagramServiceImpl)Mockito.doNothing().when((Object)this.service)).doNewDiagram("title", callback);
        this.service.transform("file.dmn", "xml", callback);
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).doNewDiagram("title", callback);
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.service)).doTransformation("xml", callback);
    }

    @Test
    public void testGetDiagramTitleWhenIsEmpty() {
        String expected = "some uuid";
        ((DMNClientDiagramServiceImpl)Mockito.doReturn((Object)"some uuid").when((Object)this.service)).generateDiagramTitle();
        String actual = this.service.getDiagramTitle("");
        Assert.assertEquals((Object)"some uuid", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsFileName() {
        String fileName = "file.dmn";
        String expected = "file";
        String actual = this.service.getDiagramTitle("file.dmn");
        Assert.assertEquals((Object)"file", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsWindowsPath() {
        String fileName = "C:\\my path\\folder\\file.dmn";
        String expected = "file";
        String actual = this.service.getDiagramTitle("C:\\my path\\folder\\file.dmn");
        Assert.assertEquals((Object)"file", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsUnixPath() {
        String fileName = "/users/user/file.dmn";
        String expected = "file";
        String actual = this.service.getDiagramTitle("/users/user/file.dmn");
        Assert.assertEquals((Object)"file", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsWindowsPathMoreWords() {
        String fileName = "C:\\my path\\folder\\file a.dmn";
        String expected = "file a";
        String actual = this.service.getDiagramTitle("C:\\my path\\folder\\file a.dmn");
        Assert.assertEquals((Object)"file a", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsUnixPathMoreWords() {
        String fileName = "/users/user/file a.dmn";
        String expected = "file a";
        String actual = this.service.getDiagramTitle("/users/user/file a.dmn");
        Assert.assertEquals((Object)"file a", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenMoreDotsContained() {
        String fileName = "/users/user/file.template.dmn";
        String expected = "file.template";
        String actual = this.service.getDiagramTitle("/users/user/file.template.dmn");
        Assert.assertEquals((Object)"file.template", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsNotFileNameOrEmpty() {
        String fileName = "Something";
        String expected = "Something";
        String actual = this.service.getDiagramTitle("Something");
        Assert.assertEquals((Object)"Something", (Object)actual);
    }
}

