/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ExpressionLanguagePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ImportConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils.NameSpaceUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

public class DefinitionsConverter {
    public static Definitions wbFromDMN(JSITDefinitions dmn, Map<JSITImport, JSITDefinitions> importDefinitions, Map<JSITImport, PMMLDocumentMetadata> pmmlDocuments) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Name name = new Name(dmn.getName());
        String namespace = dmn.getNamespace();
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Definitions result = new Definitions();
        result.setId(id);
        result.setName(name);
        result.setNamespace(new Text(namespace));
        result.getNsContext().putIfAbsent(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix(), namespace);
        result.setExpressionLanguage(ExpressionLanguagePropertyConverter.wbFromDMN(dmn.getExpressionLanguage()));
        result.setTypeLanguage(dmn.getTypeLanguage());
        result.setDescription(description);
        Map<String, String> namespaces = NameSpaceUtils.extractNamespacesKeyedByPrefix((JSITDMNElement)dmn);
        for (Map.Entry<String, String> kv : namespaces.entrySet()) {
            String mappedURI;
            switch (mappedURI = kv.getValue()) {
                case "http://www.omg.org/spec/DMN/20151101/dmn.xsd": {
                    mappedURI = "http://www.omg.org/spec/DMN/20180521/MODEL/";
                    break;
                }
                case "http://www.omg.org/spec/FEEL/20140401": {
                    mappedURI = "http://www.omg.org/spec/DMN/20180521/FEEL/";
                    break;
                }
                case "http://www.drools.org/kie/dmn/1.1": {
                    mappedURI = "http://www.drools.org/kie/dmn/1.2";
                }
            }
            if (kv.getKey().equalsIgnoreCase(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix())) {
                result.getNsContext().putIfAbsent(kv.getKey(), mappedURI);
                continue;
            }
            result.getNsContext().put(kv.getKey(), mappedURI);
        }
        List jsiItemDefinitions = dmn.getItemDefinition();
        for (int i = 0; i < jsiItemDefinitions.size(); ++i) {
            JSITItemDefinition jsiItemDefinition = (JSITItemDefinition)Js.uncheckedCast(jsiItemDefinitions.get(i));
            ItemDefinition itemDefConverted = ItemDefinitionPropertyConverter.wbFromDMN(jsiItemDefinition);
            if (!Objects.nonNull(itemDefConverted)) continue;
            itemDefConverted.setParent((DMNModelInstrumentedBase)result);
            result.getItemDefinition().add(itemDefConverted);
        }
        List jsiImports = dmn.getImport();
        for (int i = 0; i < jsiImports.size(); ++i) {
            PMMLDocumentMetadata pmmlDocument;
            JSITDefinitions definitions;
            JSITImport jsiImport = (JSITImport)Js.uncheckedCast(jsiImports.get(i));
            Import importConverted = ImportConverter.wbFromDMN(jsiImport, definitions = importDefinitions.get(jsiImport), pmmlDocument = pmmlDocuments.get(jsiImport));
            if (!Objects.nonNull(importConverted)) continue;
            importConverted.setParent((DMNModelInstrumentedBase)result);
            result.getImport().add(importConverted);
        }
        return result;
    }

    public static JSITDefinitions dmnFromWB(Definitions wb) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITDefinitions result = new JSITDefinitions();
        String defaultId = Objects.nonNull(wb.getId()) ? wb.getId().getValue() : UUID.uuid();
        String defaultName = Objects.nonNull(wb.getName()) ? wb.getName().getValue() : UUID.uuid((int)8);
        String defaultNamespace = !StringUtils.isEmpty((String)wb.getNamespace().getValue()) ? wb.getNamespace().getValue() : DMNModelInstrumentedBase.Namespace.DEFAULT.getUri() + UUID.uuid();
        result.setId(defaultId);
        result.setName(defaultName);
        result.setNamespace(defaultNamespace);
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITDefinitions)result).setDescription(arg_0));
        String typeLanguage = wb.getTypeLanguage();
        String expressionLanguage = ExpressionLanguagePropertyConverter.dmnFromWB(wb.getExpressionLanguage());
        if (!StringUtils.isEmpty((String)typeLanguage)) {
            result.setTypeLanguage(typeLanguage);
        }
        if (!StringUtils.isEmpty((String)expressionLanguage)) {
            result.setExpressionLanguage(expressionLanguage);
        }
        HashMap otherAttributes = new HashMap();
        wb.getNsContext().forEach((k, v) -> {
            if (!Objects.equals(k, DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix())) {
                otherAttributes.put(new QName("http://www.w3.org/2000/xmlns/", (String)k, ""), v);
            }
        });
        result.setOtherAttributes(otherAttributes);
        if (Objects.isNull(result.getItemDefinition())) {
            result.setItemDefinition(new ArrayList());
        }
        for (ItemDefinition itemDef : wb.getItemDefinition()) {
            JSITItemDefinition itemDefConverted = ItemDefinitionPropertyConverter.dmnFromWB(itemDef);
            result.addItemDefinition(itemDefConverted);
        }
        if (Objects.isNull(result.getImport())) {
            result.setImport(new ArrayList());
        }
        if (Objects.isNull(result.getDrgElement())) {
            result.setDrgElement(new ArrayList());
        }
        if (Objects.isNull(result.getArtifact())) {
            result.setArtifact(new ArrayList());
        }
        for (Import i : wb.getImport()) {
            JSITImport importConverted = ImportConverter.dmnFromWb(i);
            result.addImport(importConverted);
        }
        return result;
    }
}

