/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;

public class NameSpaceUtils {
    public static Map<String, String> extractNamespacesKeyedByUri(JSITDMNElement jsiDMNElement) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        Map otherAttributes = JSITDMNElement.getOtherAttributesMap((JSITDMNElement)jsiDMNElement);
        for (Map.Entry e : otherAttributes.entrySet()) {
            QName qName = (QName)e.getKey();
            String nsLocalPart = qName.getLocalPart();
            String nsNamespaceURI = qName.getNamespaceURI();
            if (!Objects.equals("http://www.w3.org/2000/xmlns/", nsNamespaceURI) || Objects.equals("xmlns", nsLocalPart)) continue;
            namespaces.put((String)e.getValue(), nsLocalPart);
        }
        return namespaces;
    }

    public static Map<String, String> extractNamespacesKeyedByPrefix(JSITDMNElement jsiDMNElement) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        Map otherAttributes = JSITDMNElement.getOtherAttributesMap((JSITDMNElement)jsiDMNElement);
        for (Map.Entry e : otherAttributes.entrySet()) {
            QName qName = (QName)e.getKey();
            String nsLocalPart = qName.getLocalPart();
            String nsNamespaceURI = qName.getNamespaceURI();
            if (!Objects.equals("http://www.w3.org/2000/xmlns/", nsNamespaceURI) || Objects.equals("xmlns", nsLocalPart)) continue;
            namespaces.put(nsLocalPart, (String)e.getValue());
        }
        return namespaces;
    }
}

