/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.DMNClientServicesProxyImpl;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.TimeZonesProvider;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNClientServicesProxyImplTest {
    private static final String MODEL_NAME = "model_name";
    private static final String NAMESPACE = "namespace";
    @Mock
    private Path path;
    private DMNClientServicesProxyImpl service;

    @Before
    public void setup() {
        TimeZonesProvider timeZonesProvider = (TimeZonesProvider)Mockito.spy((Object)new TimeZonesProvider());
        this.service = new DMNClientServicesProxyImpl(timeZonesProvider);
        ((TimeZonesProvider)Mockito.doCallRealMethod().when((Object)timeZonesProvider)).getTimeZones();
        ((TimeZonesProvider)Mockito.doReturn((Object)new String[]{"A"}).when((Object)timeZonesProvider)).getNames();
        ((TimeZonesProvider)Mockito.doReturn((Object)10.0).when((Object)timeZonesProvider)).getOffset("A");
        ((TimeZonesProvider)Mockito.doReturn((Object)"Aa").when((Object)timeZonesProvider)).getOffsetString("A");
    }

    @Test
    public void testLoadModels() {
        ServiceCallback<List> callback = this.newServiceCallback(actual -> Assertions.assertThat((List)actual).isEmpty());
        this.service.loadModels(this.path, callback);
    }

    @Test
    public void testLoadNodesFromImports() {
        List includedModels = Collections.emptyList();
        ServiceCallback<List> callback = this.newServiceCallback(actual -> Assertions.assertThat((List)actual).isEmpty());
        this.service.loadNodesFromImports(includedModels, callback);
    }

    @Test
    public void testLoadPMMLDocumentsFromImports() {
        List includedModels = Collections.emptyList();
        ServiceCallback<List> callback = this.newServiceCallback(actual -> Assertions.assertThat((List)actual).isEmpty());
        this.service.loadPMMLDocumentsFromImports(this.path, includedModels, callback);
    }

    @Test
    public void testLoadItemDefinitionsByNamespace() {
        ServiceCallback<List> callback = this.newServiceCallback(actual -> Assertions.assertThat((List)actual).isEmpty());
        this.service.loadItemDefinitionsByNamespace(MODEL_NAME, NAMESPACE, callback);
    }

    @Test
    public void testParseFEELList() {
        ServiceCallback<List> callback = this.newServiceCallback(actual -> Assertions.assertThat((List)actual).containsOnly((Object[])new String[]{"\"a\"", "\"b\""}));
        this.service.parseFEELList("\"a\", \"b\"", callback);
    }

    @Test
    public void testParseRangeValue() {
        ServiceCallback<RangeValue> callback = this.newServiceCallback(actual -> {
            Assertions.assertThat((boolean)actual.getIncludeStartValue()).isTrue();
            Assertions.assertThat((boolean)actual.getIncludeEndValue()).isTrue();
            Assertions.assertThat((String)actual.getStartValue()).isEqualTo("1");
            Assertions.assertThat((String)actual.getEndValue()).isEqualTo("2");
        });
        this.service.parseRangeValue("[1..2]", callback);
    }

    @Test
    public void testIsValidVariableName() {
        ServiceCallback<Boolean> trueCallback = this.newServiceCallback(actual -> Assertions.assertThat((Boolean)actual).isTrue());
        ServiceCallback<Boolean> falseCallback = this.newServiceCallback(actual -> Assertions.assertThat((Boolean)actual).isFalse());
        this.service.isValidVariableName("", falseCallback);
        this.service.isValidVariableName("anything", trueCallback);
        this.service.isValidVariableName("   accepted in business central  ", trueCallback);
    }

    @Test
    public void testGetTimeZones() {
        ServiceCallback<List> callback = this.newServiceCallback(actual -> {
            Assertions.assertThat((List)actual).isNotNull();
            Assertions.assertThat((List)actual).isNotEmpty();
        });
        this.service.getTimeZones(callback);
    }

    private <T> ServiceCallback<T> newServiceCallback(final Consumer<T> assertions) {
        return new ServiceCallback<T>(){

            public void onSuccess(T actual) {
                Assertions.assertThat(actual).isNotNull();
                assertions.accept(actual);
            }

            public void onError(ClientRuntimeError error) {
                Fail.fail((String)error.getMessage());
            }
        };
    }
}

