/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters;

import elemental2.promise.Promise;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.background.BgColour;
import org.kie.workbench.common.dmn.api.property.background.BorderColour;
import org.kie.workbench.common.dmn.api.property.dimensions.Height;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Width;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerImportsHelperKogito;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DecisionConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DecisionServiceConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DefinitionsConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InputDataConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.TextAnnotationConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd.ColorUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd.FontSetPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd.PointUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils.DMNMarshallerUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIDiagramElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITArtifact;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDecisionServiceDividerLine;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentsWidthsExtension;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class DMNMarshallerKogitoUnmarshaller {
    private static final String INFO_REQ_ID = BindableAdapterUtils.getDefinitionId(InformationRequirement.class);
    private static final String KNOWLEDGE_REQ_ID = BindableAdapterUtils.getDefinitionId(KnowledgeRequirement.class);
    private static final String AUTH_REQ_ID = BindableAdapterUtils.getDefinitionId(AuthorityRequirement.class);
    private static final String ASSOCIATION_ID = BindableAdapterUtils.getDefinitionId(Association.class);
    private static final double CENTRE_TOLERANCE = 1.0;
    private final FactoryManager factoryManager;
    private final DMNMarshallerImportsHelperKogito dmnMarshallerImportsHelper;
    private InputDataConverter inputDataConverter;
    private DecisionConverter decisionConverter;
    private BusinessKnowledgeModelConverter bkmConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;
    private DecisionServiceConverter decisionServiceConverter;
    private Promises promises;

    protected DMNMarshallerKogitoUnmarshaller() {
        this(null, null, null);
    }

    @Inject
    public DMNMarshallerKogitoUnmarshaller(FactoryManager factoryManager, DMNMarshallerImportsHelperKogito dmnMarshallerImportsHelper, Promises promises) {
        this.factoryManager = factoryManager;
        this.dmnMarshallerImportsHelper = dmnMarshallerImportsHelper;
        this.promises = promises;
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
        this.decisionServiceConverter = new DecisionServiceConverter(factoryManager);
    }

    @PostConstruct
    public void init() {
        MainJs.initializeJsInteropConstructors((JsPropertyMap)MainJs.getConstructorsMap());
    }

    public Promise<Graph> unmarshall(Metadata metadata, JSITDefinitions jsiDefinitions) {
        HashMap hasComponentWidthsMap = new HashMap();
        BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer = (uuid, hcw) -> {
            if (Objects.nonNull(uuid)) {
                hasComponentWidthsMap.put(uuid, hcw);
            }
        };
        List diagramDrgElements = jsiDefinitions.getDrgElement();
        Optional<JSIDMNDiagram> dmnDDDiagram = this.findJSIDiagram(jsiDefinitions);
        Promise<Map<JSITImport, JSITDefinitions>> importAsync = this.dmnMarshallerImportsHelper.getImportDefinitionsAsync(metadata, jsiDefinitions.getImport());
        return importAsync.then(importDefinitions -> {
            int i;
            Map pmmlDocuments = this.dmnMarshallerImportsHelper.getPMMLDocuments(metadata, jsiDefinitions.getImport());
            ArrayList<JSIDMNShape> dmnShapes = new ArrayList<JSIDMNShape>();
            ArrayList<JSITDRGElement> importedDrgElements = new ArrayList<JSITDRGElement>();
            if (dmnDDDiagram.isPresent()) {
                JSIDMNDiagram jsidmnDiagram = (JSIDMNDiagram)Js.uncheckedCast(dmnDDDiagram.get());
                dmnShapes.addAll(this.getUniqueDMNShapes(jsidmnDiagram));
                importedDrgElements.addAll(this.getImportedDrgElementsByShape((List<JSIDMNShape>)dmnShapes, (Map<JSITImport, JSITDefinitions>)importDefinitions, jsiDefinitions));
            }
            ArrayList<JSITDRGElement> drgElements = new ArrayList<JSITDRGElement>();
            HashSet<JSITDecisionService> dmnDecisionServices = new HashSet<JSITDecisionService>();
            drgElements.addAll(diagramDrgElements);
            drgElements.addAll(importedDrgElements);
            this.removeDrgElementsWithoutShape(drgElements, dmnShapes);
            HashMap<String, Map.Entry<JSITDRGElement, Node>> elems = new HashMap<String, Map.Entry<JSITDRGElement, Node>>();
            for (int i2 = 0; i2 < drgElements.size(); ++i2) {
                JSITDRGElement drgElement = (JSITDRGElement)Js.uncheckedCast(drgElements.get(i2));
                String id = drgElement.getId();
                Node stunnerNode = this.dmnToStunner(drgElement, hasComponentWidthsConsumer, importedDrgElements);
                elems.put(id, new AbstractMap.SimpleEntry<JSITDRGElement, Node>(drgElement, stunnerNode));
            }
            for (Map.Entry kv : elems.values()) {
                this.ddExtAugmentStunner(dmnDDDiagram, (Node)kv.getValue());
            }
            for (Map.Entry kv : elems.values()) {
                JSITDRGElement element = (JSITDRGElement)Js.uncheckedCast(kv.getKey());
                Node currentNode = (Node)kv.getValue();
                if (this.isImportedDRGElement(importedDrgElements, element)) continue;
                if (JSITDecision.instanceOf((Object)element)) {
                    JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)element);
                    List jsiInformationRequirements = decision.getInformationRequirement();
                    for (int i3 = 0; i3 < jsiInformationRequirements.size(); ++i3) {
                        JSITInformationRequirement ir = (JSITInformationRequirement)Js.uncheckedCast(jsiInformationRequirements.get(i3));
                        this.connectEdgeToNodes(INFO_REQ_ID, (JSITDMNElement)ir, ir.getRequiredInput(), elems, jsiDefinitions, currentNode);
                        this.connectEdgeToNodes(INFO_REQ_ID, (JSITDMNElement)ir, ir.getRequiredDecision(), elems, jsiDefinitions, currentNode);
                    }
                    List jsiKnowledgeRequirements = decision.getKnowledgeRequirement();
                    for (int i4 = 0; i4 < jsiKnowledgeRequirements.size(); ++i4) {
                        JSITKnowledgeRequirement kr = (JSITKnowledgeRequirement)Js.uncheckedCast(jsiKnowledgeRequirements.get(i4));
                        this.connectEdgeToNodes(KNOWLEDGE_REQ_ID, (JSITDMNElement)kr, kr.getRequiredKnowledge(), elems, jsiDefinitions, currentNode);
                    }
                    List jsiAuthorityRequirements = decision.getAuthorityRequirement();
                    for (int i5 = 0; i5 < jsiAuthorityRequirements.size(); ++i5) {
                        JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i5));
                        this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), elems, jsiDefinitions, currentNode);
                    }
                    continue;
                }
                if (JSITBusinessKnowledgeModel.instanceOf((Object)element)) {
                    JSITBusinessKnowledgeModel bkm = (JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)element);
                    List jsiKnowledgeRequirements = bkm.getKnowledgeRequirement();
                    for (int i6 = 0; i6 < jsiKnowledgeRequirements.size(); ++i6) {
                        JSITKnowledgeRequirement kr = (JSITKnowledgeRequirement)Js.uncheckedCast(jsiKnowledgeRequirements.get(i6));
                        this.connectEdgeToNodes(KNOWLEDGE_REQ_ID, (JSITDMNElement)kr, kr.getRequiredKnowledge(), elems, jsiDefinitions, currentNode);
                    }
                    List jsiAuthorityRequirements = bkm.getAuthorityRequirement();
                    for (int i7 = 0; i7 < jsiAuthorityRequirements.size(); ++i7) {
                        JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i7));
                        this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), elems, jsiDefinitions, currentNode);
                    }
                    continue;
                }
                if (JSITKnowledgeSource.instanceOf((Object)element)) {
                    JSITKnowledgeSource ks = (JSITKnowledgeSource)Js.uncheckedCast((Object)element);
                    List jsiAuthorityRequirements = ks.getAuthorityRequirement();
                    for (int i8 = 0; i8 < jsiAuthorityRequirements.size(); ++i8) {
                        JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i8));
                        this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredInput(), elems, jsiDefinitions, currentNode);
                        this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredDecision(), elems, jsiDefinitions, currentNode);
                        this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), elems, jsiDefinitions, currentNode);
                    }
                    continue;
                }
                if (!JSITDecisionService.instanceOf((Object)element)) continue;
                JSITDecisionService ds = (JSITDecisionService)Js.uncheckedCast((Object)element);
                dmnDecisionServices.add(ds);
                List jsiEncapsulatedDecisions = ds.getEncapsulatedDecision();
                for (int i9 = 0; i9 < jsiEncapsulatedDecisions.size(); ++i9) {
                    JSITDMNElementReference er = (JSITDMNElementReference)Js.uncheckedCast(jsiEncapsulatedDecisions.get(i9));
                    String reqInputID = this.getId(er);
                    Node requiredNode = this.getRequiredNode(elems, reqInputID);
                    if (!Objects.nonNull(requiredNode)) continue;
                    this.connectDSChildEdge(currentNode, requiredNode);
                }
                List jsiOutputDecisions = ds.getOutputDecision();
                for (int i10 = 0; i10 < jsiOutputDecisions.size(); ++i10) {
                    JSITDMNElementReference er = (JSITDMNElementReference)Js.uncheckedCast(jsiOutputDecisions.get(i10));
                    String reqInputID = this.getId(er);
                    Node requiredNode = this.getRequiredNode(elems, reqInputID);
                    if (!Objects.nonNull(requiredNode)) continue;
                    this.connectDSChildEdge(currentNode, requiredNode);
                }
            }
            HashMap textAnnotations = new HashMap();
            List jsiArtifacts = jsiDefinitions.getArtifact();
            for (int i11 = 0; i11 < jsiArtifacts.size(); ++i11) {
                JSITArtifact jsiArtifact = (JSITArtifact)Js.uncheckedCast(jsiArtifacts.get(i11));
                if (!JSITTextAnnotation.instanceOf((Object)jsiArtifact)) continue;
                String id = jsiArtifact.getId();
                JSITTextAnnotation jsiTextAnnotation = (JSITTextAnnotation)Js.uncheckedCast((Object)jsiArtifact);
                Node<View<TextAnnotation>, ?> textAnnotation = this.textAnnotationConverter.nodeFromDMN(jsiTextAnnotation, hasComponentWidthsConsumer);
                textAnnotations.put(id, textAnnotation);
            }
            textAnnotations.values().forEach(n -> this.ddExtAugmentStunner(dmnDDDiagram, (Node)n));
            ArrayList<JSITAssociation> associations = new ArrayList<JSITAssociation>();
            for (i = 0; i < jsiArtifacts.size(); ++i) {
                JSITArtifact jsiArtifact = (JSITArtifact)Js.uncheckedCast(jsiArtifacts.get(i));
                if (!JSITAssociation.instanceOf((Object)jsiArtifact)) continue;
                JSITAssociation jsiAssociation = (JSITAssociation)Js.uncheckedCast((Object)jsiArtifact);
                associations.add(jsiAssociation);
            }
            for (i = 0; i < associations.size(); ++i) {
                JSITAssociation jsiAssociation = (JSITAssociation)Js.uncheckedCast(associations.get(i));
                String sourceId = this.getId(jsiAssociation.getSourceRef());
                Node sourceNode = Optional.ofNullable(elems.get(sourceId)).map(Map.Entry::getValue).orElse((Node)textAnnotations.get(sourceId));
                String targetId = this.getId(jsiAssociation.getTargetRef());
                Node targetNode = Optional.ofNullable(elems.get(targetId)).map(Map.Entry::getValue).orElse((Node)textAnnotations.get(targetId));
                Edge myEdge = this.factoryManager.newElement(this.idOfDMNorWBUUID((JSITDMNElement)jsiAssociation), ASSOCIATION_ID).asEdge();
                Id id = IdPropertyConverter.wbFromDMN(jsiAssociation.getId());
                Description description = new Description(jsiAssociation.getDescription());
                Association definition = new Association(id, description);
                ((View)myEdge.getContent()).setDefinition((Object)definition);
                this.connectEdge(myEdge, sourceNode, targetNode);
                this.setConnectionMagnets(myEdge, jsiAssociation.getId(), jsiDefinitions);
            }
            for (Map.Entry kv : elems.values()) {
                PointUtils.convertToRelativeBounds((Node)kv.getValue());
            }
            Graph graph = this.factoryManager.newDiagram("prova", BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class), metadata).getGraph();
            elems.values().stream().map(Map.Entry::getValue).forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
            textAnnotations.values().forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
            Node<?, ?> dmnDiagramRoot = DMNMarshallerUtils.findDMNDiagramRoot(graph);
            Definitions definitionsStunnerPojo = DefinitionsConverter.wbFromDMN(jsiDefinitions, importDefinitions, pmmlDocuments);
            this.loadImportedItemDefinitions(definitionsStunnerPojo, (Map<JSITImport, JSITDefinitions>)importDefinitions);
            ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).setDefinitions(definitionsStunnerPojo);
            ArrayList<String> references = new ArrayList<String>();
            ArrayList lstDecisionServices = new ArrayList(dmnDecisionServices);
            for (int iDS = 0; iDS < lstDecisionServices.size(); ++iDS) {
                List jsiOutputDecisions;
                JSITDecisionService jsiDecisionService = (JSITDecisionService)Js.uncheckedCast(lstDecisionServices.get(iDS));
                List jsiEncapsulatedDecisions = jsiDecisionService.getEncapsulatedDecision();
                if (Objects.nonNull(jsiEncapsulatedDecisions)) {
                    for (int i12 = 0; i12 < jsiEncapsulatedDecisions.size(); ++i12) {
                        JSITDMNElementReference jsiEncapsulatedDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiEncapsulatedDecisions.get(i12));
                        references.add(jsiEncapsulatedDecision.getHref());
                    }
                }
                if (!Objects.nonNull(jsiOutputDecisions = jsiDecisionService.getOutputDecision())) continue;
                for (int i13 = 0; i13 < jsiOutputDecisions.size(); ++i13) {
                    JSITDMNElementReference jsiOutputDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiOutputDecisions.get(i13));
                    references.add(jsiOutputDecision.getHref());
                }
            }
            HashMap<JSITDRGElement, Node> elementsToConnectToRoot = new HashMap<JSITDRGElement, Node>();
            for (Map.Entry kv : elems.values()) {
                JSITDRGElement element = (JSITDRGElement)Js.uncheckedCast(kv.getKey());
                Node node2 = (Node)kv.getValue();
                if (references.contains("#" + element.getId())) continue;
                elementsToConnectToRoot.put(element, node2);
            }
            elementsToConnectToRoot.values().forEach(node -> this.connectRootWithChild((Node)dmnDiagramRoot, (Node)node));
            textAnnotations.values().forEach(node -> this.connectRootWithChild((Node)dmnDiagramRoot, (Node)node));
            Optional<JSITComponentsWidthsExtension> extension = this.findComponentsWidthsExtension(dmnDDDiagram);
            extension.ifPresent(componentsWidthsExtension -> {
                if (Objects.nonNull(componentsWidthsExtension.getComponentWidths())) {
                    hasComponentWidthsMap.entrySet().forEach(es -> {
                        List jsiComponentWidths = componentsWidthsExtension.getComponentWidths();
                        for (int i = 0; i < jsiComponentWidths.size(); ++i) {
                            JSITComponentWidths jsiWidths = (JSITComponentWidths)Js.uncheckedCast(jsiComponentWidths.get(i));
                            if (!Objects.equals(jsiWidths.getDmnElementRef(), es.getKey())) continue;
                            List widths = ((HasComponentWidths)es.getValue()).getComponentWidths();
                            if (!Objects.nonNull(jsiWidths.getWidth())) continue;
                            widths.clear();
                            for (int w = 0; w < jsiWidths.getWidth().size(); ++w) {
                                double width = ((Float)jsiWidths.getWidth().get(w)).doubleValue();
                                widths.add(width);
                            }
                        }
                    });
                }
            });
            return this.promises.resolve((Object)graph);
        });
    }

    private Optional<JSIDMNDiagram> findJSIDiagram(JSITDefinitions dmnXml) {
        if (Objects.isNull(dmnXml.getDMNDI())) {
            return Optional.empty();
        }
        List elems = dmnXml.getDMNDI().getDMNDiagram();
        if (elems.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(Js.uncheckedCast(elems.get(0)));
    }

    private void removeDrgElementsWithoutShape(List<JSITDRGElement> drgElements, List<JSIDMNShape> dmnShapes) {
        if (dmnShapes.isEmpty()) {
            return;
        }
        drgElements.removeIf(element -> dmnShapes.stream().noneMatch(s -> Objects.equals(this.getDmnElementRef((JSIDMNShape)s), element.getId())));
    }

    private void changeAlias(String alias, JSITDRGElement drgElement) {
        if (drgElement.getId().contains(":")) {
            String id = drgElement.getId().split(":")[1];
            drgElement.setId(alias + ":" + id);
        }
    }

    private Node getRequiredNode(Map<String, Map.Entry<JSITDRGElement, Node>> elems, String reqInputID) {
        if (elems.containsKey(reqInputID)) {
            Map.Entry<JSITDRGElement, Node> value = elems.get(reqInputID);
            return value.getValue();
        }
        Optional<String> match = elems.keySet().stream().filter(k -> k.contains(reqInputID)).findFirst();
        if (match.isPresent()) {
            return elems.get(match.get()).getValue();
        }
        return null;
    }

    private List<JSITDRGElement> getImportedDrgElementsByShape(List<JSIDMNShape> dmnShapes, Map<JSITImport, JSITDefinitions> importDefinitions, JSITDefinitions dmnXml) {
        List importedDRGElements = this.dmnMarshallerImportsHelper.getImportedDRGElements(importDefinitions);
        ArrayList<JSITDRGElement> elements = new ArrayList<JSITDRGElement>();
        for (int i = 0; i < dmnShapes.size(); ++i) {
            JSIDMNShape shape = (JSIDMNShape)Js.uncheckedCast((Object)dmnShapes.get(i));
            String dmnElementRef = this.getDmnElementRef(shape);
            Optional<Object> ref = this.getReference(importedDRGElements, dmnElementRef);
            if (!ref.isPresent()) continue;
            elements.add((JSITDRGElement)Js.uncheckedCast((Object)ref.get()));
        }
        return elements;
    }

    private Optional<Object> getReference(List<JSITDRGElement> importedDRGElements, String dmnElementRef) {
        for (int i = 0; i < importedDRGElements.size(); ++i) {
            JSITDRGElement importedDRGElement = (JSITDRGElement)Js.uncheckedCast((Object)importedDRGElements.get(i));
            String importedDRGElementId = importedDRGElement.getId();
            if (!dmnElementRef.endsWith(importedDRGElementId)) continue;
            return Optional.of(importedDRGElement);
        }
        return Optional.empty();
    }

    private String getDmnElementRef(JSIDMNShape dmnShape) {
        QName elementRef = dmnShape.getDmnElementRef();
        if (Objects.nonNull(elementRef)) {
            return elementRef.getLocalPart();
        }
        return "";
    }

    private List<JSIDMNShape> getUniqueDMNShapes(JSIDMNDiagram dmnDDDiagram) {
        HashMap<String, JSIDMNShape> jsidmnShapes = new HashMap<String, JSIDMNShape>();
        List unwrapped = dmnDDDiagram.getDMNDiagramElement();
        for (int i = 0; i < unwrapped.size(); ++i) {
            JSIDMNShape jsidmnShape;
            JSIDiagramElement jsiDiagramElement = (JSIDiagramElement)Js.uncheckedCast(unwrapped.get(i));
            if (!JSIDMNShape.instanceOf((Object)jsiDiagramElement) || jsidmnShapes.containsKey((jsidmnShape = (JSIDMNShape)Js.uncheckedCast((Object)jsiDiagramElement)).getId())) continue;
            jsidmnShapes.put(jsidmnShape.getId(), jsidmnShape);
        }
        return new ArrayList<JSIDMNShape>(jsidmnShapes.values());
    }

    private void connectDSChildEdge(Node dsNode, Node requiredNode) {
        String uuid = dsNode.getUUID() + "er" + requiredNode.getUUID();
        EdgeImpl myEdge = new EdgeImpl(uuid);
        myEdge.setContent((Object)new Child());
        this.connectEdge((Edge)myEdge, dsNode, requiredNode);
    }

    private String idOfDMNorWBUUID(JSITDMNElement dmn) {
        return Objects.nonNull(dmn.getId()) ? dmn.getId() : UUID.uuid();
    }

    private String getId(JSITDMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private void connectEdgeToNodes(String connectorTypeId, JSITDMNElement jsiDMNElement, JSITDMNElementReference jsiDMNElementReference, Map<String, Map.Entry<JSITDRGElement, Node>> elems, JSITDefinitions jsiDefinitions, Node currentNode) {
        if (Objects.nonNull(jsiDMNElementReference)) {
            String reqInputID = this.getId(jsiDMNElementReference);
            Node requiredNode = this.getRequiredNode(elems, reqInputID);
            Edge myEdge = this.factoryManager.newElement(this.idOfDMNorWBUUID(jsiDMNElement), connectorTypeId).asEdge();
            this.connectEdge(myEdge, requiredNode, currentNode);
            this.setConnectionMagnets(myEdge, jsiDMNElement.getId(), jsiDefinitions);
        }
    }

    private Node dmnToStunner(JSITDRGElement dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer, List<JSITDRGElement> importedDrgElements) {
        Node node = this.createNode(dmn, hasComponentWidthsConsumer);
        return this.setAllowOnlyVisualChange(importedDrgElements, node);
    }

    private Node createNode(JSITDRGElement dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        if (JSITInputData.instanceOf((Object)dmn)) {
            return this.inputDataConverter.nodeFromDMN((JSITInputData)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        if (JSITDecision.instanceOf((Object)dmn)) {
            return this.decisionConverter.nodeFromDMN((JSITDecision)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        if (JSITBusinessKnowledgeModel.instanceOf((Object)dmn)) {
            return this.bkmConverter.nodeFromDMN((JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        if (JSITKnowledgeSource.instanceOf((Object)dmn)) {
            return this.knowledgeSourceConverter.nodeFromDMN((JSITKnowledgeSource)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        if (JSITDecisionService.instanceOf((Object)dmn)) {
            return this.decisionServiceConverter.nodeFromDMN((JSITDecisionService)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        throw new UnsupportedOperationException("Unsupported DRGElement type [" + dmn.getTYPE_NAME() + "]");
    }

    private Node setAllowOnlyVisualChange(List<JSITDRGElement> importedDrgElements, Node node) {
        this.getDRGElement(node).ifPresent(drgElement -> {
            if (this.isImportedDRGElement(importedDrgElements, (DRGElement)drgElement)) {
                drgElement.setAllowOnlyVisualChange(true);
            } else {
                drgElement.setAllowOnlyVisualChange(false);
            }
        });
        return node;
    }

    private Optional<DRGElement> getDRGElement(Node node) {
        Object objectDefinition = DefinitionUtils.getElementDefinition((Element)node);
        if (objectDefinition instanceof DRGElement) {
            return Optional.of((DRGElement)objectDefinition);
        }
        return Optional.empty();
    }

    private boolean isImportedDRGElement(List<JSITDRGElement> importedDrgElements, JSITDRGElement drgElement) {
        return this.isImportedIdNode(importedDrgElements, drgElement.getId());
    }

    private boolean isImportedDRGElement(List<JSITDRGElement> importedDrgElements, DRGElement drgElement) {
        return this.isImportedIdNode(importedDrgElements, drgElement.getId().getValue());
    }

    private boolean isImportedIdNode(List<JSITDRGElement> importedDrgElements, String id) {
        return importedDrgElements.stream().anyMatch(drgElement -> Objects.equals(drgElement.getId(), id));
    }

    private void connectRootWithChild(Node dmnDiagramRoot, Node child) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        this.connectEdge((Edge)edge, dmnDiagramRoot, child);
        Definitions definitions = ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        DMNModelInstrumentedBase childDRG = (DMNModelInstrumentedBase)((View)child.getContent()).getDefinition();
        childDRG.setParent((DMNModelInstrumentedBase)definitions);
    }

    private void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private void setConnectionMagnets(Edge edge, String dmnEdgeElementRef, JSITDefinitions dmnXml) {
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Optional<JSIDMNDiagram> dmnDiagram = this.findJSIDiagram(dmnXml);
        Optional<Object> dmnEdge = Optional.empty();
        if (dmnDiagram.isPresent()) {
            JSIDMNDiagram jsiDiagram = (JSIDMNDiagram)Js.uncheckedCast((Object)dmnDiagram.get());
            List jsiDiagramElements = jsiDiagram.getDMNDiagramElement();
            for (int i = 0; i < jsiDiagramElements.size(); ++i) {
                JSIDMNEdge jsiEdge;
                JSIDiagramElement jsiDiagramElement = (JSIDiagramElement)Js.uncheckedCast(jsiDiagramElements.get(i));
                if (!JSIDMNEdge.instanceOf((Object)jsiDiagramElement) || !Objects.equals((jsiEdge = (JSIDMNEdge)Js.uncheckedCast((Object)jsiDiagramElement)).getDmnElementRef().getLocalPart(), dmnEdgeElementRef)) continue;
                dmnEdge = Optional.of(jsiEdge);
                break;
            }
        }
        if (dmnEdge.isPresent()) {
            JSIDMNEdge e = (JSIDMNEdge)Js.uncheckedCast(dmnEdge.get());
            JSIPoint source = (JSIPoint)Js.uncheckedCast(e.getWaypoint().get(0));
            Node sourceNode = edge.getSourceNode();
            if (null != sourceNode) {
                this.setConnectionMagnet(sourceNode, source, arg_0 -> ((ViewConnector)connectionContent).setSourceConnection(arg_0));
            }
            JSIPoint target = (JSIPoint)Js.uncheckedCast(e.getWaypoint().get(e.getWaypoint().size() - 1));
            Node targetNode = edge.getTargetNode();
            if (null != targetNode) {
                this.setConnectionMagnet(targetNode, target, arg_0 -> ((ViewConnector)connectionContent).setTargetConnection(arg_0));
            }
            if (e.getWaypoint().size() > 2) {
                connectionContent.setControlPoints((ControlPoint[])e.getWaypoint().subList(1, e.getWaypoint().size() - 1).stream().map(p -> ControlPoint.build((Point2D)PointUtils.dmndiPointToPoint2D(p))).toArray(ControlPoint[]::new));
            }
        } else {
            Node targetNode;
            Node sourceNode = edge.getSourceNode();
            if (null != sourceNode) {
                connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.atCenter((Element)sourceNode));
            }
            if (null != (targetNode = edge.getTargetNode())) {
                connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.atCenter((Element)targetNode));
            }
        }
    }

    private void setConnectionMagnet(Node<View<?>, Edge> node, JSIPoint magnetPoint, Consumer<Connection> connectionConsumer) {
        double viewHeight;
        double viewWidth;
        double magnetRelativeY;
        View view = (View)node.getContent();
        double viewX = PointUtils.xOfBound(PointUtils.upperLeftBound(view));
        double viewY = PointUtils.yOfBound(PointUtils.upperLeftBound(view));
        double magnetRelativeX = magnetPoint.getX() - viewX;
        if (this.isCentre(magnetRelativeX, magnetRelativeY = magnetPoint.getY() - viewY, viewWidth = view.getBounds().getWidth(), viewHeight = view.getBounds().getHeight())) {
            connectionConsumer.accept((Connection)MagnetConnection.Builder.atCenter(node));
        } else {
            connectionConsumer.accept((Connection)MagnetConnection.Builder.at((double)magnetRelativeX, (double)magnetRelativeY).setAuto(true));
        }
    }

    private boolean isCentre(double magnetRelativeX, double magnetRelativeY, double viewWidth, double viewHeight) {
        return Math.abs(viewWidth / 2.0 - magnetRelativeX) < 1.0 && Math.abs(viewHeight / 2.0 - magnetRelativeY) < 1.0;
    }

    private Optional<JSITComponentsWidthsExtension> findComponentsWidthsExtension(Optional<JSIDMNDiagram> dmnDDDiagram) {
        if (!dmnDDDiagram.isPresent()) {
            return Optional.empty();
        }
        JSIDMNDiagram jsiDiagram = (JSIDMNDiagram)Js.uncheckedCast((Object)dmnDDDiagram.get());
        JSIDiagramElement.JSIExtension dmnDDExtensions = (JSIDiagramElement.JSIExtension)Js.uncheckedCast((Object)jsiDiagram.getExtension());
        if (Objects.isNull(dmnDDExtensions)) {
            return Optional.empty();
        }
        if (Objects.isNull(dmnDDExtensions.getAny())) {
            return Optional.empty();
        }
        List extensions = dmnDDExtensions.getAny();
        if (!Objects.isNull(extensions)) {
            for (int i = 0; i < extensions.size(); ++i) {
                Object wrapped = extensions.get(i);
                Object extension = JsUtils.getUnwrappedElement(wrapped);
                if (!JSITComponentsWidthsExtension.instanceOf((Object)extension)) continue;
                JSITComponentsWidthsExtension jsiExtension = (JSITComponentsWidthsExtension)Js.uncheckedCast((Object)extension);
                return Optional.of(jsiExtension);
            }
        }
        return Optional.empty();
    }

    private void loadImportedItemDefinitions(Definitions definitions, Map<JSITImport, JSITDefinitions> importDefinitions) {
        definitions.getItemDefinition().addAll(this.getWbImportedItemDefinitions(importDefinitions));
    }

    private List<ItemDefinition> getWbImportedItemDefinitions(Map<JSITImport, JSITDefinitions> importDefinitions) {
        ArrayList<ItemDefinition> definitions = new ArrayList<ItemDefinition>();
        List importedDefinitions = this.dmnMarshallerImportsHelper.getImportedItemDefinitions(importDefinitions);
        for (int i = 0; i < importedDefinitions.size(); ++i) {
            JSITItemDefinition definition = (JSITItemDefinition)Js.uncheckedCast(importedDefinitions.get(i));
            ItemDefinition converted = ItemDefinitionPropertyConverter.wbFromDMN(definition);
            converted.setAllowOnlyVisualChange(true);
            definitions.add(converted);
        }
        return definitions;
    }

    private void ddExtAugmentStunner(Optional<JSIDMNDiagram> dmnDDDiagram, Node currentNode) {
        if (!dmnDDDiagram.isPresent()) {
            return;
        }
        JSIDMNDiagram jsiDiagram = (JSIDMNDiagram)Js.uncheckedCast((Object)dmnDDDiagram.get());
        List jsiDiagramElements = jsiDiagram.getDMNDiagramElement();
        ArrayList<JSIDMNShape> drgShapes = new ArrayList<JSIDMNShape>();
        for (int i = 0; i < jsiDiagramElements.size(); ++i) {
            JSIDiagramElement jsiDiagramElement = (JSIDiagramElement)Js.uncheckedCast(jsiDiagramElements.get(i));
            if (!JSIDMNShape.instanceOf((Object)jsiDiagramElement)) continue;
            drgShapes.add((JSIDMNShape)Js.uncheckedCast((Object)jsiDiagramElement));
        }
        View content = (View)currentNode.getContent();
        Bound ulBound = PointUtils.upperLeftBound(content);
        Bound lrBound = PointUtils.lowerRightBound(content);
        if (content.getDefinition() instanceof Decision) {
            Decision d = (Decision)content.getDefinition();
            this.internalAugment(drgShapes, d.getId(), ulBound, (RectangleDimensionsSet)d.getDimensionsSet(), lrBound, d.getBackgroundSet(), arg_0 -> ((Decision)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof InputData) {
            InputData d = (InputData)content.getDefinition();
            this.internalAugment(drgShapes, d.getId(), ulBound, (RectangleDimensionsSet)d.getDimensionsSet(), lrBound, d.getBackgroundSet(), arg_0 -> ((InputData)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel d = (BusinessKnowledgeModel)content.getDefinition();
            this.internalAugment(drgShapes, d.getId(), ulBound, (RectangleDimensionsSet)d.getDimensionsSet(), lrBound, d.getBackgroundSet(), arg_0 -> ((BusinessKnowledgeModel)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof KnowledgeSource) {
            KnowledgeSource d = (KnowledgeSource)content.getDefinition();
            this.internalAugment(drgShapes, d.getId(), ulBound, (RectangleDimensionsSet)d.getDimensionsSet(), lrBound, d.getBackgroundSet(), arg_0 -> ((KnowledgeSource)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof TextAnnotation) {
            TextAnnotation d = (TextAnnotation)content.getDefinition();
            this.internalAugment(drgShapes, d.getId(), ulBound, (RectangleDimensionsSet)d.getDimensionsSet(), lrBound, d.getBackgroundSet(), arg_0 -> ((TextAnnotation)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof DecisionService) {
            DecisionService d = (DecisionService)content.getDefinition();
            this.internalAugment(drgShapes, d.getId(), ulBound, (RectangleDimensionsSet)d.getDimensionsSet(), lrBound, d.getBackgroundSet(), arg_0 -> ((DecisionService)d).setFontSet(arg_0), dividerLineY -> d.setDividerLineY(new DecisionServiceDividerLineY(Double.valueOf(dividerLineY - ulBound.getY()))));
        }
    }

    private void internalAugment(List<JSIDMNShape> drgShapes, Id id, Bound ulBound, RectangleDimensionsSet dimensionsSet, Bound lrBound, BackgroundSet bgset, Consumer<FontSet> fontSetSetter) {
        this.internalAugment(drgShapes, id, ulBound, dimensionsSet, lrBound, bgset, fontSetSetter, line -> {});
    }

    private void internalAugment(List<JSIDMNShape> drgShapes, Id id, Bound ulBound, RectangleDimensionsSet dimensionsSet, Bound lrBound, BackgroundSet bgset, Consumer<FontSet> fontSetSetter, Consumer<Double> decisionServiceDividerLineYSetter) {
        Optional<Object> drgShapeOpt = Optional.empty();
        for (int i = 0; i < drgShapes.size(); ++i) {
            JSIDMNShape jsiShape = (JSIDMNShape)Js.uncheckedCast((Object)drgShapes.get(i));
            QName dmnRef = jsiShape.getDmnElementRef();
            if (!dmnRef.getLocalPart().endsWith(id.getValue())) continue;
            drgShapeOpt = Optional.of(jsiShape);
        }
        if (!drgShapeOpt.isPresent()) {
            return;
        }
        JSIDMNShape drgShape = (JSIDMNShape)Js.uncheckedCast(drgShapeOpt.get());
        if (Objects.nonNull(ulBound)) {
            ulBound.setX(Double.valueOf(PointUtils.xOfShape(drgShape)));
            ulBound.setY(Double.valueOf(PointUtils.yOfShape(drgShape)));
        }
        dimensionsSet.setWidth(new Width(Double.valueOf(PointUtils.widthOfShape(drgShape))));
        dimensionsSet.setHeight(new Height(Double.valueOf(PointUtils.heightOfShape(drgShape))));
        if (Objects.nonNull(lrBound)) {
            lrBound.setX(Double.valueOf(PointUtils.xOfShape(drgShape) + PointUtils.widthOfShape(drgShape)));
            lrBound.setY(Double.valueOf(PointUtils.yOfShape(drgShape) + PointUtils.heightOfShape(drgShape)));
        }
        this.internalAugmentStyles(drgShape, bgset, fontSetSetter);
        if (Objects.nonNull(drgShape.getDMNDecisionServiceDividerLine())) {
            JSIDMNDecisionServiceDividerLine divider = (JSIDMNDecisionServiceDividerLine)Js.uncheckedCast((Object)drgShape.getDMNDecisionServiceDividerLine());
            List dividerPoints = divider.getWaypoint();
            JSIPoint dividerY = (JSIPoint)Js.uncheckedCast(dividerPoints.get(0));
            decisionServiceDividerLineYSetter.accept(dividerY.getY());
        }
    }

    private void internalAugmentStyles(JSIDMNShape drgShape, BackgroundSet bgset, Consumer<FontSet> fontSetSetter) {
        JSIDMNStyle dmnStyleOfDrgShape;
        JSIStyle jsiStyle = drgShape.getStyle();
        if (Objects.isNull(jsiStyle)) {
            return;
        }
        JSIStyle drgStyle = (JSIStyle)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)jsiStyle));
        JSIDMNStyle jSIDMNStyle = dmnStyleOfDrgShape = JSIDMNStyle.instanceOf((Object)drgStyle) ? (JSIDMNStyle)Js.uncheckedCast((Object)drgStyle) : null;
        if (Objects.nonNull(dmnStyleOfDrgShape)) {
            if (Objects.nonNull(dmnStyleOfDrgShape.getFillColor())) {
                bgset.setBgColour(new BgColour(ColorUtils.wbFromDMN(dmnStyleOfDrgShape.getFillColor())));
            }
            if (Objects.nonNull(dmnStyleOfDrgShape.getStrokeColor())) {
                bgset.setBorderColour(new BorderColour(ColorUtils.wbFromDMN(dmnStyleOfDrgShape.getStrokeColor())));
            }
        }
        FontSet fontSet = new FontSet();
        if (Objects.nonNull(dmnStyleOfDrgShape)) {
            this.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN(dmnStyleOfDrgShape));
        }
        if (Objects.nonNull(drgShape.getDMNLabel())) {
            JSIDMNShape jsiLabel = (JSIDMNShape)Js.uncheckedCast((Object)drgShape.getDMNLabel());
            JSIStyle jsiLabelStyle = jsiLabel.getStyle();
            Object jsiLabelSharedStyle = Js.uncheckedCast((Object)jsiLabel.getSharedStyle());
            if (Objects.nonNull(jsiLabelSharedStyle) && JSIDMNStyle.instanceOf((Object)jsiLabelSharedStyle)) {
                this.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN((JSIDMNStyle)Js.uncheckedCast((Object)jsiLabelSharedStyle)));
            }
            if (Objects.nonNull(jsiLabelStyle) && JSIDMNStyle.instanceOf((Object)jsiLabelStyle)) {
                this.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN((JSIDMNStyle)Js.uncheckedCast((Object)jsiLabelStyle)));
            }
        }
        fontSetSetter.accept(fontSet);
    }

    private void mergeFontSet(FontSet fontSet, FontSet additional) {
        if (Objects.nonNull(additional.getFontFamily())) {
            fontSet.setFontFamily(additional.getFontFamily());
        }
        if (Objects.nonNull(additional.getFontSize())) {
            fontSet.setFontSize(additional.getFontSize());
        }
        if (Objects.nonNull(additional.getFontColour())) {
            fontSet.setFontColour(additional.getFontColour());
        }
    }
}

