/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.included;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.promise.Promise;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.PMMLEditorMarshallerApi;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLDocumentData;
import org.appformer.kogito.bridge.client.resource.interop.ResourceListOptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.included.DMNMarshallerImportsContentServiceKogitoImpl;
import org.kie.workbench.common.kogito.webapp.base.client.workarounds.KogitoResourceContentService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNMarshallerImportsContentServiceKogitoImplTest {
    private static final String FILENAME = "fileName.pmml";
    private static final String PATH = "test/fileName.pmml";
    private static final String CONTENT = "<xml>content</xml>";
    private static final String UNDEFINED = "undefined";
    @Mock
    private KogitoResourceContentService contentService;
    @Mock
    private PMMLEditorMarshallerApi pmmlEditorMarshallerApi;
    private final Promises promises = new SyncPromises();
    private DMNMarshallerImportsContentServiceKogitoImpl service;

    @Before
    public void setup() {
        this.service = (DMNMarshallerImportsContentServiceKogitoImpl)Mockito.spy((Object)new DMNMarshallerImportsContentServiceKogitoImpl(this.contentService, this.promises, this.pmmlEditorMarshallerApi));
    }

    @Test
    public void testLoadFile() {
        String file = "file.dmn";
        Promise expected = this.makePromise();
        Mockito.when((Object)this.contentService.loadFile("file.dmn")).thenReturn(expected);
        Promise actual = this.service.loadFile("file.dmn");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetModelsURIs() {
        Promise expected = this.makePromise();
        Mockito.when((Object)this.contentService.getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.any())).thenReturn(expected);
        Promise actual = this.service.getModelsURIs();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetModelsDMNFilesURIs() {
        Promise expected = this.makePromise();
        Mockito.when((Object)this.contentService.getFilteredItems((String)Matchers.eq((Object)"*.dmn"), (ResourceListOptions)Matchers.any())).thenReturn(expected);
        Promise actual = this.service.getModelsDMNFilesURIs();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetModelsPMMLFilesURIs() {
        Promise expected = this.makePromise();
        Mockito.when((Object)this.contentService.getFilteredItems((String)Matchers.eq((Object)"*.pmml"), (ResourceListOptions)Matchers.any())).thenReturn(expected);
        Promise actual = this.service.getModelsPMMLFilesURIs();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetDocumentMetadata() {
        Mockito.when((Object)this.pmmlEditorMarshallerApi.getPMMLDocumentData(CONTENT)).thenReturn((Object)new PMMLDocumentData());
        ((DMNMarshallerImportsContentServiceKogitoImpl)Mockito.doReturn((Object)this.promises.resolve((Object)CONTENT)).when((Object)this.service)).loadFile(PATH);
        Promise returnPromise = this.service.getPMMLDocumentMetadata(PATH);
        Assert.assertNotNull((Object)returnPromise);
        returnPromise.then(pmmlDocumentMetadata -> {
            Assert.assertNotNull((Object)pmmlDocumentMetadata);
            Assert.assertEquals((Object)PATH, (Object)pmmlDocumentMetadata.getPath());
            Assert.assertEquals((Object)UNDEFINED, (Object)pmmlDocumentMetadata.getName());
            Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)pmmlDocumentMetadata.getImportType());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void testGetDocumentMetadataNullFile() {
        this.getDocumentMetadataInvalidContent(null, CONTENT, "PMML file path cannot be empty or null");
    }

    @Test
    public void testGetDocumentMetadataEmptyFile() {
        this.getDocumentMetadataInvalidContent("", CONTENT, "PMML file path cannot be empty or null");
    }

    @Test
    public void testGetDocumentMetadataNullContent() {
        this.getDocumentMetadataInvalidContent(PATH, null, "PMML file test/fileName.pmml content required to be marshalled is empty or null");
    }

    @Test
    public void testGetDocumentMetadataEmptyContent() {
        this.getDocumentMetadataInvalidContent(PATH, "", "PMML file test/fileName.pmml content required to be marshalled is empty or null");
    }

    private void getDocumentMetadataInvalidContent(String pmmlFile, String pmmlFileContent, String expectedMessage) {
        ((DMNMarshallerImportsContentServiceKogitoImpl)Mockito.doReturn((Object)this.promises.resolve((Object)pmmlFileContent)).when((Object)this.service)).loadFile(pmmlFile);
        Promise returnPromise = this.service.getPMMLDocumentMetadata(pmmlFile);
        Assert.assertNotNull((Object)returnPromise);
        returnPromise.then(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.assertEquals((Object)expectedMessage, (Object)error);
            return this.promises.resolve();
        });
    }

    private <T> Promise<T> makePromise() {
        return new Promise(null);
    }
}

