/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers;

import java.util.Optional;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourBridge;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourActions;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers.GuidedTourGraphObserver;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.AbstractCanvasHandlerElementEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedTourGraphObserverTest {
    @Mock
    private Disposer<GuidedTourGraphObserver> disposer;
    @Mock
    private GuidedTourUtils guidedTourUtils;
    @Mock
    private GuidedTourBridge bridge;
    private GuidedTourGraphObserverFake observer;

    @Before
    public void setup() {
        this.observer = (GuidedTourGraphObserverFake)((Object)Mockito.spy((Object)((Object)new GuidedTourGraphObserverFake(this.disposer, this.guidedTourUtils))));
    }

    @Test
    public void testOnCanvasElementAddedEvent() {
        CanvasElementAddedEvent event = new CanvasElementAddedEvent(null, null);
        UserInteraction userInteraction = (UserInteraction)Mockito.mock(UserInteraction.class);
        NodeImpl node = new NodeImpl("0000");
        String nodeName = "Decision-1";
        Mockito.when((Object)this.guidedTourUtils.getName((AbstractCanvasHandlerElementEvent)event)).thenReturn(Optional.of("Decision-1"));
        ((GuidedTourGraphObserverFake)((Object)Mockito.doReturn((Object)userInteraction).when((Object)this.observer))).buildUserInteraction(GuidedTourActions.CREATED.name(), "Decision-1");
        this.observer.onCanvasElementAddedEvent(event);
        ((GuidedTourBridge)Mockito.verify((Object)this.bridge)).refresh(userInteraction);
    }

    @Test
    public void testOnCanvasElementUpdatedEvent() {
        CanvasElementUpdatedEvent event = new CanvasElementUpdatedEvent(null, null);
        UserInteraction userInteraction = (UserInteraction)Mockito.mock(UserInteraction.class);
        NodeImpl node = new NodeImpl("0000");
        String nodeName = "Decision-1";
        Mockito.when((Object)this.guidedTourUtils.getName((AbstractCanvasHandlerElementEvent)event)).thenReturn(Optional.of("Decision-1"));
        ((GuidedTourGraphObserverFake)((Object)Mockito.doReturn((Object)userInteraction).when((Object)this.observer))).buildUserInteraction(GuidedTourActions.UPDATED.name(), "Decision-1");
        this.observer.onCanvasElementUpdatedEvent(event);
        ((GuidedTourBridge)Mockito.verify((Object)this.bridge)).refresh(userInteraction);
    }

    @Test
    public void testOnAbstractCanvasElementRemovedEvent() {
        CanvasElementRemovedEvent event = new CanvasElementRemovedEvent(null, null);
        UserInteraction userInteraction = (UserInteraction)Mockito.mock(UserInteraction.class);
        NodeImpl node = new NodeImpl("0000");
        String nodeName = "Decision-1";
        Mockito.when((Object)this.guidedTourUtils.getName((AbstractCanvasHandlerElementEvent)event)).thenReturn(Optional.of("Decision-1"));
        ((GuidedTourGraphObserverFake)((Object)Mockito.doReturn((Object)userInteraction).when((Object)this.observer))).buildUserInteraction(GuidedTourActions.REMOVED.name(), "Decision-1");
        this.observer.onAbstractCanvasElementRemovedEvent(event);
        ((GuidedTourBridge)Mockito.verify((Object)this.bridge)).refresh(userInteraction);
    }

    class GuidedTourGraphObserverFake
    extends GuidedTourGraphObserver {
        GuidedTourGraphObserverFake(Disposer<GuidedTourGraphObserver> disposer, GuidedTourUtils guidedTourUtils) {
            super(disposer, guidedTourUtils);
        }

        protected Optional<GuidedTourBridge> getMonitorBridge() {
            return Optional.of(GuidedTourGraphObserverTest.this.bridge);
        }
    }
}

