/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers;

import elemental2.dom.DOMRect;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDocument;
import java.util.Optional;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Rect;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.PositionProviderFactory;

public class HTMLElementsPositionProviderFactory
implements PositionProviderFactory {
    @Override
    public GuidedTourCustomSelectorPositionProvider.PositionProviderFunction createPositionProvider() {
        return selector -> Optional.ofNullable(this.document().querySelector(selector)).map(this::makeRect).orElse(Rect.NONE());
    }

    private Rect makeRect(Element element) {
        DOMRect clientRect = element.getBoundingClientRect();
        int bottom = (int)clientRect.bottom;
        int top = (int)clientRect.top;
        int left = (int)clientRect.left;
        int right = (int)clientRect.right;
        int height = (int)clientRect.height;
        int width = (int)clientRect.width;
        return this.makeRect(bottom, top, left, right, height, width);
    }

    Rect makeRect(int bottom, int top, int left, int right, int height, int width) {
        Rect rect = new Rect();
        rect.setBottom(bottom);
        rect.setHeight(height);
        rect.setLeft(left);
        rect.setRight(right);
        rect.setTop(top);
        rect.setWidth(width);
        rect.setX(left);
        rect.setY(top);
        return rect;
    }

    HTMLDocument document() {
        return DomGlobal.document;
    }
}

