/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.docks.navigator.common.LazyCanvasFocusUtils;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsContext;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.webapp.common.client.docks.preview.PreviewDiagramDock;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.AbstractDMNDiagramEditor;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.session.DMNEditorSessionCommands;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.GuidedTourBridgeInitializer;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerView;
import org.kie.workbench.common.stunner.client.widgets.editor.StunnerEditor;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.client.PromiseMock;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.client.docks.DiagramEditorPropertiesDock;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public abstract class AbstractDMNDiagramEditorTest {
    protected static final String CONTENT = "content";
    protected static final String ROOT = "default://master@system/stunner/diagrams";
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    protected MultiPageEditorContainerView multiPageEditorContainerView;
    @Mock
    protected MultiPageEditor multiPageEditor;
    @Mock
    protected ClientTranslationService clientTranslationService;
    @Mock
    protected DocumentationView<Diagram> documentationView;
    @Mock
    protected DMNEditorSearchIndex editorSearchIndex;
    @Mock
    protected SearchBarComponent<DMNSearchableElement> searchBarComponent;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEventSourceMock;
    @Mock
    protected DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    protected DiagramEditorPropertiesDock diagramPropertiesDock;
    @Mock
    protected PreviewDiagramDock diagramPreviewDock;
    @Mock
    protected DMNEditorSessionCommands sessionCommands;
    @Mock
    protected LayoutHelper layoutHelper;
    @Mock
    protected OpenDiagramLayoutExecutor layoutExecutor;
    @Mock
    protected DataTypesPage dataTypesPage;
    @Mock
    protected KogitoClientDiagramService clientDiagramService;
    @Mock
    protected StunnerEditor stunnerEditor;
    @Mock
    protected AbstractDMNDiagramEditor.View view;
    @Mock
    protected SessionDiagramPresenter presenter;
    @Mock
    protected SessionPresenter.View presenterView;
    @Mock
    protected ExpressionEditorView.Presenter expressionEditor;
    @Mock
    protected DMNEditorSession session;
    @Mock
    protected SearchBarComponent.View searchBarComponentView;
    @Mock
    protected HTMLElement searchBarComponentViewElement;
    @Mock
    protected ElementWrapperWidget searchBarComponentWidget;
    @Mock
    protected DataTypePageTabActiveEvent dataTypePageTabActiveEvent;
    @Mock
    protected DataTypeEditModeToggleEvent dataTypeEditModeToggleEvent;
    @Mock
    protected EditExpressionEvent editExpressionEvent;
    @Mock
    protected MultiPageEditorSelectedPageEvent multiPageEditorSelectedPageEvent;
    @Mock
    protected RefreshFormPropertiesEvent refreshFormPropertiesEvent;
    @Mock
    protected Path root;
    @Mock
    protected ClientRuntimeError clientRuntimeError;
    @Mock
    protected MonacoFEELInitializer feelInitializer;
    @Mock
    protected GuidedTourBridgeInitializer guidedTourBridgeInitializer;
    @Mock
    protected CanvasFileExport canvasFileExport;
    @Mock
    protected IncludedModelsPage includedModelsPage;
    @Mock
    protected IncludedModelsContext includedModelContext;
    @Mock
    protected ReadOnlyProvider readonlyProvider;
    @Mock
    protected DRDNameChanger drdNameChanger;
    @Mock
    protected LazyCanvasFocusUtils lazyCanvasFocusUtils;
    @Mock
    private HTMLElement drdNameChangerElement;
    @Mock
    private ElementWrapperWidget drdNameWidget;
    @Captor
    protected ArgumentCaptor<ServiceCallback<Diagram>> serviceCallbackArgumentCaptor;
    protected Diagram diagram;
    protected Metadata metadata;
    protected AbstractDMNDiagramEditor editor;
    protected PlaceRequest place = new DefaultPlaceRequest();

    @Before
    public void setup() {
        this.metadata = new MetadataImpl.MetadataImplBuilder(DMNDefinitionSet.class.getName()).setTitle("dmn").setRoot(this.root).build();
        this.diagram = new DiagramImpl("dmn", this.metadata);
        Mockito.when((Object)this.searchBarComponent.getView()).thenReturn((Object)this.searchBarComponentView);
        Mockito.when((Object)this.searchBarComponentView.getElement()).thenReturn((Object)this.searchBarComponentViewElement);
        Mockito.when((Object)this.multiPageEditorContainerView.getMultiPage()).thenReturn((Object)this.multiPageEditor);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        Mockito.when((Object)this.presenter.getView()).thenReturn((Object)this.presenterView);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.stunnerEditor.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.stunnerEditor.getPresenter()).thenReturn((Object)this.presenter);
        Mockito.when((Object)this.stunnerEditor.getView()).thenReturn((Object)this.view);
        Mockito.when((Object)this.stunnerEditor.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.stunnerEditor.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.root.toURI()).thenReturn((Object)ROOT);
        Mockito.when((Object)this.drdNameChanger.getElement()).thenReturn((Object)this.drdNameChangerElement);
        ((StunnerEditor)Mockito.doAnswer(invocation -> {
            Diagram diagram = (Diagram)invocation.getArguments()[0];
            SessionPresenter.SessionPresenterCallback callback = (SessionPresenter.SessionPresenterCallback)invocation.getArguments()[1];
            callback.onOpen(diagram);
            callback.afterCanvasInitialized();
            callback.afterSessionOpened();
            callback.onSuccess();
            return null;
        }).when((Object)this.stunnerEditor)).open((Diagram)ArgumentMatchers.any(Diagram.class), (SessionPresenter.SessionPresenterCallback)ArgumentMatchers.any(SessionPresenter.SessionPresenterCallback.class));
        this.editor = (AbstractDMNDiagramEditor)Mockito.spy((Object)this.getEditor());
        ((AbstractDMNDiagramEditor)Mockito.doReturn((Object)this.drdNameWidget).when((Object)this.editor)).getWidget(this.drdNameChangerElement);
    }

    protected abstract AbstractDMNDiagramEditor getEditor();

    @Test
    public void testOnStartup() {
        this.editor.onStartup(this.place);
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor)).setReadOnly(ArgumentMatchers.eq((boolean)false));
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("AuthoringPerspective");
        ((PreviewDiagramDock)Mockito.verify((Object)this.diagramPreviewDock)).init("AuthoringPerspective");
        ((DiagramEditorPropertiesDock)Mockito.verify((Object)this.diagramPropertiesDock)).init("AuthoringPerspective");
        ((MultiPageEditorContainerView)Mockito.verify((Object)this.multiPageEditorContainerView)).init(ArgumentMatchers.eq((Object)this.editor));
        ((GuidedTourBridgeInitializer)Mockito.verify((Object)this.guidedTourBridgeInitializer)).init();
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.editor.onDataTypePageNavTabActiveEvent(this.dataTypePageTabActiveEvent);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPageEditor)).selectPage(2);
    }

    @Test
    public void testOnEditExpressionEventWhenSameSession() {
        Mockito.when((Object)this.editExpressionEvent.getSession()).thenReturn((Object)this.session);
        this.openDiagram();
        Mockito.when((Object)this.stunnerEditor.getSession()).thenReturn((Object)this.session);
        this.editor.onEditExpressionEvent(this.editExpressionEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(ArgumentMatchers.eq((Object)this.canvasHandler), (Command)ArgumentMatchers.any(NavigateToExpressionEditorCommand.class));
    }

    @Test
    public void testOnEditExpressionEventWhenDifferentSession() {
        this.editor.onEditExpressionEvent(this.editExpressionEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(ArgumentMatchers.any(AbstractCanvasHandler.class), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testOnMultiPageEditorSelectedPageEvent() {
        this.editor.onMultiPageEditorSelectedPageEvent(this.multiPageEditorSelectedPageEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testOnRefreshFormPropertiesEvent() {
        this.editor.onRefreshFormPropertiesEvent(this.refreshFormPropertiesEvent);
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).disableSearch();
    }

    @Test
    public void testOnClose() {
        this.openDiagram();
        this.editor.onClose();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.atLeastOnce())).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).destroy();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
        ((DiagramEditorPropertiesDock)Mockito.verify((Object)this.diagramPropertiesDock)).destroy();
        ((PreviewDiagramDock)Mockito.verify((Object)this.diagramPreviewDock)).destroy();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).disableShortcuts();
    }

    @Test
    public void testOnFocus() {
        this.openDiagram();
        Mockito.reset((Object[])new Object[]{this.decisionNavigatorDock, this.diagramPropertiesDock, this.diagramPreviewDock, this.dataTypesPage});
        this.editor.onFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor)).focus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).enableShortcuts();
    }

    @Test
    public void testOnLostFocus() {
        this.openDiagram();
        this.editor.onLostFocus();
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor)).lostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onLostFocus();
    }

    @Test
    public void testGetContent() {
        this.openDiagram();
        this.editor.getContent();
        ((KogitoClientDiagramService)Mockito.verify((Object)this.clientDiagramService)).transform((Diagram)ArgumentMatchers.eq((Object)this.diagram));
    }

    @Test
    public void testSetContentSuccess() {
        String path = "path";
        this.editor.setContent("path", CONTENT);
        ((KogitoClientDiagramService)Mockito.verify((Object)this.clientDiagramService)).transform((String)ArgumentMatchers.eq((Object)"path"), (String)ArgumentMatchers.eq((Object)CONTENT), (ServiceCallback)this.serviceCallbackArgumentCaptor.capture());
        ServiceCallback serviceCallback = (ServiceCallback)this.serviceCallbackArgumentCaptor.getValue();
        Assertions.assertThat((Object)serviceCallback).isNotNull();
        serviceCallback.onSuccess((Object)this.diagram);
        this.assertOnDiagramLoad();
    }

    @Test
    public void testCloseExistingSessionIfAny() {
        PromiseMock promise = new PromiseMock();
        ((AbstractDMNDiagramEditor)Mockito.doReturn((Object)promise.asPromise()).when((Object)this.editor)).getContent();
        promise.then(() -> CONTENT);
        Mockito.when((Object)this.stunnerEditor.getSession()).thenReturn((Object)this.session);
        this.openDiagram();
        ((DMNEditorSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testSetContentFailure() {
        String path = "path";
        this.editor.setContent("path", CONTENT);
        ((KogitoClientDiagramService)Mockito.verify((Object)this.clientDiagramService)).transform((String)ArgumentMatchers.eq((Object)"path"), (String)ArgumentMatchers.eq((Object)CONTENT), (ServiceCallback)this.serviceCallbackArgumentCaptor.capture());
        ServiceCallback serviceCallback = (ServiceCallback)this.serviceCallbackArgumentCaptor.getValue();
        Assertions.assertThat((Object)serviceCallback).isNotNull();
        serviceCallback.onError(this.clientRuntimeError);
        ((MonacoFEELInitializer)Mockito.verify((Object)this.feelInitializer, (VerificationMode)Mockito.never())).initializeFEELEditor();
        ((MultiPageEditorContainerView)Mockito.verify((Object)this.multiPageEditorContainerView, (VerificationMode)Mockito.times((int)1))).clear();
        ((MultiPageEditorContainerView)Mockito.verify((Object)this.multiPageEditorContainerView, (VerificationMode)Mockito.times((int)1))).setEditorWidget((IsWidget)ArgumentMatchers.eq((Object)this.view));
    }

    @Test
    public void testResetContentHash() {
        this.openDiagram();
        this.editor.setOriginalContentHash(Integer.valueOf(this.diagram.hashCode() + 1));
        Assertions.assertThat((boolean)this.editor.isDirty()).isTrue();
        this.editor.resetContentHash();
        Assertions.assertThat((boolean)this.editor.isDirty()).isFalse();
    }

    protected void openDiagram() {
        this.editor.onStartup(this.place);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.stunnerEditor.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        this.editor.open(this.diagram, (SessionPresenter.SessionPresenterCallback)Mockito.mock(SessionPresenter.SessionPresenterCallback.class));
        this.assertOnDiagramLoad();
    }

    protected void assertOnDiagramLoad() {
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).reload();
        ((LayoutHelper)Mockito.verify((Object)this.layoutHelper)).applyLayout((Diagram)ArgumentMatchers.eq((Object)this.diagram), (LayoutExecutor)ArgumentMatchers.eq((Object)this.layoutExecutor));
        ((MonacoFEELInitializer)Mockito.verify((Object)this.feelInitializer)).initializeFEELEditor();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).reload();
        ((LazyCanvasFocusUtils)Mockito.verify((Object)this.lazyCanvasFocusUtils, (VerificationMode)Mockito.atLeastOnce())).releaseFocus();
    }

    @Test
    public void testReleaseOnSetContent() {
        this.editor.setContent("", "");
        ((StunnerEditor)Mockito.verify((Object)this.stunnerEditor, (VerificationMode)Mockito.times((int)1))).close();
    }
}

