/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.client.marshaller.DMNMarshallerService;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.DMNClientDiagramServiceImpl;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.registry.definition.TypeDefinitionSetRegistry;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNClientDiagramServiceImplTest {
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private DMNMarshallerService marshallerService;
    @Mock
    private ServiceCallback<Diagram> callback;
    private Promises promises;
    private DMNClientDiagramServiceImpl service;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.service = (DMNClientDiagramServiceImpl)Mockito.spy((Object)new DMNClientDiagramServiceImpl(this.factoryManager, this.definitionManager, this.promises, this.marshallerService));
    }

    @Test
    public void testUnmarshallWhenXmlIsNotPresent() {
        String fileName = "file.dmn";
        String xml = "";
        ((DMNClientDiagramServiceImpl)Mockito.doNothing().when((Object)this.service)).doNewDiagram((String)Mockito.any(), (ServiceCallback)ArgumentMatchers.any());
        this.service.transform("file.dmn", "", this.callback);
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.service)).doNewDiagram("file.dmn", this.callback);
    }

    @Test
    public void testUnmarshallWhenXmlIsPresent() {
        String fileName = "file.dmn";
        String xml = "<dmn />";
        ((DMNClientDiagramServiceImpl)Mockito.doNothing().when((Object)this.service)).doTransformation((String)Mockito.any(), (String)Mockito.any(), (ServiceCallback)ArgumentMatchers.any());
        this.service.transform("file.dmn", "<dmn />", this.callback);
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.service)).doTransformation("file.dmn", "<dmn />", this.callback);
    }

    @Test
    public void testDoNewDiagram() {
        String fileName = "file.dmn";
        String title = "file";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        ((DMNClientDiagramServiceImpl)Mockito.doReturn((Object)metadata).when((Object)this.service)).buildMetadataInstance("file.dmn");
        Mockito.when((Object)this.factoryManager.newDiagram("file", defSetId, metadata)).thenReturn((Object)diagram);
        this.service.doNewDiagram("file.dmn", this.callback);
        ((DMNMarshallerService)Mockito.verify((Object)this.marshallerService)).setOnDiagramLoad(this.callback);
        ((DMNMarshallerService)Mockito.verify((Object)this.marshallerService)).registerDiagramInstance(diagram, "file", shapeSetId);
        ((ServiceCallback)Mockito.verify(this.callback)).onSuccess((Object)diagram);
    }

    @Test
    public void testDoTransformation() {
        String fileName = "file.dmn";
        String xml = "<dmn />";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ((DMNClientDiagramServiceImpl)Mockito.doReturn((Object)metadata).when((Object)this.service)).buildMetadataInstance("file.dmn");
        this.service.doTransformation("file.dmn", "<dmn />", this.callback);
        ((DMNMarshallerService)Mockito.verify((Object)this.marshallerService)).unmarshall(metadata, "<dmn />", this.callback);
    }

    @Test
    public void testBuildMetadataInstance() {
        String fileName = "file.dmn";
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn(Mockito.mock(TypeDefinitionSetRegistry.class));
        Metadata metadata = this.service.buildMetadataInstance("file.dmn");
        Assert.assertEquals((Object)"default://master@system/stunner/diagrams", (Object)metadata.getRoot().toURI());
        Assert.assertEquals((Object)"default://master@system/stunner/diagrams/file.dmn", (Object)metadata.getPath().toURI());
    }

    @Test
    public void testMarshall() {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        this.service.transform(diagram);
        ((DMNMarshallerService)Mockito.verify((Object)this.marshallerService)).marshall((Diagram)ArgumentMatchers.eq((Object)diagram), (ServiceCallback)ArgumentMatchers.any());
    }
}

