/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.editor;

import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.showcase.client.navigator.DMNVFSService;
import org.kie.workbench.common.dmn.webapp.common.client.docks.preview.PreviewDiagramDock;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.BaseDMNDiagramEditor;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.editor.DMNProjectToolbarStateHandler;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerView;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.kogito.client.docks.DiagramEditorPropertiesDock;
import org.kie.workbench.common.stunner.kogito.client.editor.DiagramEditorCore;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.util.URIUtil;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@DiagramEditor
@WorkbenchScreen(identifier="DMNDiagramEditor")
public class DMNDiagramEditor
extends BaseDMNDiagramEditor {
    public static final String CONTENT_PARAMETER_NAME = "content";
    public static final String FILE_NAME_PARAMETER_NAME = "fileName";
    private final Event<NotificationEvent> notificationEvent;
    private final DMNVFSService vfsService;
    private final Promises promises;

    @Inject
    public DMNDiagramEditor(DiagramEditorCore.View view, FileMenuBuilder fileMenuBuilder, PlaceManager placeManager, MultiPageEditorContainerView multiPageEditorContainerView, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, Event<NotificationEvent> notificationEvent, Event<OnDiagramFocusEvent> onDiagramFocusEvent, TextEditorView xmlEditorView, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, DMNEditorMenuSessionItems menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService, @DMNEditor DocumentationView<Diagram> documentationView, DMNEditorSearchIndex editorSearchIndex, SearchBarComponent<DMNSearchableElement> searchBarComponent, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, DecisionNavigatorDock decisionNavigatorDock, DiagramEditorPropertiesDock diagramPropertiesDock, PreviewDiagramDock diagramPreviewAndExplorerDock, LayoutHelper layoutHelper, OpenDiagramLayoutExecutor openDiagramLayoutExecutor, DataTypesPage dataTypesPage, IncludedModelsPage includedModelsPage, IncludedModelsPageStateProviderImpl importsPageProvider, KogitoClientDiagramService diagramServices, DMNVFSService vfsService, Promises promises) {
        super(view, fileMenuBuilder, placeManager, multiPageEditorContainerView, changeTitleNotificationEvent, notificationEvent, onDiagramFocusEvent, xmlEditorView, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService, documentationView, editorSearchIndex, searchBarComponent, sessionManager, sessionCommandManager, refreshFormPropertiesEvent, decisionNavigatorDock, diagramPropertiesDock, diagramPreviewAndExplorerDock, layoutHelper, openDiagramLayoutExecutor, dataTypesPage, includedModelsPage, importsPageProvider, diagramServices);
        this.notificationEvent = notificationEvent;
        this.vfsService = vfsService;
        this.promises = promises;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        super.onStartup(place);
        this.setContent(place.getParameter(CONTENT_PARAMETER_NAME, ""));
    }

    protected void makeMenuBar() {
        if (!this.menuBarInitialized) {
            this.getFileMenuBuilder().addSave(() -> this.doSave());
            this.getMenuSessionItems().populateMenu(this.getFileMenuBuilder());
            this.makeAdditionalStunnerMenus(this.getFileMenuBuilder());
            this.menuBarInitialized = true;
        }
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }

    public void initialiseKieEditorForSession(Diagram diagram) {
        String title = this.getPlaceRequest().getParameter(FILE_NAME_PARAMETER_NAME, "");
        diagram.getMetadata().setTitle(title);
        super.initialiseKieEditorForSession(diagram);
    }

    public void onDiagramLoad() {
        Optional<CanvasHandler> canvasHandler = Optional.ofNullable(this.getCanvasHandler());
        canvasHandler.ifPresent(c -> {
            Metadata metadata = c.getDiagram().getMetadata();
            metadata.setPath(this.makeMetadataPath(metadata));
            ExpressionEditorView.Presenter expressionEditor = ((DMNSession)this.sessionManager.getCurrentSession()).getExpressionEditor();
            expressionEditor.setToolbarStateHandler((ToolbarStateHandler)new DMNProjectToolbarStateHandler(this.getMenuSessionItems()));
            this.decisionNavigatorDock.setupCanvasHandler(c);
            this.dataTypesPage.reload();
            this.includedModelsPage.setup(this.importsPageProvider.withDiagram(c.getDiagram()));
        });
    }

    private Path makeMetadataPath(Metadata metadata) {
        Path root = metadata.getRoot();
        String fileName = metadata.getTitle();
        String uri = root.toURI();
        return PathFactory.newPath((String)fileName, (String)(uri + "/" + URIUtil.encode((String)fileName)));
    }

    private void doSave() {
        Path path = this.getCanvasHandler().getDiagram().getMetadata().getPath();
        this.getContent().then(xml -> {
            this.vfsService.saveFile(path, (String)xml, (ServiceCallback)new /* Unavailable Anonymous Inner Class!! */);
            return this.promises.resolve();
        });
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        super.onDataTypePageNavTabActiveEvent(event);
    }

    public void onDataTypeEditModeToggle(@Observes DataTypeEditModeToggleEvent event) {
        super.onDataTypeEditModeToggle(event);
    }

    public void onEditExpressionEvent(@Observes EditExpressionEvent event) {
        super.onEditExpressionEvent(event);
    }

    public void onMultiPageEditorSelectedPageEvent(@Observes MultiPageEditorSelectedPageEvent event) {
        super.onMultiPageEditorSelectedPageEvent(event);
    }

    public void onRefreshFormPropertiesEvent(@Observes RefreshFormPropertiesEvent event) {
        super.onRefreshFormPropertiesEvent(event);
    }

    static /* synthetic */ Event access$000(DMNDiagramEditor x0) {
        return x0.notificationEvent;
    }

    static /* synthetic */ void access$100(DMNDiagramEditor x0) {
        x0.hideLoadingViews();
    }
}

