/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.navigator;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.uuid.UUID;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class DMNVFSService {
    private PlaceManager placeManager;
    private Caller<VFSService> vfsServiceCaller;

    public DMNVFSService() {
    }

    @Inject
    public DMNVFSService(PlaceManager placeManager, Caller<VFSService> vfsServiceCaller) {
        this.placeManager = placeManager;
        this.vfsServiceCaller = vfsServiceCaller;
    }

    public void newFile() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("DMNDiagramEditor");
        placeRequest.addParameter("fileName", UUID.uuid() + ".dmn");
        this.placeManager.goTo((PlaceRequest)placeRequest);
    }

    public void openFile(Path path) {
        ((VFSService)this.vfsServiceCaller.call(xml -> {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("DMNDiagramEditor");
            placeRequest.addParameter("fileName", path.getFileName());
            placeRequest.addParameter("content", xml);
            this.placeManager.goTo((PlaceRequest)placeRequest);
        })).readAllString(path);
    }

    public void saveFile(Path path, String xml, ServiceCallback<String> callback) {
        ((VFSService)this.vfsServiceCaller.call(p -> callback.onSuccess((Object)xml))).write(path, xml);
    }
}

