/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.navigator;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.showcase.client.navigator.DMNDiagramsNavigatorScreen;
import org.kie.workbench.common.dmn.showcase.client.navigator.DMNVFSService;
import org.kie.workbench.common.stunner.client.widgets.event.LoadDiagramEvent;
import org.kie.workbench.common.stunner.client.widgets.explorer.navigator.diagrams.DiagramsNavigator;
import org.kie.workbench.common.stunner.client.widgets.menu.dev.ShapeSetsMenuItemsBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDiagramsNavigatorScreenTest {
    private static final String DIAGRAM_NAME = "diagram-name";
    @Mock
    private DiagramsNavigator diagramsNavigator;
    @Mock
    private ShapeSetsMenuItemsBuilder newDiagramMenuItemsBuilder;
    @Mock
    private DMNVFSService vfsService;
    @Mock
    private Path path;
    private DMNDiagramsNavigatorScreen navigator;

    @Before
    public void setup() {
        this.navigator = new DMNDiagramsNavigatorScreen(this.diagramsNavigator, this.newDiagramMenuItemsBuilder, this.vfsService);
    }

    @Test
    public void testEditNoDocumentSelected() {
        this.navigator.edit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.vfsService});
    }

    @Test
    public void testEditDocumentSelected() {
        LoadDiagramEvent event = new LoadDiagramEvent(this.path, DIAGRAM_NAME);
        this.navigator.onLoadDiagramEvent(event);
        this.navigator.edit();
        ((DMNVFSService)Mockito.verify((Object)this.vfsService)).openFile((Path)Matchers.eq((Object)this.path));
    }
}

