/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.screens.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsPageStateProvider;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.showcase.client.screens.editor.SessionDiagramEditorScreen;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.views.session.ScreenPanelView;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.documentation.DocumentationPage;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class SessionDiagramEditorScreenTest {
    @Mock
    private DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    private ScreenPanelView screenPanelView;
    @Mock
    private SessionEditorPresenter<EditorSession> presenter;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNEditorSession session;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Captor
    private ArgumentCaptor<Consumer<EditorSession>> clientFullSessionConsumer;
    @Mock
    private LayoutHelper layoutHelper;
    @Mock
    private OpenDiagramLayoutExecutor layoutExecutor;
    @Mock
    private KieEditorWrapperView kieView;
    @Mock
    private DataTypesPage dataTypesPage;
    @Mock
    private IncludedModelsPage includedModelsPage;
    @Mock
    private IncludedModelsPageStateProviderImpl importsPageProvider;
    @Mock
    private DocumentationView<Diagram> documentationView;
    @Mock
    private Elemental2DomUtil util;
    @Mock
    private DMNEditorSearchIndex editorSearchIndex;
    @Mock
    private SearchBarComponent<DMNSearchableElement> searchBarComponent;
    @Mock
    private SearchBarComponent.View searchBarComponentView;
    @Mock
    private HTMLElement searchBarComponentViewElement;
    @Mock
    private ElementWrapperWidget searchBarComponentWidget;
    private SessionDiagramEditorScreen editor;

    @Before
    public void setup() {
        Mockito.when((Object)this.searchBarComponent.getView()).thenReturn((Object)this.searchBarComponentView);
        Mockito.when((Object)this.searchBarComponentView.getElement()).thenReturn((Object)this.searchBarComponentViewElement);
        ((SessionEditorPresenter)Mockito.doReturn(this.presenter).when(this.presenter)).withToolbar(Matchers.anyBoolean());
        ((SessionEditorPresenter)Mockito.doReturn(this.presenter).when(this.presenter)).withPalette(Matchers.anyBoolean());
        ((SessionEditorPresenter)Mockito.doReturn(this.presenter).when(this.presenter)).displayNotifications((Predicate)Matchers.any());
        ((SessionEditorPresenter)Mockito.doReturn((Object)this.session).when(this.presenter)).getInstance();
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((DMNEditorSession)Mockito.doReturn((Object)this.expressionEditor).when((Object)this.session)).getExpressionEditor();
        ((SessionEditorPresenter)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Diagram diagram = (Diagram)invocation.getArguments()[0];
                SessionPresenter.SessionPresenterCallback callback = (SessionPresenter.SessionPresenterCallback)invocation.getArguments()[1];
                callback.onOpen(diagram);
                callback.afterCanvasInitialized();
                callback.afterSessionOpened();
                callback.onSuccess();
                return null;
            }
        }).when(this.presenter)).open((Diagram)Matchers.any(Diagram.class), (SessionPresenter.SessionPresenterCallback)Matchers.any(SessionPresenter.SessionPresenterCallback.class));
        this.editor = (SessionDiagramEditorScreen)Mockito.spy((Object)new SessionDiagramEditorScreen(null, null, null, this.sessionManager, null, this.presenter, null, null, this.refreshFormPropertiesEvent, null, this.screenPanelView, null, this.decisionNavigatorDock, this.layoutHelper, this.kieView, this.dataTypesPage, this.layoutExecutor, this.includedModelsPage, this.importsPageProvider, this.documentationView, this.util, this.editorSearchIndex, this.searchBarComponent));
        ((SessionDiagramEditorScreen)Mockito.doReturn((Object)this.searchBarComponentWidget).when((Object)this.editor)).getWidget(this.searchBarComponentViewElement);
    }

    @Test
    public void testInit() {
        Widget screenPanelWidget = (Widget)Mockito.mock(Widget.class);
        MultiPageEditor multiPageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        DocumentationPage documentationPage = (DocumentationPage)Mockito.mock(DocumentationPage.class);
        ((SessionDiagramEditorScreen)Mockito.doReturn((Object)documentationPage).when((Object)this.editor)).getDocumentationPage();
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)multiPageEditor);
        Mockito.when((Object)this.screenPanelView.asWidget()).thenReturn((Object)screenPanelWidget);
        this.editor.init();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("AuthoringPerspective");
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).init((EditorSearchIndex)this.editorSearchIndex);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).setPresenter((KieEditorWrapperView.KieEditorWrapperPresenter)this.editor);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).clear();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieView)).addMainEditorPage((IsWidget)screenPanelWidget);
        ((MultiPageEditor)Mockito.verify((Object)multiPageEditor)).addPage((Page)this.dataTypesPage);
        ((MultiPageEditor)Mockito.verify((Object)multiPageEditor)).addPage((Page)this.includedModelsPage);
        ((MultiPageEditor)Mockito.verify((Object)multiPageEditor)).addPage((Page)documentationPage);
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).setupSearchComponent();
    }

    @Test
    public void testSetupSearchComponent() {
        MultiPageEditor multiPageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)multiPageEditor);
        this.editor.setupSearchComponent();
        ((SearchBarComponent)Mockito.verify(this.searchBarComponent)).init((EditorSearchIndex)this.editorSearchIndex);
        ((MultiPageEditor)Mockito.verify((Object)multiPageEditor)).addTabBarWidget((IsWidget)this.searchBarComponentWidget);
    }

    @Test
    public void testOpenDiagram() {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Command callback = (Command)Mockito.mock(Command.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Mockito.when((Object)this.importsPageProvider.withDiagram(diagram)).thenReturn((Object)this.importsPageProvider);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)canvasHandler);
        Mockito.when((Object)diagram.getMetadata()).thenReturn((Object)metadata);
        this.editor.open(diagram, callback);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.decisionNavigatorDock});
        ((DecisionNavigatorDock)inOrder.verify((Object)this.decisionNavigatorDock)).setupCanvasHandler((CanvasHandler)canvasHandler);
        ((DecisionNavigatorDock)inOrder.verify((Object)this.decisionNavigatorDock)).open();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).reload();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).enableShortcuts();
        ((IncludedModelsPage)Mockito.verify((Object)this.includedModelsPage)).setup((IncludedModelsPageStateProvider)this.importsPageProvider);
    }

    @Test
    public void testOnClose() {
        ((SessionDiagramEditorScreen)Mockito.doNothing().when((Object)this.editor)).destroyDock();
        ((SessionDiagramEditorScreen)Mockito.doNothing().when((Object)this.editor)).destroySession();
        this.editor.onClose();
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).destroyDock();
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).destroySession();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).disableShortcuts();
    }

    @Test
    public void testOpenDock() {
        EditorSession session = (EditorSession)Mockito.mock(EditorSession.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Mockito.when((Object)session.getCanvasHandler()).thenReturn((Object)canvasHandler);
        this.editor.openDock();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).open();
    }

    @Test
    public void testDestroyDock() {
        this.editor.destroyDock();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        MultiPageEditor multiPageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)multiPageEditor);
        this.editor.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((MultiPageEditor)Mockito.verify((Object)multiPageEditor)).selectPage(1);
    }

    @Test
    public void testOnDataTypeEditModeToggleWhenEditModeIsEnabled() {
        DataTypeEditModeToggleEvent event = (DataTypeEditModeToggleEvent)Mockito.mock(DataTypeEditModeToggleEvent.class);
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Menus menus = (Menus)Mockito.mock(Menus.class);
        List<MenuItem> items = Collections.singletonList(menuItem);
        Mockito.when((Object)menus.getItems()).thenReturn(items);
        Mockito.when((Object)event.isEditModeEnabled()).thenReturn((Object)true);
        ((SessionDiagramEditorScreen)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgumentAt(0, Consumer.class)).accept(menus);
            return null;
        }).when((Object)this.editor)).getMenu((Consumer)Matchers.any());
        this.editor.onDataTypeEditModeToggle(event);
        ((MenuItem)Mockito.verify((Object)menuItem)).setEnabled(false);
    }

    @Test
    public void testOnDataTypeEditModeToggleWhenEditModeIsNotEnabled() {
        DataTypeEditModeToggleEvent event = (DataTypeEditModeToggleEvent)Mockito.mock(DataTypeEditModeToggleEvent.class);
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Menus menus = (Menus)Mockito.mock(Menus.class);
        List<MenuItem> items = Collections.singletonList(menuItem);
        Mockito.when((Object)menus.getItems()).thenReturn(items);
        Mockito.when((Object)event.isEditModeEnabled()).thenReturn((Object)false);
        ((SessionDiagramEditorScreen)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgumentAt(0, Consumer.class)).accept(menus);
            return null;
        }).when((Object)this.editor)).getMenu((Consumer)Matchers.any());
        this.editor.onDataTypeEditModeToggle(event);
        ((MenuItem)Mockito.verify((Object)menuItem)).setEnabled(true);
    }

    @Test
    public void testGetOnStartupDiagramEditorCallback() {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String title = "title";
        ((SessionDiagramEditorScreen)Mockito.doNothing().when((Object)this.editor)).updateTitle(Matchers.anyString());
        ((SessionDiagramEditorScreen)Mockito.doReturn((Object)diagram).when((Object)this.editor)).getDiagram();
        Mockito.when((Object)diagram.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getTitle()).thenReturn((Object)"title");
        this.editor.getOnStartupDiagramEditorCallback().execute();
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).updateTitle("title");
        ((DocumentationView)Mockito.verify(this.documentationView)).initialize(diagram);
    }

    @Test
    public void testGetDocumentationPage() {
        DocumentationPage documentationPage = this.editor.getDocumentationPage();
        Assert.assertEquals((Object)"Documentation", (Object)documentationPage.getLabel());
        Assert.assertEquals(this.documentationView, (Object)documentationPage.getDocumentationView());
    }
}

