/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.showcase.client.screens.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.showcase.client.screens.editor.SessionDiagramEditorScreen;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.views.session.ScreenPanelView;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SessionDiagramEditorScreenTest {
    @Mock
    private DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    private ScreenPanelView screenPanelView;
    @Mock
    private SessionEditorPresenter<EditorSession> presenter;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private EditorSession session;
    @Captor
    private ArgumentCaptor<Consumer<EditorSession>> clientFullSessionConsumer;
    private SessionDiagramEditorScreen editor;

    @Before
    public void setup() {
        ((SessionEditorPresenter)Mockito.doReturn(this.presenter).when(this.presenter)).withToolbar(Matchers.anyBoolean());
        ((SessionEditorPresenter)Mockito.doReturn(this.presenter).when(this.presenter)).withPalette(Matchers.anyBoolean());
        ((SessionEditorPresenter)Mockito.doReturn(this.presenter).when(this.presenter)).displayNotifications((Predicate)Matchers.any());
        ((SessionEditorPresenter)Mockito.doReturn((Object)this.session).when(this.presenter)).getInstance();
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((SessionEditorPresenter)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Diagram diagram = (Diagram)invocation.getArguments()[0];
                SessionPresenter.SessionPresenterCallback callback = (SessionPresenter.SessionPresenterCallback)invocation.getArguments()[1];
                callback.onOpen(diagram);
                callback.afterCanvasInitialized();
                callback.afterSessionOpened();
                callback.onSuccess();
                return null;
            }
        }).when(this.presenter)).open((Diagram)Matchers.any(Diagram.class), (SessionPresenter.SessionPresenterCallback)Matchers.any(SessionPresenter.SessionPresenterCallback.class));
        this.editor = (SessionDiagramEditorScreen)Mockito.spy((Object)new SessionDiagramEditorScreen(null, null, null, this.sessionManager, null, this.presenter, null, null, null, this.screenPanelView, null, this.expressionEditor, this.decisionNavigatorDock));
    }

    @Test
    public void testInit() {
        this.editor.init();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("AuthoringPerspective");
    }

    @Test
    public void testOpenDiagram() {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Command callback = (Command)Mockito.mock(Command.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)diagram.getMetadata()).thenReturn((Object)metadata);
        this.editor.open(diagram, callback);
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).openDock(this.session);
    }

    @Test
    public void testOnClose() {
        ((SessionDiagramEditorScreen)Mockito.doNothing().when((Object)this.editor)).destroyDock();
        ((SessionDiagramEditorScreen)Mockito.doNothing().when((Object)this.editor)).destroySession();
        this.editor.onClose();
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).destroyDock();
        ((SessionDiagramEditorScreen)Mockito.verify((Object)this.editor)).destroySession();
    }

    @Test
    public void testOpenDock() {
        EditorSession session = (EditorSession)Mockito.mock(EditorSession.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Mockito.when((Object)session.getCanvasHandler()).thenReturn((Object)canvasHandler);
        this.editor.openDock(session);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).open();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).setupContent((CanvasHandler)canvasHandler);
    }

    @Test
    public void testDestroyDock() {
        this.editor.destroyDock();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
    }
}

