/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.kogito.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.promise.Promise;
import java.util.Objects;
import java.util.function.Supplier;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class BaseKogitoEditor<CONTENT> {
    private boolean isReadOnly;
    private BaseEditorView baseEditorView;
    private PlaceManager placeManager;
    private Menus menus;
    private PlaceRequest place;
    private Integer originalHash;

    protected BaseKogitoEditor() {
    }

    protected BaseKogitoEditor(BaseEditorView baseView, PlaceManager placeManager) {
        this.baseEditorView = baseView;
        this.placeManager = placeManager;
    }

    protected void init(PlaceRequest place) {
        this.place = place;
        this.isReadOnly = this.place.getParameter("readOnly", null) != null;
        this.makeMenuBar();
        this.buildMenuBar();
    }

    protected abstract void makeMenuBar();

    protected abstract void buildMenuBar();

    public void disableMenuItem(MenuItems menuItem) {
        this.setEnableMenuItem(menuItem, false);
    }

    public void enableMenuItem(MenuItems menuItem) {
        this.setEnableMenuItem(menuItem, true);
    }

    private void setEnableMenuItem(MenuItems menuItem, boolean isEnabled) {
        if (this.getMenus().getItemsMap().containsKey(menuItem)) {
            ((MenuItem)this.getMenus().getItemsMap().get(menuItem)).setEnabled(isEnabled);
        }
    }

    protected PlaceRequest getPlaceRequest() {
        return this.place;
    }

    protected PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    protected Menus getMenus() {
        return this.menus;
    }

    protected void setMenus(Menus menus) {
        this.menus = menus;
    }

    protected BaseEditorView getBaseEditorView() {
        return this.baseEditorView;
    }

    protected IsWidget getTitle() {
        return this.baseEditorView.getTitleWidget();
    }

    protected Supplier<CONTENT> getContentSupplier() {
        return () -> null;
    }

    public void setOriginalContentHash(Integer originalHash) {
        this.originalHash = originalHash;
    }

    protected Integer getOriginalContentHash() {
        return this.originalHash;
    }

    protected Integer getCurrentContentHash() {
        try {
            return this.getContentSupplier().get().hashCode();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean mayClose() {
        return !this.isDirty() || this.baseEditorView.confirmClose();
    }

    public boolean isDirty() {
        return !Objects.equals(this.getCurrentContentHash(), this.getOriginalContentHash());
    }

    public abstract void setContent(String var1);

    public abstract Promise getContent();

    public abstract void resetContentHash();
}

