/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.kogito.webapp.base.client.workarounds;

import java.util.List;
import org.appformer.kogito.bridge.client.resource.ResourceContentService;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.kogito.webapp.base.client.workarounds.KogitoResourceContentService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.promise.Promises;
import org.uberfire.commons.uuid.UUID;
import org.uberfire.promise.SyncPromises;

@RunWith(value=MockitoJUnitRunner.class)
public class KogitoResourceContentServiceTest {
    private static final String FILE_NAME = "FILE_NAME";
    private static final String ALL_PATTERN = "*";
    private static final String DMN_PATTERN = "*.dmn";
    private static final String NULL_PATTERN = null;
    private static final String UNKNOWN_FILE = "UNKNOWN_FILE";
    private static final String FILE_CONTENT = "FILE_CONTENT";
    private static final Object REJECT_OBJECT = "REJECT_OBJECT";
    @Mock
    private ResourceContentService resourceContentServiceMock;
    private String[] files;
    private String[] dmnFiles;
    private KogitoResourceContentService kogitoResourceContentService;
    private Promises promises;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.files = new String[6];
        for (int i = 0; i < 6; ++i) {
            String suffix = i < 3 ? "scesim" : "dmn";
            this.files[i] = this.getFileUriMock(suffix);
        }
        this.dmnFiles = new String[3];
        System.arraycopy(this.files, 3, this.dmnFiles, 0, 3);
        ((ResourceContentService)Mockito.doReturn((Object)this.promises.resolve((Object)FILE_CONTENT)).when((Object)this.resourceContentServiceMock)).get(FILE_NAME);
        ((ResourceContentService)Mockito.doReturn((Object)this.promises.reject(REJECT_OBJECT)).when((Object)this.resourceContentServiceMock)).get(UNKNOWN_FILE);
        ((ResourceContentService)Mockito.doReturn((Object)this.promises.resolve((Object)this.files)).when((Object)this.resourceContentServiceMock)).list(ALL_PATTERN);
        ((ResourceContentService)Mockito.doReturn((Object)this.promises.resolve((Object)this.dmnFiles)).when((Object)this.resourceContentServiceMock)).list(DMN_PATTERN);
        ((ResourceContentService)Mockito.doReturn((Object)this.promises.reject(REJECT_OBJECT)).when((Object)this.resourceContentServiceMock)).list(NULL_PATTERN);
        this.kogitoResourceContentService = new KogitoResourceContentService(this.resourceContentServiceMock, (Promises)new SyncPromises());
    }

    @Test
    public void loadFileNoException() {
        RemoteCallback testingCallbackMock = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        this.kogitoResourceContentService.loadFile(FILE_NAME, testingCallbackMock, (ErrorCallback)Mockito.mock(ErrorCallback.class));
        ((ResourceContentService)Mockito.verify((Object)this.resourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).get((String)Matchers.eq((Object)FILE_NAME));
        ((RemoteCallback)Mockito.verify((Object)testingCallbackMock, (VerificationMode)Mockito.times((int)1))).callback(Matchers.eq((Object)FILE_CONTENT));
    }

    @Test
    public void loadFileException() {
        ErrorCallback testingCallbackSpy = (ErrorCallback)Mockito.spy((Object)new ErrorCallback<Object>(){

            public boolean error(Object message, Throwable throwable) {
                Assert.assertEquals((Object)("Error " + REJECT_OBJECT), (Object)message);
                Assert.assertEquals((Object)"Failed to load file UNKNOWN_FILE", (Object)throwable.getMessage());
                return false;
            }
        });
        this.kogitoResourceContentService.loadFile(UNKNOWN_FILE, (RemoteCallback)Mockito.mock(RemoteCallback.class), testingCallbackSpy);
        ((ResourceContentService)Mockito.verify((Object)this.resourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).get((String)Matchers.eq((Object)UNKNOWN_FILE));
        ((ErrorCallback)Mockito.verify((Object)testingCallbackSpy, (VerificationMode)Mockito.times((int)1))).error(Matchers.isA(String.class), (Throwable)Matchers.isA(Throwable.class));
    }

    @Test
    public void getAllItems() {
        RemoteCallback testingCallbackSpy = (RemoteCallback)Mockito.spy((Object)new RemoteCallback<List<String>>(){

            public void callback(List<String> response) {
                Assert.assertEquals((long)KogitoResourceContentServiceTest.this.files.length, (long)response.size());
            }
        });
        this.kogitoResourceContentService.getAllItems(testingCallbackSpy, (ErrorCallback)Mockito.mock(ErrorCallback.class));
        ((ResourceContentService)Mockito.verify((Object)this.resourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).list((String)Matchers.eq((Object)ALL_PATTERN));
        ((RemoteCallback)Mockito.verify((Object)testingCallbackSpy, (VerificationMode)Mockito.times((int)1))).callback(Matchers.isA(List.class));
    }

    @Test
    public void getFilteredItemsNoException() {
        RemoteCallback testingCallbackSpy = (RemoteCallback)Mockito.spy((Object)new RemoteCallback<List<String>>(){

            public void callback(List<String> response) {
                Assert.assertEquals((long)KogitoResourceContentServiceTest.this.dmnFiles.length, (long)response.size());
                response.forEach(fileName -> Assert.assertEquals((Object)"dmn", (Object)fileName.substring(fileName.lastIndexOf(46) + 1)));
            }
        });
        this.kogitoResourceContentService.getFilteredItems(DMN_PATTERN, testingCallbackSpy, (ErrorCallback)Mockito.mock(ErrorCallback.class));
        ((ResourceContentService)Mockito.verify((Object)this.resourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).list((String)Matchers.eq((Object)DMN_PATTERN));
        ((RemoteCallback)Mockito.verify((Object)testingCallbackSpy, (VerificationMode)Mockito.times((int)1))).callback(Matchers.isA(List.class));
    }

    @Test
    public void getFilteredItemsException() {
        ErrorCallback testingCallbackSpy = (ErrorCallback)Mockito.spy((Object)new ErrorCallback<Object>(){

            public boolean error(Object message, Throwable throwable) {
                Assert.assertEquals((Object)("Error " + REJECT_OBJECT), (Object)message);
                Assert.assertEquals((Object)("Failed to retrieve files with pattern " + NULL_PATTERN), (Object)throwable.getMessage());
                return false;
            }
        });
        this.kogitoResourceContentService.getFilteredItems(NULL_PATTERN, (RemoteCallback)Mockito.mock(RemoteCallback.class), testingCallbackSpy);
        ((ResourceContentService)Mockito.verify((Object)this.resourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).list((String)Matchers.eq((Object)NULL_PATTERN));
        ((ErrorCallback)Mockito.verify((Object)testingCallbackSpy, (VerificationMode)Mockito.times((int)1))).error(Matchers.isA(String.class), (Throwable)Matchers.isA(Throwable.class));
    }

    private String getFileUriMock(String suffix) {
        return UUID.uuid() + "." + suffix;
    }
}

