/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.io.IOException;
import java.util.Objects;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class ConsulException
extends RuntimeException {
    private final int code;
    private final boolean hasCode;

    public ConsulException(String message) {
        super(message);
        this.code = 0;
        this.hasCode = false;
    }

    public ConsulException(String message, Throwable throwable) {
        super(message, throwable);
        this.code = 0;
        this.hasCode = false;
    }

    @Deprecated(since="1.7.0", forRemoval=true)
    public ConsulException(int code, Response<?> response) {
        super(String.format("Consul request failed with status [%s]: %s", code, ConsulException.message(response)));
        this.code = code;
        this.hasCode = true;
    }

    public ConsulException(Call<?> call, Response<?> response) {
        super(String.format("Consul request to [%s] failed with status [%s]: %s", call.request().url(), response.code(), ConsulException.message(response)));
        this.code = response.code();
        this.hasCode = true;
    }

    public ConsulException(Throwable throwable) {
        super("Consul request failed", throwable);
        this.code = 0;
        this.hasCode = false;
    }

    static String message(Response<?> response) {
        try {
            ResponseBody responseBody = response.errorBody();
            return Objects.isNull(responseBody) ? response.message() : responseBody.string();
        }
        catch (IOException e) {
            return response.message();
        }
    }

    public boolean hasCode() {
        return this.hasCode;
    }

    public int getCode() {
        return this.code;
    }
}

