/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.consul.BaseCacheableClient;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.ConsulResponse;
import org.kiwiproject.consul.model.kv.Operation;
import org.kiwiproject.consul.model.kv.TxResponse;
import org.kiwiproject.consul.model.kv.Value;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.option.ConsistencyMode;
import org.kiwiproject.consul.option.DeleteOptions;
import org.kiwiproject.consul.option.ImmutablePutOptions;
import org.kiwiproject.consul.option.ImmutableTransactionOptions;
import org.kiwiproject.consul.option.Options;
import org.kiwiproject.consul.option.PutOptions;
import org.kiwiproject.consul.option.QueryOptions;
import org.kiwiproject.consul.option.TransactionOptions;
import org.kiwiproject.consul.util.Jackson;
import org.kiwiproject.consul.util.Lists;
import org.kiwiproject.consul.util.Strings;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class KeyValueClient
extends BaseCacheableClient {
    private static final String CLIENT_NAME = "keyvalue";
    private static final String KEY_MUST_BE_DEFINED = "Key must be defined";
    private static final String RECURSE = "recurse";
    public static final int NOT_FOUND_404 = 404;
    private final Api api;

    KeyValueClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback, Consul.NetworkTimeoutConfig networkTimeoutConfig) {
        super(CLIENT_NAME, config, eventCallback, networkTimeoutConfig);
        this.api = (Api)retrofit.create(Api.class);
    }

    KeyValueClient(Api api, ClientConfig config, ClientEventCallback eventCallback, Consul.NetworkTimeoutConfig networkTimeoutConfig) {
        super(CLIENT_NAME, config, eventCallback, networkTimeoutConfig);
        this.api = api;
    }

    public Optional<Value> getValue(String key) {
        return this.getValue(key, Options.BLANK_QUERY_OPTIONS);
    }

    public Optional<ConsulResponse<Value>> getConsulResponseWithValue(String key) {
        return this.getConsulResponseWithValue(key, Options.BLANK_QUERY_OPTIONS);
    }

    public Optional<Value> getValue(String key, QueryOptions queryOptions) {
        try {
            Call<List<Value>> call = this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery());
            List<Value> values = this.http.extract(call, 404);
            return Lists.firstValueOrEmpty(values);
        }
        catch (ConsulException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return Optional.empty();
        }
    }

    public Optional<ConsulResponse<Value>> getConsulResponseWithValue(String key, QueryOptions queryOptions) {
        try {
            Call<List<Value>> call = this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery());
            ConsulResponse<List<Value>> consulResponse = this.http.extractConsulResponse(call, 404);
            Optional<Value> consulValue = Lists.firstValueOrEmpty(consulResponse.getResponse());
            return consulValue.map(value -> KeyValueClient.newConsulResponse(value, consulResponse));
        }
        catch (ConsulException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return Optional.empty();
        }
    }

    public void getValue(String key, QueryOptions queryOptions, final ConsulResponseCallback<Optional<Value>> callback) {
        ConsulResponseCallback<List<Value>> wrapper = new ConsulResponseCallback<List<Value>>(){

            @Override
            public void onComplete(ConsulResponse<List<Value>> consulResponse) {
                Optional<Value> maybeValue = Lists.firstValueOrEmpty(consulResponse.getResponse());
                ConsulResponse<Optional<Value>> maybeValueResponse = KeyValueClient.newConsulResponse(maybeValue, consulResponse);
                callback.onComplete(maybeValueResponse);
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
        this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery()), wrapper, 404);
    }

    private static <T> ConsulResponse<T> newConsulResponse(T value, ConsulResponse<List<Value>> response) {
        return new ConsulResponse<T>(value, response.getLastContact(), response.isKnownLeader(), response.getIndex(), response.getCacheResponseInfoOrNull());
    }

    public List<Value> getValues(String key) {
        return this.getValues(key, Options.BLANK_QUERY_OPTIONS);
    }

    public ConsulResponse<List<Value>> getConsulResponseWithValues(String key) {
        return this.getConsulResponseWithValues(key, Options.BLANK_QUERY_OPTIONS);
    }

    public List<Value> getValues(String key, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put(RECURSE, "true");
        List<Value> result = this.http.extract(this.api.getValue(Strings.trimLeadingSlash(key), query), 404);
        return Objects.isNull(result) ? List.of() : result;
    }

    public ConsulResponse<List<Value>> getConsulResponseWithValues(String key, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put(RECURSE, "true");
        return this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), query), 404);
    }

    public void getValues(String key, QueryOptions queryOptions, ConsulResponseCallback<List<Value>> callback) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put(RECURSE, "true");
        this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), query), callback, 404);
    }

    public Optional<String> getValueAsString(String key) {
        return this.getValueAsString(key, Charset.defaultCharset());
    }

    public Optional<String> getValueAsString(String key, Charset charset) {
        return this.getValue(key).flatMap(v -> v.getValueAsString(charset));
    }

    public List<String> getValuesAsString(String key) {
        return this.getValuesAsString(key, Charset.defaultCharset());
    }

    public List<String> getValuesAsString(String key, Charset charset) {
        ArrayList<String> result = new ArrayList<String>();
        for (Value value : this.getValues(key)) {
            value.getValueAsString(charset).ifPresent(result::add);
        }
        return result;
    }

    public boolean putValue(String key) {
        return this.putValue(key, null, 0L, Options.BLANK_PUT_OPTIONS, Charset.defaultCharset());
    }

    public boolean putValue(String key, String value) {
        return this.putValue(key, value, 0L, Options.BLANK_PUT_OPTIONS);
    }

    public boolean putValue(String key, String value, Charset charset) {
        return this.putValue(key, value, 0L, Options.BLANK_PUT_OPTIONS, charset);
    }

    public boolean putValue(String key, String value, long flags) {
        return this.putValue(key, value, flags, Options.BLANK_PUT_OPTIONS);
    }

    public boolean putValue(String key, String value, long flags, Charset charset) {
        return this.putValue(key, value, flags, Options.BLANK_PUT_OPTIONS, charset);
    }

    public boolean putValue(String key, String value, long flags, PutOptions putOptions) {
        return this.putValue(key, value, flags, putOptions, Charset.defaultCharset());
    }

    public boolean putValue(String key, String value, long flags, PutOptions putOptions, Charset charset) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)KEY_MUST_BE_DEFINED);
        Map<String, Object> query = putOptions.toQuery();
        if (flags != 0L) {
            query.put("flags", Long.toUnsignedString(flags));
        }
        if (Objects.isNull(value)) {
            return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), query), new Integer[0]);
        }
        return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), RequestBody.create((String)value, (MediaType)MediaType.parse((String)("text/plain; charset=" + charset.name()))), query), new Integer[0]);
    }

    public boolean putValue(String key, byte[] value, long flags, PutOptions putOptions) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)KEY_MUST_BE_DEFINED);
        Map<String, Object> query = putOptions.toQuery();
        if (flags != 0L) {
            query.put("flags", Long.toUnsignedString(flags));
        }
        if (Objects.isNull(value)) {
            return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), query), new Integer[0]);
        }
        return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), RequestBody.create((byte[])value, (MediaType)MediaType.parse((String)"application/octet-stream")), query), new Integer[0]);
    }

    public List<String> getKeys(String key) {
        return this.getKeys(key, Options.BLANK_QUERY_OPTIONS);
    }

    public List<String> getKeys(String key, QueryOptions queryOptions) {
        return this.getKeys(key, null, queryOptions);
    }

    public List<String> getKeys(String key, String separator) {
        return this.getKeys(key, separator, Options.BLANK_QUERY_OPTIONS);
    }

    public List<String> getKeys(String key, String separator, QueryOptions queryOptions) {
        List<String> result;
        Map<String, Object> query = queryOptions.toQuery();
        query.put("keys", "true");
        if (Objects.nonNull(separator)) {
            query.put("separator", separator);
        }
        return Objects.isNull(result = this.http.extract(this.api.getKeys(Strings.trimLeadingSlash(key), query), 404)) ? List.of() : result;
    }

    public void deleteKey(String key) {
        this.deleteKey(key, Options.BLANK_DELETE_OPTIONS);
    }

    public void deleteKeys(String key) {
        this.deleteKey(key, Options.RECURSE_DELETE_OPTIONS);
    }

    public void deleteKey(String key, DeleteOptions deleteOptions) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)KEY_MUST_BE_DEFINED);
        Map<String, Object> query = deleteOptions.toQuery();
        this.http.handle(this.api.deleteValues(Strings.trimLeadingSlash(key), query), new Integer[0]);
    }

    public boolean acquireLock(String key, String session) {
        return this.acquireLock(key, "", session);
    }

    public boolean acquireLock(String key, String value, String session) {
        return this.putValue(key, value, 0L, (PutOptions)ImmutablePutOptions.builder().acquire(session).build());
    }

    public Optional<String> getSession(String key) {
        return this.getValue(key).flatMap(Value::getSession);
    }

    public boolean releaseLock(String key, String sessionId) {
        return this.putValue(key, "", 0L, (PutOptions)ImmutablePutOptions.builder().release(sessionId).build());
    }

    public ConsulResponse<TxResponse> performTransaction(Operation ... operations) {
        ImmutableTransactionOptions immutableTransactionOptions = ImmutableTransactionOptions.builder().consistencyMode(ConsistencyMode.DEFAULT).build();
        return this.performTransaction(immutableTransactionOptions, operations);
    }

    public ConsulResponse<TxResponse> performTransaction(TransactionOptions transactionOptions, Operation ... operations) {
        Map<String, Object> query = transactionOptions.toQuery();
        try {
            String json = Jackson.MAPPER.writeValueAsString((Object)KeyValueClient.kv(operations));
            RequestBody requestBody = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"));
            return this.http.extractConsulResponse(this.api.performTransaction(requestBody, query), new Integer[0]);
        }
        catch (JsonProcessingException e) {
            throw new ConsulException("Error processing JSON", e);
        }
    }

    static KvOperation[] kv(Operation ... operations) {
        KvOperation[] kvs = new KvOperation[operations.length];
        for (int i = 0; i < operations.length; ++i) {
            kvs[i] = new KvOperation(operations[i]);
        }
        return kvs;
    }

    @VisibleForTesting
    public static interface Api {
        @GET(value="kv/{key}")
        public Call<List<Value>> getValue(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="kv/{key}")
        public Call<List<String>> getKeys(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="kv/{key}")
        public Call<Boolean> putValue(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="kv/{key}")
        public Call<Boolean> putValue(@Path(value="key") String var1, @Body RequestBody var2, @QueryMap Map<String, Object> var3);

        @DELETE(value="kv/{key}")
        public Call<Void> deleteValues(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="txn")
        @Headers(value={"Content-Type: application/json"})
        public Call<TxResponse> performTransaction(@Body RequestBody var1, @QueryMap Map<String, Object> var2);
    }

    static class KvOperation {
        private final Operation kv;

        private KvOperation(Operation operation) {
            this.kv = operation;
        }

        public Operation getKv() {
            return this.kv;
        }
    }
}

