/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.acl.BaseTokenResponse;
import org.kiwiproject.consul.model.acl.Token;
import org.kiwiproject.consul.model.acl.TokenListResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="TokenListResponse", generator="Immutables")
public final class ImmutableTokenListResponse
extends TokenListResponse {
    private final String accessorId;
    private final String description;
    private final ImmutableList<Token.PolicyLink> policies;
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;
    private final boolean local;
    private final Date createTime;
    private final String hash;

    private ImmutableTokenListResponse(String accessorId, String description, ImmutableList<Token.PolicyLink> policies, BigInteger createIndex, BigInteger modifyIndex, boolean local, Date createTime, String hash) {
        this.accessorId = accessorId;
        this.description = description;
        this.policies = policies;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
        this.local = local;
        this.createTime = createTime;
        this.hash = hash;
    }

    @Override
    @JsonProperty(value="AccessorID")
    public String accessorId() {
        return this.accessorId;
    }

    @Override
    @JsonProperty(value="Description")
    public String description() {
        return this.description;
    }

    @JsonProperty(value="Policies")
    public ImmutableList<Token.PolicyLink> policies() {
        return this.policies;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger createIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger modifyIndex() {
        return this.modifyIndex;
    }

    @Override
    @JsonProperty(value="Local")
    public boolean local() {
        return this.local;
    }

    @Override
    @JsonProperty(value="CreateTime")
    public Date createTime() {
        return this.createTime;
    }

    @Override
    @JsonProperty(value="Hash")
    public String hash() {
        return this.hash;
    }

    public final ImmutableTokenListResponse withAccessorId(String value) {
        String newValue = Objects.requireNonNull(value, "accessorId");
        if (this.accessorId.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenListResponse(newValue, this.description, this.policies, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, newValue, this.policies, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withPolicies(Token.PolicyLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTokenListResponse(this.accessorId, this.description, (ImmutableList<Token.PolicyLink>)newValue, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withPolicies(Iterable<? extends Token.PolicyLink> elements) {
        if (this.policies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTokenListResponse(this.accessorId, this.description, (ImmutableList<Token.PolicyLink>)newValue, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withCreateIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "createIndex");
        if (this.createIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, newValue, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withModifyIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
        if (this.modifyIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, newValue, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withLocal(boolean value) {
        if (this.local == value) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, this.modifyIndex, value, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withCreateTime(Date value) {
        if (this.createTime == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createTime");
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, this.modifyIndex, this.local, newValue, this.hash);
    }

    public final ImmutableTokenListResponse withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, this.modifyIndex, this.local, this.createTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenListResponse && this.equalsByValue((ImmutableTokenListResponse)another);
    }

    private boolean equalsByValue(ImmutableTokenListResponse another) {
        return this.accessorId.equals(another.accessorId) && this.description.equals(another.description) && this.policies.equals(another.policies) && this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex) && this.local == another.local && this.createTime.equals(another.createTime) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessorId.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.policies.hashCode();
        h += (h << 5) + this.createIndex.hashCode();
        h += (h << 5) + this.modifyIndex.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.local);
        h += (h << 5) + this.createTime.hashCode();
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TokenListResponse").omitNullValues().add("accessorId", (Object)this.accessorId).add("description", (Object)this.description).add("policies", this.policies).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).add("local", this.local).add("createTime", (Object)this.createTime).add("hash", (Object)this.hash).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTokenListResponse fromJson(Json json) {
        Builder builder = ImmutableTokenListResponse.builder();
        if (json._accessorId != null) {
            builder.accessorId(json._accessorId);
        }
        if (json._description != null) {
            builder.description(json._description);
        }
        if (json._policies != null) {
            builder.addAllPolicies(json._policies);
        }
        if (json._createIndex != null) {
            builder.createIndex(json._createIndex);
        }
        if (json._modifyIndex != null) {
            builder.modifyIndex(json._modifyIndex);
        }
        if (json.localIsSet) {
            builder.local(json._local);
        }
        if (json._createTime != null) {
            builder.createTime(json._createTime);
        }
        if (json._hash != null) {
            builder.hash(json._hash);
        }
        return builder.build();
    }

    public static ImmutableTokenListResponse copyOf(TokenListResponse instance) {
        if (instance instanceof ImmutableTokenListResponse) {
            return (ImmutableTokenListResponse)instance;
        }
        return ImmutableTokenListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TokenListResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACCESSOR_ID = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_CREATE_INDEX = 4L;
        private static final long INIT_BIT_MODIFY_INDEX = 8L;
        private static final long INIT_BIT_LOCAL = 16L;
        private static final long INIT_BIT_CREATE_TIME = 32L;
        private static final long INIT_BIT_HASH = 64L;
        private long initBits = 127L;
        @Nullable
        private String accessorId;
        @Nullable
        private String description;
        private ImmutableList.Builder<Token.PolicyLink> policies = ImmutableList.builder();
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;
        private boolean local;
        @Nullable
        private Date createTime;
        @Nullable
        private String hash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseTokenResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenListResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            long bits = 0L;
            if (object instanceof BaseTokenResponse) {
                BaseTokenResponse instance = (BaseTokenResponse)object;
                this.modifyIndex(instance.modifyIndex());
                this.createTime(instance.createTime());
                this.addAllPolicies(instance.policies());
                this.accessorId(instance.accessorId());
                this.description(instance.description());
                this.createIndex(instance.createIndex());
                this.local(instance.local());
                this.hash(instance.hash());
            }
        }

        @JsonProperty(value="AccessorID")
        @CanIgnoreReturnValue
        public final Builder accessorId(String accessorId) {
            this.accessorId = Objects.requireNonNull(accessorId, "accessorId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Token.PolicyLink element) {
            this.policies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPolicies(Token.PolicyLink ... elements) {
            this.policies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Policies")
        @CanIgnoreReturnValue
        public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
            this.policies = ImmutableList.builder();
            return this.addAllPolicies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
            this.policies.addAll(elements);
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder createIndex(BigInteger createIndex) {
            this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder modifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Local")
        @CanIgnoreReturnValue
        public final Builder local(boolean local) {
            this.local = local;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="CreateTime")
        @CanIgnoreReturnValue
        public final Builder createTime(Date createTime) {
            this.createTime = Objects.requireNonNull(createTime, "createTime");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableTokenListResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokenListResponse(this.accessorId, this.description, (ImmutableList<Token.PolicyLink>)this.policies.build(), this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessorId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modifyIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("local");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build TokenListResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="TokenListResponse", generator="Immutables")
    static final class Json
    extends TokenListResponse {
        @JsonIgnore
        @Nullable
        String _accessorId;
        @JsonIgnore
        @Nullable
        String _description;
        @JsonIgnore
        @Nullable
        List<Token.PolicyLink> _policies = ImmutableList.of();
        @JsonIgnore
        @Nullable
        BigInteger _createIndex;
        @JsonIgnore
        @Nullable
        BigInteger _modifyIndex;
        @JsonIgnore
        boolean _local;
        @JsonIgnore
        boolean localIsSet;
        @JsonIgnore
        @Nullable
        Date _createTime;
        @JsonIgnore
        @Nullable
        String _hash;

        Json() {
        }

        @JsonProperty(value="AccessorID")
        public void setAccessorId(String accessorId) {
            this._accessorId = accessorId;
        }

        @JsonProperty(value="Description")
        public void setDescription(String description) {
            this._description = description;
        }

        @JsonProperty(value="Policies")
        public void setPolicies(List<Token.PolicyLink> policies) {
            this._policies = policies;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this._createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this._modifyIndex = modifyIndex;
        }

        @JsonProperty(value="Local")
        public void setLocal(boolean local) {
            this._local = local;
            this.localIsSet = true;
        }

        @JsonProperty(value="CreateTime")
        public void setCreateTime(Date createTime) {
            this._createTime = createTime;
        }

        @JsonProperty(value="Hash")
        public void setHash(String hash) {
            this._hash = hash;
        }

        @Override
        public String accessorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.PolicyLink> policies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger createIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger modifyIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean local() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date createTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hash() {
            throw new UnsupportedOperationException();
        }
    }
}

