/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.model.kv.ImmutableValue;
import org.kiwiproject.consul.util.UnsignedLongDeserializer;

@JsonDeserialize(as=ImmutableValue.class)
@JsonSerialize(as=ImmutableValue.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(jakarta=true)
public abstract class Value {
    @JsonProperty(value="CreateIndex")
    public abstract long getCreateIndex();

    @JsonProperty(value="ModifyIndex")
    public abstract long getModifyIndex();

    @JsonProperty(value="LockIndex")
    public abstract long getLockIndex();

    @JsonProperty(value="Key")
    public abstract String getKey();

    @JsonProperty(value="Flags")
    @JsonDeserialize(using=UnsignedLongDeserializer.class)
    public abstract long getFlags();

    @JsonProperty(value="Value")
    public abstract Optional<String> getValue();

    @JsonProperty(value="Session")
    public abstract Optional<String> getSession();

    @JsonIgnore
    @Value.Lazy
    public Optional<String> getValueAsString() {
        return this.getValueAsString(Charset.defaultCharset());
    }

    @JsonIgnore
    @Value.Lazy
    public Optional<String> getValueAsString(Charset charset) {
        return this.getValue().map(s -> new String(Base64.getDecoder().decode((String)s), charset));
    }

    @JsonIgnore
    @Value.Lazy
    public Optional<byte[]> getValueAsBytes() {
        return this.getValue().map(s -> Base64.getDecoder().decode((String)s));
    }
}

