/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kiwiproject.consul.option.DeleteOptions;
import org.kiwiproject.consul.option.EventOptions;
import org.kiwiproject.consul.option.ImmutableDeleteOptions;
import org.kiwiproject.consul.option.ImmutableEventOptions;
import org.kiwiproject.consul.option.ImmutablePutOptions;
import org.kiwiproject.consul.option.ImmutableQueryOptions;
import org.kiwiproject.consul.option.ImmutableQueryParameterOptions;
import org.kiwiproject.consul.option.ImmutableRoleOptions;
import org.kiwiproject.consul.option.ImmutableTokenQueryOptions;
import org.kiwiproject.consul.option.ImmutableTransactionOptions;
import org.kiwiproject.consul.option.ParamAdder;
import org.kiwiproject.consul.option.PutOptions;
import org.kiwiproject.consul.option.QueryOptions;
import org.kiwiproject.consul.option.QueryParameterOptions;
import org.kiwiproject.consul.option.RoleOptions;
import org.kiwiproject.consul.option.TokenQueryOptions;
import org.kiwiproject.consul.option.TransactionOptions;

public class Options {
    public static final DeleteOptions BLANK_DELETE_OPTIONS = ImmutableDeleteOptions.builder().build();
    public static final DeleteOptions RECURSE_DELETE_OPTIONS = ImmutableDeleteOptions.builder().recurse(true).build();
    public static final EventOptions BLANK_EVENT_OPTIONS = ImmutableEventOptions.builder().build();
    public static final PutOptions BLANK_PUT_OPTIONS = ImmutablePutOptions.builder().build();
    public static final QueryOptions BLANK_QUERY_OPTIONS = ImmutableQueryOptions.builder().build();
    public static final QueryParameterOptions BLANK_QUERY_PARAMETER_OPTIONS = ImmutableQueryParameterOptions.builder().build();
    public static final RoleOptions BLANK_ROLE_OPTIONS = ImmutableRoleOptions.builder().build();
    public static final TokenQueryOptions BLANK_TOKEN_QUERY_OPTIONS = ImmutableTokenQueryOptions.builder().build();
    public static final TransactionOptions BLANK_TRANSACTION_OPTIONS = ImmutableTransactionOptions.builder().build();

    private Options() {
    }

    static void optionallyAdd(Map<String, Object> data, String key, Optional<?> val) {
        val.ifPresent(value -> data.put(key, value.toString()));
    }

    public static Map<String, Object> from(ParamAdder ... options) {
        Preconditions.checkArgument((boolean)Objects.nonNull(options), (Object)"the options vararg must not be null");
        return Arrays.stream(options).filter(Objects::nonNull).map(ParamAdder::toQuery).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static void optionallyAdd(List<String> data, String key, Optional<Boolean> val) {
        val.ifPresent(value -> {
            if (value.booleanValue()) {
                data.add(key);
            }
        });
    }
}

