/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SecondsDeserializer
extends JsonDeserializer<Long> {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z]");

    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String durationString = p.getValueAsString();
        if (StringUtils.isNotBlank((CharSequence)durationString)) {
            String duration = PATTERN.matcher(durationString).replaceAll("");
            return SecondsDeserializer.toLongOrThrow(duration);
        }
        return null;
    }

    private static Long toLongOrThrow(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Expected a number but received a non-numeric value", e);
        }
    }
}

