/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;

public class ChangesetCommentCheck
extends AbstractLiquibaseBasicForecastRule {
    public ChangesetCommentCheck() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean shouldBeEvaluated(ChangeSet changeSet) {
        return super.shouldBeEvaluated(changeSet) && this.hasNoTagDatabaseChanges(changeSet);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet) {
        if (changeSet.getComments() == null || changeSet.getComments().isEmpty()) {
            return this.putResultUnsuccessful(changeSet, "Liquibase recommends that authors include comments about the purpose and impact of a changeset in <comment> elements to prevent the development of undocumented or siloed knowledge and ensure that the purpose of a given changeset is easily understood by other people who use this changelog.");
        }
        return this.putResultSuccessful(changeSet, true, null);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "Changesets Must Have a Comment Assigned";
    }

    @Override
    public String getDescription() {
        return "This check enforces the Liquibase recommendation that comments be added to each changeset to document the purpose of a changeset for other/future consumers of this changelog";
    }

    @Override
    public String getShortName() {
        return "ChangesetCommentCheck";
    }

    @Override
    public int getPriority() {
        return 176;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    private boolean hasNoTagDatabaseChanges(ChangeSet changeSet) {
        return changeSet.getChanges().stream().noneMatch(change -> change instanceof TagDatabaseChange);
    }
}

