/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule$SupportedChangesetFormats;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SqlNotAllowedToContainUseDatabase
extends AbstractNotAllowedToContainRule {
    public SqlNotAllowedToContainUseDatabase() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that Changesets which include USE DATABASE are reviewed carefully to ensure the specified database is as intended.";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public String getDescription() {
        return "This check warns a user when generated or raw SQL contains 'USE DATABASE' directive.";
    }

    @Override
    public String getName() {
        return "Warn on Detection of 'USE DATABASE' statements";
    }

    @Override
    public String getShortName() {
        return "WarnOnUseDatabase";
    }

    @Override
    public int getPriority() {
        return 25;
    }

    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("use\\s*\\S+.*"), Pattern.compile("use\\s*\\[.+].*"), Pattern.compile("use\\s*\".+\".*"), Pattern.compile("use\\s*`.+`.*"));
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule$SupportedChangesetFormats.ALL;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }
}

