/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringListGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.AbstractObjectNamingRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule$SupportedChangesetFormats;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;

public abstract class AbstractObjectNamingListRule
extends AbstractObjectNamingRule {
    protected AbstractObjectNamingListRule() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doInternalEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    private boolean doInternalEvaluate(List<Change> list, ChangeSet changeSet, DynamicRule dynamicRule, boolean bl2) {
        List<String> list2 = StringListGetter.split((String)dynamicRule.getParameter(DynamicRuleParameterEnum.ALLOWED_LIST).getValue());
        dynamicRule.getParameters().add(new DynamicRuleParameter(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.EQUALS.toString()));
        Boolean bl3 = null;
        Iterator<String> iterator = this.getForbiddenWords().iterator();
        while (iterator.hasNext() && (bl3 == null || !bl3.booleanValue())) {
            Object object = iterator.next();
            if (list2.contains(object)) continue;
            object = new DynamicRuleParameter(DynamicRuleParameterEnum.SEARCH_STRING, object);
            dynamicRule.getParameters().add((DynamicRuleParameter)object);
            if (bl2) {
                super.internalRollbackEvaluate(changeSet, list, null, dynamicRule);
            } else {
                super.internalEvaluate(changeSet, dynamicRule);
            }
            dynamicRule.getParameters().remove(object);
            if (bl3 != null) continue;
            bl3 = this.getResults().get(changeSet).hasSqlParseFailures();
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, bl2);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        List<String> list = StringListGetter.split((String)dynamicRule.getParameter(DynamicRuleParameterEnum.ALLOWED_LIST).getValue());
        dynamicRule.getParameters().add(new DynamicRuleParameter(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.EQUALS.toString()));
        for (String string : this.getForbiddenWords()) {
            if (list.contains(string)) continue;
            DynamicRuleParameter dynamicRuleParameter = new DynamicRuleParameter(DynamicRuleParameterEnum.SEARCH_STRING, string);
            dynamicRule.getParameters().add(dynamicRuleParameter);
            super.internalEvaluate(databaseObject, dynamicRule);
            dynamicRule.getParameters().remove(dynamicRuleParameter);
        }
        return this.returnAtEndOfRule(databaseObject, dynamicRule);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> list, Database database, DynamicRule dynamicRule) {
        return this.doInternalEvaluate(list, changeSet, dynamicRule, true);
    }

    @Override
    public boolean shouldParseSql() {
        return false;
    }

    @Override
    public boolean operatorMatchCallback(boolean bl2) {
        return bl2;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OBJECT_TYPES), new RuleParameter<String>(DynamicRuleParameterEnum.ALLOWED_LIST, (string, list) -> StringListGetter.validate(string, this.getForbiddenWords(), this.getAllowedListValidationErrorMessage()), null, null, true), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE));
    }

    public abstract Set<String> getForbiddenWords();

    public abstract String getAllowedListValidationErrorMessage();

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule$SupportedChangesetFormats.MODELED;
    }
}

