/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.InternalFormattedDiffCommandStep;
import com.datical.liquibase.ext.command.helpers.ReportCommandArguments;
import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.reports.AbstractReport;
import com.datical.liquibase.ext.reports.DatabaseObjectReportValue;
import com.datical.liquibase.ext.reports.DriftReport;
import com.datical.liquibase.ext.reports.DriftReportMode;
import com.datical.liquibase.ext.reports.DriftReportParameters;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.reports.ReportUtils;
import com.datical.liquibase.ext.reports.TextDriftReport;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import com.datical.liquibase.ext.util.UrlUtil;
import java.awt.Desktop;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.command.core.helpers.ReferenceDbUrlConnectionCommandStep;
import liquibase.command.providers.ReferenceDatabase;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.NetUtil;
import liquibase.util.ValueHandlerUtil;

public class DriftReportCommandStep
extends AbstractCommandStep {
    public static String[] COMMAND_NAME = new String[]{"driftReport"};
    public static final CommandArgumentDefinition<Boolean> OPEN_REPORT;
    public static final CommandArgumentDefinition<DriftReportMode> REPORT_MODE;
    public static final List<String> DB_URL_VISIBLE_KEYS;
    private static final int CONNECTION_URL_MAX_LENGTH = 128;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(DiffResult.class, FormattedDiffModel.class, Database.class, ReferenceDatabase.class, ReportArguments.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (Arrays.equals(commandDefinition.getName(), COMMAND_NAME)) {
            commandDefinition.setHidden(true);
        }
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        Object object2 = (ReportArguments)object.getDependency(ReportArguments.class);
        if (!((ReportArguments)object2).getEnabled().booleanValue()) {
            return;
        }
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        String string = ((ReportArguments)object2).getPath();
        ((ReportArguments)object2).getFormat();
        DriftReportMode driftReportMode = (DriftReportMode)((Object)object.getArgumentValue(REPORT_MODE));
        Boolean bl2 = (Boolean)object.getArgumentValue(OPEN_REPORT);
        String string2 = ((ReportArguments)object2).getName();
        LocalDateTime localDateTime = LocalDateTime.now();
        if (string2.equals(ReportCommandArguments.REPORT_NAME_EXAMPLE)) {
            string2 = String.format("report-%s", ((ReportArguments)object2).buildReportDateFormat(localDateTime));
        }
        Scope.getCurrentScope().getUI().sendMessage("Generating drift report...");
        localDateTime = (Database)object.getDependency(Database.class);
        Database database = (Database)object.getDependency(ReferenceDatabase.class);
        DiffResult diffResult = (DiffResult)commandResultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        String string3 = NetUtil.getLocalHostName();
        String string4 = EnvironmentUtils.getSystemUsername();
        Integer n2 = (Integer)commandResultsBuilder.getResult("driftExitCode");
        boolean bl3 = n2 != null && n2 != 0;
        Object object3 = new TextDriftReport(diffResult);
        List<DatabaseObjectReportValue> list = object3.getMissingValues();
        List<DatabaseObjectReportValue> list2 = object3.getUnexpectedValues();
        object3 = object3.getChangedValues();
        int n3 = diffResult.getMissingObjects().size();
        int n4 = diffResult.getUnexpectedObjects().size();
        int n5 = diffResult.getChangedObjects().size();
        Object object4 = (FormattedDiffModel)((Object)object.getDependency(FormattedDiffModel.class));
        if (object4 == null) {
            object4 = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        }
        Object object5 = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        Object object6 = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        object4.databases = null;
        object4.unexpectedObjects = null;
        object4.changedObjects = null;
        object5.databases = null;
        object5.missingObjects = null;
        object5.changedObjects = null;
        object6.databases = null;
        object6.missingObjects = null;
        object6.unexpectedObjects = null;
        object4 = InternalFormattedDiffCommandStep.serialize(object4);
        object5 = InternalFormattedDiffCommandStep.serialize(object5);
        object6 = InternalFormattedDiffCommandStep.serialize(object6);
        String string5 = ((ReportArguments)object2).isNameSetGlobally() ? ReportConfiguration.NAME.getKey() : "liquibase.command.diff.reportName";
        String string6 = ((ReportArguments)object2).isPathSetGlobally() ? ReportConfiguration.PATH.getKey() : "liquibase.command.diff.reportPath";
        object2 = ((ReportArguments)object2).isFormatSetGlobally() ? ReportConfiguration.FORMAT.getKey() : "liquibase.command.diff.reportFormat";
        String string7 = (String)object.getArgumentValue(DbUrlConnectionCommandStep.URL_ARG);
        object = (String)object.getArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_URL_ARG);
        String string8 = string7.length() >= 128 ? UrlUtil.handleSqlServerDbUrlParameters(DB_URL_VISIBLE_KEYS, string7) : string7;
        Object object7 = ((String)object).length() >= 128 ? UrlUtil.handleSqlServerDbUrlParameters(DB_URL_VISIBLE_KEYS, (String)object) : object;
        string8 = this.appendEllipsisIfDifferent(string7, this.hideConnectionUrlLength(string8));
        object7 = this.appendEllipsisIfDifferent((String)object, this.hideConnectionUrlLength((String)object7));
        String string9 = ReportUtils.getDisplayArgs((String[])Scope.getCurrentScope().get("commandArguments", String[].class));
        object = new DriftReportParameters(string2, string7, (String)object, string8, (String)object7, string4, string3, list, list2, (List<DatabaseObjectReportValue>)object3, (String)object4, (String)object5, (String)object6, String.valueOf(n3), String.valueOf(n4), String.valueOf(n5), driftReportMode == DriftReportMode.ALL || driftReportMode == DriftReportMode.MISSING, driftReportMode == DriftReportMode.ALL || driftReportMode == DriftReportMode.UNEXPECTED, driftReportMode == DriftReportMode.ALL || driftReportMode == DriftReportMode.CHANGED, string, string9, driftReportMode.name(), string5, string6, (String)object2);
        object = new DriftReport(string2, string, (DriftReportParameters)object);
        ((AbstractReport)object).generateReport();
        if (bl2.booleanValue()) {
            this.openInBrowser(((AbstractReport)object).getFullPath());
        }
        if (bl3) {
            throw commandResultsBuilder.commandFailed(String.format("ERROR: Liquibase detected drift of %d missing, %d changed, and %d unexpected objects between target '%s' and reference '%s'.%nFor additional details, inspect the output, set --format=JSON, or learn more at https://docs.liquibase.com/drift-reports.%nDiff command exited with error code %d", diffResult.getMissingObjects().size(), diffResult.getChangedObjects().size(), diffResult.getUnexpectedObjects().size(), localDateTime.getConnection().getURL(), database.getConnection().getURL(), n2), n2.intValue(), true);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int n2 = super.getOrder(commandDefinition);
        if (n2 < 0 && !commandDefinition.getName()[0].equals(DiffCommandStep.COMMAND_NAME[0])) {
            return n2;
        }
        return 1100;
    }

    private void openInBrowser(String string) {
        try {
            Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                desktop.open(new File(string));
            }
            return;
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not open report in browser!", (Throwable)exception);
            return;
        }
    }

    private String hideConnectionUrlLength(String string) {
        if (string.length() >= 128) {
            return string.substring(0, 127);
        }
        return string;
    }

    private String appendEllipsisIfDifferent(String string, String string2) {
        if (!string.equalsIgnoreCase(string2)) {
            return String.format("%s...", string2);
        }
        return string;
    }

    static {
        DB_URL_VISIBLE_KEYS = Arrays.asList("servername", "database", "databaseName");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        OPEN_REPORT = commandBuilder.argument("openReport", Boolean.class).description("Open the Diff Report in your default browser.").defaultValue((Object)Boolean.FALSE).hidden().optional().build();
        REPORT_MODE = commandBuilder.argument("reportMode", DriftReportMode.class).description(String.format("The report mode of the Drift Report. The report mode defines the differences to include in the Drift Report. Valid modes include: %s", Stream.of(DriftReportMode.values()).map(Enum::name).collect(Collectors.joining(", ")))).setValueHandler(object -> (DriftReportMode)ValueHandlerUtil.getEnum(DriftReportMode.class, (Object)object, (String)"Drift Report Mode")).defaultValue((Object)DriftReportMode.ALL).hidden().build();
    }
}

