/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.command.FlowValidateCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.provider.StageGlobalArgsValueProvider;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowFileRoot;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFailedException;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public class FlowCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final CommandArgumentDefinition<String> FLOW_SHELL_INTERPRETER;
    public static final CommandArgumentDefinition<Boolean> FLOW_SHELL_KEEP_TEMP_FILES;
    public static final CommandArgumentDefinition<FlowFile> FLOW_FILE_DTO;
    public static final String DEFAULT_FLOW_FILE_NAME = "liquibase.flowfile.yaml";
    public static final String BANNER = "******************************************************************************";
    public static final String STATUS_CODE = "statusCode";
    public static final String FAIL = "Fail";
    public static final String SUCCESS = "Success";
    private Boolean validated;
    private FlowFileLoad flowFileLoad;

    @Override
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
        try {
            CommandScope commandScope2 = new CommandScope(FlowValidateCommandStep.COMMAND_NAME);
            for (Map.Entry entry : commandScope2.getCommand().getArguments().entrySet()) {
                ConfiguredValue configuredValue = commandScope.getConfiguredValue((CommandArgumentDefinition)entry.getValue());
                if (configuredValue.wasDefaultValueUsed()) continue;
                commandScope2.addArgumentValue((String)entry.getKey(), configuredValue.getValue());
            }
            CommandResults commandResults = commandScope2.execute();
            this.validated = (Boolean)commandResults.getResult("validated");
            this.flowFileLoad = (FlowFileLoad)commandResults.getResult("flowFilePath");
            return;
        }
        catch (CommandExecutionException commandExecutionException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error during validation", (Throwable)commandExecutionException);
            throw new CommandValidationException("Error during validation: " + commandExecutionException.getMessage());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public void run(CommandResultsBuilder object) {
        String string;
        Object object2;
        Object object32;
        Object object4;
        block55: {
            Object object52;
            String string2;
            CommandExecutionException commandExecutionException;
            int n2;
            block54: {
                if (this.validated == null || Boolean.FALSE.equals(this.validated)) {
                    object.addResult(STATUS_CODE, (Object)0);
                    return;
                }
                object4 = this.flowFileLoad != null ? this.flowFileLoad.flowFile : null;
                if (object4 == null) {
                    object.addResult(STATUS_CODE, (Object)0);
                    return;
                }
                object32 = object.getCommandScope();
                object2 = ((FlowFile)object4).getStages();
                string = Instant.ofEpochMilli(new Date().getTime()).toString();
                n2 = 0;
                commandExecutionException = null;
                string2 = null;
                Object object6 = ((FlowFile)object4).getUserMetadata();
                if (!CollectionUtil.createIfNull(object6).isEmpty()) {
                    Scope.getCurrentScope().addMdcValue("userMetadata", object6);
                }
                if (object2 == null || ((HashMap)object2).isEmpty()) {
                    Scope.getCurrentScope().getUI().sendMessage("No stages found.");
                    break block54;
                }
                object6 = this.flowFileLoad;
                for (Object object52 : ((LinkedHashMap)object2).entrySet()) {
                    string2 = object52.getKey();
                    this.executeStage(object52.getValue(), string2, (CommandResultsBuilder)object, (FlowFile)object4);
                }
                this.flowFileLoad = object6;
            }
            try {
                this.executeStage(((FlowFile)object4).getEndStage(), "endStage", (CommandResultsBuilder)object, (FlowFile)object4);
            }
            catch (CommandExecutionException commandExecutionException2) {
                try {
                    if (this.findExitCode(commandExecutionException2) > 0 || commandExecutionException == null) {
                        commandExecutionException = commandExecutionException2;
                    } else {
                        this.showExceptionMessageOnConsole(commandExecutionException2);
                    }
                    this.handleCommandExecutionException((FlowFile)object4, (CommandScope)object32, (LinkedHashMap<String, Stage>)object2, string, string2, true, commandExecutionException);
                }
                catch (Throwable throwable) {
                    for (Object object32 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                        object2 = object32.getValue();
                        object32 = (String)object32.getKey();
                        try {
                            ((OutputStream)object2).close();
                        }
                        catch (Exception exception) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object32)), (Throwable)exception);
                        }
                    }
                    throw throwable;
                }
                for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                    object52 = entry.getValue();
                    String string3 = entry.getKey();
                    try {
                        ((OutputStream)object52).close();
                    }
                    catch (Exception exception) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(string3)), (Throwable)exception);
                    }
                }
                break block55;
            }
            for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                object52 = entry.getValue();
                String string4 = (String)entry.getKey();
                try {
                    ((OutputStream)object52).close();
                }
                catch (Exception exception) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(string4)), (Throwable)exception);
                }
            }
            break block55;
            catch (CommandExecutionException commandExecutionException3) {
                n2 = this.findExitCode(commandExecutionException3);
                commandExecutionException = commandExecutionException3;
                this.showExceptionMessageOnConsole(commandExecutionException);
                this.handleCommandExecutionException((FlowFile)object4, (CommandScope)object32, (LinkedHashMap<String, Stage>)object2, string, string2, false, commandExecutionException3);
                try {
                    this.executeStage(((FlowFile)object4).getEndStage(), "endStage", (CommandResultsBuilder)object, (FlowFile)object4);
                }
                catch (CommandExecutionException commandExecutionException4) {
                    try {
                        if (this.findExitCode(commandExecutionException4) > n2) {
                            commandExecutionException = commandExecutionException4;
                        } else {
                            this.showExceptionMessageOnConsole(commandExecutionException4);
                        }
                        this.handleCommandExecutionException((FlowFile)object4, (CommandScope)object32, (LinkedHashMap<String, Stage>)object2, string, string2, true, commandExecutionException);
                    }
                    catch (Throwable throwable) {
                        for (Object object32 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                            object2 = object32.getValue();
                            object32 = (String)object32.getKey();
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (Exception exception) {
                                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object32)), (Throwable)exception);
                            }
                        }
                        throw throwable;
                    }
                    for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                        OutputStream outputStream = entry.getValue();
                        String string5 = entry.getKey();
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(string5)), (Throwable)exception);
                        }
                    }
                    break block55;
                }
                for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                    OutputStream outputStream = entry.getValue();
                    String string6 = entry.getKey();
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(string6)), (Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    block56: {
                        try {
                            this.executeStage(((FlowFile)object4).getEndStage(), "endStage", (CommandResultsBuilder)object, (FlowFile)object4);
                        }
                        catch (CommandExecutionException commandExecutionException5) {
                            try {
                                if (this.findExitCode(commandExecutionException5) > n2 || commandExecutionException == null) {
                                    commandExecutionException = commandExecutionException5;
                                } else {
                                    this.showExceptionMessageOnConsole(commandExecutionException5);
                                }
                                this.handleCommandExecutionException((FlowFile)object4, (CommandScope)object32, (LinkedHashMap<String, Stage>)object2, string, string2, true, commandExecutionException);
                            }
                            catch (Throwable throwable2) {
                                for (Object object32 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                                    object2 = object32.getValue();
                                    object32 = (String)object32.getKey();
                                    try {
                                        ((OutputStream)object2).close();
                                    }
                                    catch (Exception exception) {
                                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object32)), (Throwable)exception);
                                    }
                                }
                                throw throwable2;
                            }
                            for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                                object4 = entry.getValue();
                                object32 = entry.getKey();
                                try {
                                    ((OutputStream)object4).close();
                                }
                                catch (Exception exception) {
                                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object32)), (Throwable)exception);
                                }
                            }
                            break block56;
                        }
                        for (Map.Entry entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                            object4 = (OutputStream)entry.getValue();
                            object32 = (String)entry.getKey();
                            try {
                                ((OutputStream)object4).close();
                            }
                            catch (Exception exception) {
                                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object32)), (Throwable)exception);
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
        this.addFlowInfoToMdc((FlowFile)object4, (CommandScope)object32, (LinkedHashMap<String, Stage>)object2, string, null, null);
        object.addResult(STATUS_CODE, (Object)0);
    }

    private void showExceptionMessageOnConsole(CommandExecutionException object) {
        if (StringUtil.isNotEmpty((String)(object = object.getMessage()))) {
            object = ((String)object).replaceAll("liquibase.exception.*: ", "");
            object = "ERROR: ".concat(String.valueOf(object));
            Scope.getCurrentScope().getUI().sendErrorMessage((String)object);
        }
    }

    private int findExitCode(CommandExecutionException throwable) {
        while (throwable != null && !(throwable instanceof CommandFailedException)) {
            throwable = (Exception)throwable.getCause();
        }
        if (throwable != null) {
            return ((CommandFailedException)throwable).getExitCode();
        }
        return 0;
    }

    private void handleCommandExecutionException(FlowFile flowFile, CommandScope object, LinkedHashMap<String, Stage> linkedHashMap, String string, String string2, boolean bl2, CommandExecutionException commandExecutionException) {
        this.addFlowInfoToMdc(flowFile, (CommandScope)object, linkedHashMap, string, string2, commandExecutionException.getMessage());
        Scope.getCurrentScope().getLog(FlowCommandStep.class).warning("Exception occurred", (Throwable)commandExecutionException);
        flowFile = this.findCommandFailedException((Exception)((Object)commandExecutionException));
        if (flowFile != null) {
            object = flowFile.getMessage();
            if (bl2) {
                object = ((String)object).replaceAll("(.*?) command", "Flow command");
                throw new CommandFailedException(flowFile.getResults(), flowFile.getExitCode(), (String)object, true);
            }
            throw flowFile;
        }
        throw commandExecutionException;
    }

    private CommandFailedException findCommandFailedException(Exception exception) {
        while (exception != null && exception.getCause() != null) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof CommandFailedException) {
                return (CommandFailedException)throwable;
            }
            exception = (Exception)exception.getCause();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFlowInfoToMdc(FlowFile object, CommandScope object2, LinkedHashMap<String, Stage> serializable, String object3, String object4, String object5) {
        block59: {
            if (serializable == null) return;
            if (((HashMap)serializable).isEmpty()) {
                return;
            }
            Object object6 = Instant.ofEpochMilli(new Date().getTime()).toString();
            Scope.getCurrentScope().getMdcManager().clear();
            object2 = (String)object2.getConfiguredValue(FLOW_FILE).getValue();
            object = ((FlowFile)object).getEndStage();
            object = new FlowFileRoot((String)object2, this.flowFileLoad, (Map<String, Stage>)((Object)serializable), (Stage)object);
            object2 = Scope.getCurrentScope().addMdcValue("flowStart", (String)object3);
            serializable = null;
            try {
                object = Scope.getCurrentScope().addMdcValue("flowFileRoot", (CustomMdcObject)object);
                object3 = null;
                try {
                    object6 = Scope.getCurrentScope().addMdcValue("flowStop", (String)object6);
                    Throwable throwable = null;
                    try {
                        Throwable throwable2 = null;
                        try (MdcObject mdcObject = Scope.getCurrentScope().addMdcValue("flowFileOutcome", object4 != null ? FAIL : SUCCESS);){
                            object4 = this.handleFlowFileError((String)object4, (String)object5);
                            object5 = null;
                            try {
                                String string = "Flow command complete";
                                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(string);
                            }
                            catch (Throwable throwable3) {
                                Throwable throwable4 = throwable3;
                                object5 = throwable3;
                                throw throwable4;
                            }
                            finally {
                                if (object4 != null) {
                                    if (object5 != null) {
                                        try {
                                            object4.close();
                                        }
                                        catch (Throwable throwable5) {
                                            ((Throwable)object5).addSuppressed(throwable5);
                                        }
                                    } else {
                                        object4.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            object4 = throwable4;
                            throwable2 = throwable4;
                            throw object4;
                        }
                    }
                    catch (Throwable throwable5) {
                        Throwable throwable8 = throwable5;
                        throwable = throwable5;
                        throw throwable8;
                    }
                    finally {
                        if (object6 != null) {
                            if (throwable != null) {
                                try {
                                    object6.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                            } else {
                                object6.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object6 = throwable;
                    object3 = throwable;
                    throw object6;
                }
                finally {
                    if (object != null) {
                        if (object3 != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            object.close();
                        }
                    }
                }
                if (object2 == null) return;
                if (serializable == null) break block59;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    serializable = throwable;
                    throw object;
                }
                catch (Throwable throwable10) {
                    if (object2 == null) throw throwable10;
                    if (serializable == null) {
                        object2.close();
                        throw throwable10;
                    }
                    try {
                        object2.close();
                        throw throwable10;
                    }
                    catch (Throwable throwable11) {
                        ((Throwable)serializable).addSuppressed(throwable11);
                        throw throwable10;
                    }
                }
            }
            try {
                object2.close();
                return;
            }
            catch (Throwable throwable) {
                ((Throwable)serializable).addSuppressed(throwable);
                return;
            }
        }
        object2.close();
    }

    private MdcObject handleFlowFileError(String string, String string2) {
        if (string == null) {
            return null;
        }
        Scope.getCurrentScope().addMdcValue("flowFileFailedStage", string);
        return Scope.getCurrentScope().addMdcValue("flowFileFailedMessage", string2);
    }

    private void executeStage(Stage stage, String string, CommandResultsBuilder commandResultsBuilder, FlowFile flowFile) {
        Scope.child(Collections.emptyMap(), () -> {
            if (stage == null) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Empty stage '" + (String)string + "' found"));
                return;
            }
            LiquibaseConfiguration liquibaseConfiguration = stage.getCombinedUserMetadata(flowFile.getUserMetadata());
            if (!CollectionUtil.createIfNull(liquibaseConfiguration).isEmpty()) {
                Scope.getCurrentScope().addMdcValue("userMetadata", liquibaseConfiguration);
            }
            if (stage.getActions() == null || stage.getActions().isEmpty()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("No actions found for Stage: ".concat(String.valueOf(string))));
                return;
            }
            if (stage.getCondition() != null && !stage.getCondition().evaluate()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping stage: " + (String)string + " because condition '" + stage.getCondition().getRawConditionText() + "' evaluated to false."));
                return;
            }
            liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            StageGlobalArgsValueProvider stageGlobalArgsValueProvider = new StageGlobalArgsValueProvider(stage.getGlobalArgs());
            try {
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)stageGlobalArgsValueProvider);
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Executing Stage: ".concat(String.valueOf(string))));
                for (Action action : stage.getActions()) {
                    this.runAction(commandResultsBuilder, action, stage, flowFile);
                }
                return;
            }
            finally {
                liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)stageGlobalArgsValueProvider);
            }
        });
    }

    private void runAction(CommandResultsBuilder commandResultsBuilder, Action action, Stage stage, FlowFile flowFile) {
        if (action.getCondition() != null && !action.getCondition().evaluate()) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping action: " + action + " because condition '" + action.getCondition().getRawConditionText() + "' evaluated to false."));
            return;
        }
        try {
            Scope.getCurrentScope().addMdcValue("liquibaseCommandName", "flow");
            CommandScope commandScope = commandResultsBuilder.getCommandScope();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
            Scope.child(hashMap, () -> {
                if (!CollectionUtil.createIfNull(flowFile = action.getCombinedUserMetadata(((FlowFile)flowFile).getUserMetadata(), stage.getUserMetadata())).isEmpty()) {
                    Scope.getCurrentScope().addMdcValue("userMetadata", (Map)((Object)flowFile));
                }
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner(String.format("Executing %s", action)));
                action.execute(commandResultsBuilder);
                Scope.getCurrentScope().getUI().sendMessage("");
            });
            return;
        }
        catch (Exception exception) {
            throw new CommandExecutionException((Throwable)exception);
        }
    }

    private String createBanner(String string) {
        return String.format("%s%n* %n* %s%n* %n%s%n", BANNER, string, BANNER);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Run a series of commands contained in one or more stages, as configured in a liquibase flow-file."));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument("flowFile", String.class).defaultValue((Object)DEFAULT_FLOW_FILE_NAME).description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)Boolean.TRUE).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
        FLOW_SHELL_INTERPRETER = commandBuilder.argument("flowShellInterpreter", String.class).description("The default interpreter used to execute shell commands. EXAMPLES: bash, sh, cmd.").build();
        FLOW_SHELL_KEEP_TEMP_FILES = commandBuilder.argument("flowShellKeepTempFiles", Boolean.class).defaultValue((Object)Boolean.FALSE).description("Do not delete temporary files created by the shell command execution").build();
        FLOW_FILE_DTO = commandBuilder.argument("flowFileDTO", FlowFile.class).description("An already loaded FlowFile object").hidden().build();
    }
}

