/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.config.DriftConfiguration;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import java.util.Arrays;
import java.util.List;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.command.core.helpers.ReferenceDbUrlConnectionCommandStep;
import liquibase.diff.DiffResult;
import liquibase.license.LicenseServiceUtils;

public class ProDriftDetectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"driftDetect"};
    public static final String DRIFT_EXIT_CODE = "driftExitCode";
    public static final String DRIFT_EXIT_MESSAGE_TEMPLATE = "ERROR: Liquibase detected drift of %d missing, %d changed, and %d unexpected objects between target '%s' and reference '%s'.%nFor additional details, inspect the output, set --format=JSON, or learn more at https://docs.liquibase.com/drift-reports.%nDiff command exited with error code %d";

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(DiffResult.class, FormattedDiffModel.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.getShortDescription();
        if (commandDefinition.getPipeline().size() == 1) {
            commandDefinition.setInternal(true);
        }
        if (Arrays.equals(commandDefinition.getName(), COMMAND_NAME)) {
            commandDefinition.setHidden(true);
        }
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int n2 = super.getOrder(commandDefinition);
        if (n2 < 0 && !commandDefinition.getName()[0].equals(DiffCommandStep.COMMAND_NAME[0])) {
            return n2;
        }
        return 1110;
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        if (!((Boolean)DriftConfiguration.ENABLED.getCurrentValue()).booleanValue()) {
            return;
        }
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])DiffCommandStep.COMMAND_NAME);
        DiffResult diffResult = (DiffResult)commandResultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!diffResult.getMissingObjects().isEmpty()) {
            n2 = DriftConfiguration.determineSeverity((Integer)DriftConfiguration.MISSING_SEVERITY.getCurrentValue());
        }
        if (!diffResult.getUnexpectedObjects().isEmpty()) {
            n3 = DriftConfiguration.determineSeverity((Integer)DriftConfiguration.UNEXPECTED_SEVERITY.getCurrentValue());
        }
        if (!diffResult.getChangedObjects().isEmpty()) {
            n4 = DriftConfiguration.determineSeverity((Integer)DriftConfiguration.CHANGED_SEVERITY.getCurrentValue());
        }
        if (n2 != 0 || n3 != 0 || n4 != 0) {
            n2 = Math.max(n2, Math.max(n3, n4));
            commandResultsBuilder.addResult(DRIFT_EXIT_CODE, (Object)n2);
            Object object = commandResultsBuilder.getCommandScope();
            String string = (String)object.getArgumentValue(DbUrlConnectionCommandStep.URL_ARG);
            object = (String)object.getArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_URL_ARG);
            throw commandResultsBuilder.commandFailed(String.format(DRIFT_EXIT_MESSAGE_TEMPLATE, diffResult.getMissingObjects().size(), diffResult.getChangedObjects().size(), diffResult.getUnexpectedObjects().size(), string, object, n2), n2, true);
        }
        commandResultsBuilder.addResult(DRIFT_EXIT_CODE, (Object)0);
    }

    static {
        new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
    }
}

