/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import java.util.Date;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.TagCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockServiceFactory;

@CommandOverride(override=TagCommandStep.class)
public class ProTagCommandStep
extends TagCommandStep {
    public static final CommandArgumentDefinition<Boolean> ADDROW_ARG = new CommandBuilder((String[][])new String[][]{COMMAND_NAME}).argument("addRow", Boolean.class).description(ProStringUtil.markWithPro("Add entry to Database Changelog table")).defaultValue((Object)Boolean.FALSE).setValueHandler(object -> {
        if (object == null) {
            return null;
        }
        if (object instanceof String && !object.equals("")) {
            if (!Arrays.asList("TRUE", "FALSE").contains(((String)object).toUpperCase())) {
                throw new IllegalArgumentException("Illegal value for `addRow'.  Valid values are 'TRUE' or 'FALSE'");
            }
            return Boolean.parseBoolean((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }).build();

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void validate(CommandScope commandScope) {
        if (((Boolean)commandScope.getArgumentValue(ADDROW_ARG)).booleanValue()) {
            try {
                LicenseServiceUtils.checkProLicenseAndThrowException((String[])TagCommandStep.COMMAND_NAME);
                return;
            }
            catch (CommandValidationException commandValidationException) {
                String string = "ERROR: No valid Pro license found to enable the '<--addrow=true | LIQUIBASE_COMMAND_TAG_ADDROW=TRUE | etc>' property for the 'tag' command. Get a free trial license key at https://liquibase.com/trial and include liquibase.licenseKey in defaults file, or add via CLI or Environment variable. Learn more at https://docs.liquibase.com";
                throw new CommandValidationException(string, (Throwable)commandValidationException);
            }
        }
    }

    public void run(CommandResultsBuilder object) {
        Object object2 = object.getCommandScope();
        if (!((Boolean)object2.getArgumentValue(ADDROW_ARG)).booleanValue()) {
            super.run(object);
            return;
        }
        object = (Database)object2.getDependency(Database.class);
        Object object3 = ((ChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class)).getChangeLogService((Database)object);
        object3.generateDeploymentId();
        object3.init();
        this.setupExecutionServices((Database)object);
        object2 = (String)object2.getArgumentValue(TagCommandStep.TAG_ARG);
        object3 = Long.toString(new Date().getTime());
        object3 = new ChangeSet("liquibasetagcommand-".concat(String.valueOf(object3)), "liquibasetagcommand", false, false, "liquibasetagcommand", null, null, null);
        TagDatabaseChange tagDatabaseChange = new TagDatabaseChange();
        tagDatabaseChange.setTag((String)object2);
        object3.addChange((Change)tagDatabaseChange);
        object.markChangeSetExecStatus((ChangeSet)object3, ChangeSet.ExecType.EXECUTED);
        object = "Successfully added tag entry to the Database Changelog table";
        Scope.getCurrentScope().getLog(ProTagCommandStep.class).info((String)object);
    }

    private void setupExecutionServices(Database database) {
        LockServiceFactory.getInstance().getLockService(database).waitForLock();
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).init();
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int n2 = super.getOrder(commandDefinition);
        if (n2 < 0 && !commandDefinition.getName()[0].equals(TagCommandStep.COMMAND_NAME[0])) {
            return n2;
        }
        return 1100;
    }
}

