/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.UpdateOneChangeSetCommandStep;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import java.util.ArrayList;
import java.util.List;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.MigrationFailedException;

@CommandOverride(override=UpdateOneChangeSetCommandStep.class)
public class ProUpdateOneChangesetCommandStep
extends UpdateOneChangeSetCommandStep {
    @Override
    public String[][] defineCommandNames() {
        return new String[][]{UpdateOneChangeSetCommandStep.COMMAND_NAME};
    }

    @Override
    public List<Class<?>> requiredDependencies() {
        ArrayList arrayList = new ArrayList(super.requiredDependencies());
        arrayList.add(RollbackOnErrorArgument.class);
        return arrayList;
    }

    @Override
    public void run(CommandResultsBuilder commandResultsBuilder) {
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Boolean bl2 = (Boolean)commandScope.getDependency(RollbackOnErrorArgument.class);
        try {
            super.run(commandResultsBuilder);
            return;
        }
        catch (Exception exception) {
            Throwable throwable = this.findExceptionInCauseChain(exception, MigrationFailedException.class);
            if (throwable != null) {
                CommandScope commandScope2 = new CommandScope(new String[]{"internalRollbackOnError"});
                commandScope2.addArgumentValue("database", commandScope.getDependency(Database.class));
                commandScope2.addArgumentValue("exception", (Object)throwable);
                commandScope2.addArgumentValue("listener", commandResultsBuilder.getResult("defaultChangeExecListener"));
                commandScope2.addArgumentValue(RollbackOnErrorArgument.ROLLBACK_ON_ERROR_ARG, (Object)bl2);
                commandScope2.addArgumentValue("updateReportParameters.", commandResultsBuilder.getResult("updateReport"));
                commandScope2.execute();
                return;
            }
            throw exception;
        }
    }

    private Throwable findExceptionInCauseChain(Throwable throwable, Class<? extends Throwable> clazz) {
        while (throwable != null && throwable.getCause() != null) {
            if (clazz.isAssignableFrom(throwable.getCause().getClass())) {
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }
}

