/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.pro.packaged.qd;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;

public abstract class AbstractReport {
    private final String name;
    private final String path;

    protected AbstractReport(String string, String string2) {
        this.name = string;
        this.path = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void generateReport() {
        try {
            AbstractReport abstractReport = this;
            abstractReport.writeFileContents(abstractReport.getReportString());
            return;
        }
        catch (Exception exception) {
            throw new LiquibaseException("Could not generate report!", (Throwable)exception);
        }
    }

    public void writeFileContents(String object) {
        String string = this.getFullPath();
        Resource resource = ResourceUtil.getResource(string);
        Throwable throwable = null;
        try (Object object2 = this.createResourceIfNeeded(string);){
            ((OutputStream)object2).write(((String)object).getBytes((String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throwable = throwable2;
            throw object;
        }
        object2 = !resource.exists() ? String.format("Report file '%s' was created", string) : String.format("Report file '%s' was updated", string);
        Scope.getCurrentScope().getLog(this.getClass()).info((String)object2);
        Scope.getCurrentScope().getUI().sendMessage((String)object2);
    }

    private OutputStream createResourceIfNeeded(String string) {
        return ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).openResourceOutputStream(string, new OpenOptions().setTruncate(true).setCreateIfNeeded(true));
    }

    public String getFullPath() {
        String string = this.getPath();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.toLowerCase().endsWith(".html")) {
            return string;
        }
        string = this.getName().toLowerCase().endsWith(".html") ? String.format("%s/%s", string, this.getName()) : String.format("%s/%s.%s", string, this.getName(), "html");
        return string;
    }

    public String getReportString() {
        Object object = new HashSet<String>();
        object.add(this.getTemplateName());
        object = new qd((Set<String>)object, this.getTemplateResourceRoot()).b(this.getTemplateName());
        StringWriter stringWriter = new StringWriter();
        object.a((Writer)stringWriter, this.getReportParameters()).flush();
        if (stringWriter.toString() != null) {
            return stringWriter.toString();
        }
        return null;
    }

    protected abstract Object getReportParameters();

    protected abstract String getTemplateName();

    protected abstract String getTemplateResourceRoot();

    public abstract String getReportTypeName();
}

