/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.change.EnableCheckConstraintStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableCheckConstraintGenerator
extends AbstractSqlGenerator<EnableCheckConstraintStatement> {
    public boolean supports(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database) && !(database instanceof Db2zDatabase);
    }

    public ValidationErrors validate(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        database = new ValidationErrors();
        database.checkRequiredField("tableName", (Object)enableCheckConstraintStatement.getTableName());
        database.checkRequiredField("constraintName", (Object)enableCheckConstraintStatement.getConstraintName());
        return database;
    }

    public Sql[] generateSql(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database, SqlGeneratorChain object) {
        object = new StringBuilder();
        ((StringBuilder)object).append("ALTER TABLE ");
        String string = database.escapeTableName(enableCheckConstraintStatement.getCatalogName(), enableCheckConstraintStatement.getSchemaName(), enableCheckConstraintStatement.getTableName());
        ((StringBuilder)object).append(string);
        if (database instanceof OracleDatabase) {
            ((StringBuilder)object).append(" ENABLE CONSTRAINT ").append(enableCheckConstraintStatement.getConstraintName());
        } else if (database instanceof AbstractDb2Database) {
            ((StringBuilder)object).append(" ALTER CHECK ").append(enableCheckConstraintStatement.getConstraintName()).append(" ENFORCED");
        } else {
            ((StringBuilder)object).append(" WITH CHECK CHECK CONSTRAINT ").append(enableCheckConstraintStatement.getConstraintName());
        }
        return new Sql[]{new UnparsedSql(((StringBuilder)object).toString(), new DatabaseObject[0])};
    }
}

