/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageStatement;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class DropPackageGenerator
extends AbstractSqlGenerator<DropPackageStatement> {
    public boolean supports(DropPackageStatement dropPackageStatement, Database database) {
        return database instanceof DB2Database || database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase;
    }

    public ValidationErrors validate(DropPackageStatement dropPackageStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        database = new ValidationErrors();
        database.checkRequiredField("packageName", (Object)dropPackageStatement.getPackageName());
        return database;
    }

    public Sql[] generateSql(DropPackageStatement dropPackageStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql("DROP PACKAGE " + database.escapeObjectName(dropPackageStatement.getCatalogName(), dropPackageStatement.getSchemaName(), dropPackageStatement.getPackageName(), DatabasePackage.class), new DatabaseObject[]{((DatabasePackage)new DatabasePackage().setName(dropPackageStatement.getPackageName())).setSchema(new Schema(dropPackageStatement.getCatalogName(), dropPackageStatement.getSchemaName()))})};
    }
}

