/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.MissingFunctionChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingFunctionExternalFileChangeGenerator
extends MissingFunctionChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && Function.class.isAssignableFrom(clazz)) {
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl changeArray, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        changeArray = super.fixMissing(databaseObject, (DiffOutputControl)changeArray, (Database)object, database, changeGeneratorChain);
        object = MissingFunctionExternalFileChangeGenerator.findChange(CreateFunctionChange.class, changeArray);
        object.setRelativeToChangelogFile(Boolean.TRUE);
        object.setPath(ObjectSqlFileUtil.writeObjectSql((Function)databaseObject));
        ((CreateFunctionChange)((Object)object)).setFunctionBody(null);
        return changeArray;
    }
}

