/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractChangedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class ChangedStoredProcedureChangeGenerator
extends AbstractChangedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (StoredProcedure.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        if (objectDifferences.isDifferent("body")) {
            objectDifferences = new CreateProcedureChange();
            objectDifferences.setProcedureText(this.convertToReplace(((StoredDatabaseLogic)databaseObject).getBody(), database2));
            objectDifferences.setProcedureName(databaseObject.getName());
            if (diffOutputControl.getIncludeCatalog()) {
                objectDifferences.setCatalogName(databaseObject.getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                objectDifferences.setSchemaName(databaseObject.getSchema().getName());
            }
            if (database instanceof MSSQLDatabase) {
                objectDifferences.setReplaceIfExists(Boolean.TRUE);
            }
            return AbstractMissingStoredLogicChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{objectDifferences});
        }
        return null;
    }
}

