/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.ArrayList;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColDataType;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class CastExpression
extends ASTNodeAccessImpl
implements Expression {
    public String keyword;
    private Expression leftExpression;
    private ColDataType colDataType = null;
    private ArrayList<ColumnDefinition> columnDefinitions = new ArrayList();
    private boolean useCastKeyword = true;

    public CastExpression(String string) {
        this.keyword = string;
    }

    public CastExpression() {
        this("CAST");
    }

    public ColDataType getColDataType() {
        return this.colDataType;
    }

    public ArrayList<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColDataType(ColDataType colDataType) {
        this.colDataType = colDataType;
    }

    public void addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnDefinitions.add(columnDefinition);
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public boolean isUseCastKeyword() {
        return this.useCastKeyword;
    }

    public void setUseCastKeyword(boolean bl2) {
        this.useCastKeyword = bl2;
    }

    public String toString() {
        if (this.useCastKeyword) {
            if (this.columnDefinitions.size() > 1) {
                return this.keyword + "(" + this.leftExpression + " AS ROW(" + Select.getStringList(this.columnDefinitions) + "))";
            }
            return this.keyword + "(" + this.leftExpression + " AS " + this.colDataType.toString() + ")";
        }
        return this.leftExpression + "::" + this.colDataType.toString();
    }

    public CastExpression withType(ColDataType colDataType) {
        this.setColDataType(colDataType);
        return this;
    }

    public CastExpression withUseCastKeyword(boolean bl2) {
        this.setUseCastKeyword(bl2);
        return this;
    }

    public CastExpression withLeftExpression(Expression expression) {
        this.setLeftExpression(expression);
        return this;
    }

    public <E extends Expression> E getLeftExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getLeftExpression()));
    }
}

