/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.alter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import liquibase.repackaged.net.sf.jsqlparser.statement.ReferentialAction;
import liquibase.repackaged.net.sf.jsqlparser.statement.ReferentialAction$Action;
import liquibase.repackaged.net.sf.jsqlparser.statement.ReferentialAction$Type;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression$ColumnDataType;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression$ColumnDropDefault;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression$ColumnDropNotNull;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterOperation;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.ConstraintState;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColDataType;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class AlterExpression
implements Serializable {
    private AlterOperation operation;
    private String optionalSpecifier;
    private String newTableName;
    private String columnName;
    private String columnOldName;
    private List<AlterExpression$ColumnDataType> colDataTypeList;
    private List<AlterExpression$ColumnDropNotNull> columnDropNotNullList;
    private List<AlterExpression$ColumnDropDefault> columnDropDefaultList;
    private List<String> pkColumns;
    private List<String> ukColumns;
    private String ukName;
    private Index index = null;
    private String constraintName;
    private boolean usingIfExists;
    private Set<ReferentialAction> referentialActions = new LinkedHashSet<ReferentialAction>(2);
    private List<String> fkColumns;
    private String fkSourceSchema;
    private String fkSourceTable;
    private List<String> fkSourceColumns;
    private boolean uk;
    private boolean useEqual;
    private List<ConstraintState> constraints;
    private List<String> parameters;
    private String commentText;
    private boolean hasColumn = false;
    private boolean useBrackets = false;

    public boolean hasColumn() {
        return this.hasColumn;
    }

    public boolean useBrackets() {
        return this.useBrackets;
    }

    public void useBrackets(boolean bl2) {
        this.useBrackets = bl2;
    }

    public void hasColumn(boolean bl2) {
        this.hasColumn = bl2;
    }

    public String getFkSourceSchema() {
        return this.fkSourceSchema;
    }

    public void setFkSourceSchema(String string) {
        this.fkSourceSchema = string;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String string) {
        this.commentText = string;
    }

    public AlterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterOperation alterOperation) {
        this.operation = alterOperation;
    }

    public String getOptionalSpecifier() {
        return this.optionalSpecifier;
    }

    public void setOptionalSpecifier(String string) {
        this.optionalSpecifier = string;
    }

    public void setReferentialAction(ReferentialAction$Type referentialAction$Type, ReferentialAction$Action action) {
        this.setReferentialAction(referentialAction$Type, action, true);
    }

    public AlterExpression withReferentialAction(ReferentialAction$Type referentialAction$Type, ReferentialAction$Action action) {
        this.setReferentialAction(referentialAction$Type, action);
        return this;
    }

    public void removeReferentialAction(ReferentialAction$Type referentialAction$Type) {
        this.setReferentialAction(referentialAction$Type, null, false);
    }

    public ReferentialAction getReferentialAction(ReferentialAction$Type referentialAction$Type) {
        return this.referentialActions.stream().filter(referentialAction -> referentialAction$Type.equals((Object)referentialAction.getType())).findFirst().orElse(null);
    }

    private void setReferentialAction(ReferentialAction$Type referentialAction$Type, ReferentialAction$Action action, boolean bl2) {
        ReferentialAction referentialAction = this.getReferentialAction(referentialAction$Type);
        if (bl2) {
            if (referentialAction == null) {
                this.referentialActions.add(new ReferentialAction(referentialAction$Type, action));
                return;
            }
            referentialAction.setAction(action);
            return;
        }
        if (referentialAction != null) {
            this.referentialActions.remove(referentialAction);
        }
    }

    @Deprecated
    public boolean isOnDeleteCascade() {
        ReferentialAction referentialAction = this.getReferentialAction(ReferentialAction$Type.DELETE);
        return referentialAction != null && ReferentialAction$Action.CASCADE.equals((Object)referentialAction.getAction());
    }

    @Deprecated
    public void setOnDeleteCascade(boolean bl2) {
        this.setReferentialAction(ReferentialAction$Type.DELETE, ReferentialAction$Action.CASCADE, bl2);
    }

    @Deprecated
    public boolean isOnDeleteRestrict() {
        ReferentialAction referentialAction = this.getReferentialAction(ReferentialAction$Type.DELETE);
        return referentialAction != null && ReferentialAction$Action.RESTRICT.equals((Object)referentialAction.getAction());
    }

    @Deprecated
    public void setOnDeleteRestrict(boolean bl2) {
        this.setReferentialAction(ReferentialAction$Type.DELETE, ReferentialAction$Action.RESTRICT, bl2);
    }

    @Deprecated
    public boolean isOnDeleteSetNull() {
        ReferentialAction referentialAction = this.getReferentialAction(ReferentialAction$Type.DELETE);
        return referentialAction != null && ReferentialAction$Action.SET_NULL.equals((Object)referentialAction.getAction());
    }

    @Deprecated
    public void setOnDeleteSetNull(boolean bl2) {
        this.setReferentialAction(ReferentialAction$Type.DELETE, ReferentialAction$Action.SET_NULL, bl2);
    }

    public List<String> getFkColumns() {
        return this.fkColumns;
    }

    public void setFkColumns(List<String> list) {
        this.fkColumns = list;
    }

    public String getFkSourceTable() {
        return this.fkSourceTable;
    }

    public void setFkSourceTable(String string) {
        this.fkSourceTable = string;
    }

    public List<AlterExpression$ColumnDataType> getColDataTypeList() {
        return this.colDataTypeList;
    }

    public void addColDataType(String string, ColDataType colDataType) {
        this.addColDataType(new AlterExpression$ColumnDataType(string, false, colDataType, null));
    }

    public void addColDataType(AlterExpression$ColumnDataType alterExpression$ColumnDataType) {
        if (this.colDataTypeList == null) {
            this.colDataTypeList = new ArrayList<AlterExpression$ColumnDataType>();
        }
        this.colDataTypeList.add(alterExpression$ColumnDataType);
    }

    public void addColDropNotNull(AlterExpression$ColumnDropNotNull alterExpression$ColumnDropNotNull) {
        if (this.columnDropNotNullList == null) {
            this.columnDropNotNullList = new ArrayList<AlterExpression$ColumnDropNotNull>();
        }
        this.columnDropNotNullList.add(alterExpression$ColumnDropNotNull);
    }

    public void addColDropDefault(AlterExpression$ColumnDropDefault columnDropDefault) {
        if (this.columnDropDefaultList == null) {
            this.columnDropDefaultList = new ArrayList<AlterExpression$ColumnDropDefault>();
        }
        this.columnDropDefaultList.add(columnDropDefault);
    }

    public List<String> getFkSourceColumns() {
        return this.fkSourceColumns;
    }

    public void setFkSourceColumns(List<String> list) {
        this.fkSourceColumns = list;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String string) {
        this.newTableName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    @Deprecated
    public String getColOldName() {
        return this.getColumnOldName();
    }

    @Deprecated
    public void setColOldName(String string) {
        this.setColumnOldName(string);
    }

    public String getColumnOldName() {
        return this.columnOldName;
    }

    public void setColumnOldName(String string) {
        this.columnOldName = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public boolean isUsingIfExists() {
        return this.usingIfExists;
    }

    public void setUsingIfExists(boolean bl2) {
        this.usingIfExists = bl2;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(List<String> list) {
        this.pkColumns = list;
    }

    public List<String> getUkColumns() {
        return this.ukColumns;
    }

    public void setUkColumns(List<String> list) {
        this.ukColumns = list;
    }

    public String getUkName() {
        return this.ukName;
    }

    public void setUkName(String string) {
        this.ukName = string;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public List<ConstraintState> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<ConstraintState> list) {
        this.constraints = list;
    }

    public List<AlterExpression$ColumnDropNotNull> getColumnDropNotNullList() {
        return this.columnDropNotNullList;
    }

    public void addParameters(String ... stringArray) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.addAll(Arrays.asList(stringArray));
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean getUseEqual() {
        return this.useEqual;
    }

    public void setUseEqual(boolean bl2) {
        this.useEqual = bl2;
    }

    public boolean getUk() {
        return this.uk;
    }

    public void setUk(boolean bl2) {
        this.uk = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.operation == AlterOperation.UNSPECIFIC) {
            stringBuilder.append(this.optionalSpecifier);
        } else if (this.operation == AlterOperation.RENAME_TABLE) {
            stringBuilder.append("RENAME TO ").append(this.newTableName);
        } else if (this.operation == AlterOperation.DROP_PRIMARY_KEY) {
            stringBuilder.append("DROP PRIMARY KEY ");
        } else if (this.operation == AlterOperation.DROP_UNIQUE) {
            stringBuilder.append("DROP UNIQUE (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else if (this.operation == AlterOperation.DROP_FOREIGN_KEY) {
            stringBuilder.append("DROP FOREIGN KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else if (this.operation == AlterOperation.DROP && this.columnName == null && this.pkColumns != null && this.pkColumns.size() > 0) {
            stringBuilder.append("DROP (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else {
            stringBuilder.append((Object)this.operation).append(" ");
            if (this.commentText != null) {
                if (this.columnName != null) {
                    stringBuilder.append(this.columnName).append(" COMMENT ");
                }
                stringBuilder.append(this.commentText);
            } else if (this.columnName != null) {
                if (this.hasColumn) {
                    stringBuilder.append("COLUMN ");
                }
                if (this.usingIfExists) {
                    stringBuilder.append("IF EXISTS ");
                }
                if (this.operation == AlterOperation.RENAME) {
                    stringBuilder.append(this.columnOldName).append(" TO ");
                }
                stringBuilder.append(this.columnName);
            } else if (this.getColDataTypeList() != null) {
                if (this.operation == AlterOperation.CHANGE) {
                    if (this.optionalSpecifier != null) {
                        stringBuilder.append(this.optionalSpecifier).append(" ");
                    }
                    stringBuilder.append(this.columnOldName).append(" ");
                } else if (this.colDataTypeList.size() > 1) {
                    stringBuilder.append("(");
                } else if (this.hasColumn) {
                    stringBuilder.append("COLUMN ");
                }
                if (this.useBrackets && this.colDataTypeList.size() == 1) {
                    stringBuilder.append(" ( ");
                }
                stringBuilder.append(PlainSelect.getStringList(this.colDataTypeList));
                if (this.useBrackets && this.colDataTypeList.size() == 1) {
                    stringBuilder.append(" ) ");
                }
                if (this.colDataTypeList.size() > 1) {
                    stringBuilder.append(")");
                }
            } else if (this.getColumnDropNotNullList() != null) {
                stringBuilder.append("COLUMN ");
                stringBuilder.append(PlainSelect.getStringList(this.columnDropNotNullList));
            } else if (this.columnDropDefaultList != null && !this.columnDropDefaultList.isEmpty()) {
                stringBuilder.append("COLUMN ");
                stringBuilder.append(PlainSelect.getStringList(this.columnDropDefaultList));
            } else if (this.constraintName != null) {
                stringBuilder.append("CONSTRAINT ");
                if (this.usingIfExists) {
                    stringBuilder.append("IF EXISTS ");
                }
                stringBuilder.append(this.constraintName);
            } else if (this.pkColumns != null) {
                stringBuilder.append("PRIMARY KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
            } else if (this.ukColumns != null) {
                stringBuilder.append("UNIQUE");
                if (this.ukName != null) {
                    if (this.getUk()) {
                        stringBuilder.append(" KEY ");
                    } else {
                        stringBuilder.append(" INDEX ");
                    }
                    stringBuilder.append(this.ukName);
                }
                stringBuilder.append(" (").append(PlainSelect.getStringList(this.ukColumns)).append(")");
            } else if (this.fkColumns != null) {
                stringBuilder.append("FOREIGN KEY (").append(PlainSelect.getStringList(this.fkColumns)).append(") REFERENCES ").append(this.fkSourceSchema != null && this.fkSourceSchema.trim().length() > 0 ? this.fkSourceSchema + "." : "").append(this.fkSourceTable).append(" (").append(PlainSelect.getStringList(this.fkSourceColumns)).append(")");
                this.referentialActions.forEach(stringBuilder::append);
            } else if (this.index != null) {
                stringBuilder.append(this.index);
            }
            if (this.getConstraints() != null && !this.getConstraints().isEmpty()) {
                stringBuilder.append(' ').append(PlainSelect.getStringList(this.constraints, false, false));
            }
            if (this.getUseEqual()) {
                stringBuilder.append('=');
            }
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            stringBuilder.append(' ').append(PlainSelect.getStringList(this.parameters, false, false));
        }
        return stringBuilder.toString();
    }

    public AlterExpression withOperation(AlterOperation alterOperation) {
        this.setOperation(alterOperation);
        return this;
    }

    public AlterExpression withOptionalSpecifier(String string) {
        this.setOptionalSpecifier(string);
        return this;
    }

    public AlterExpression withColumnName(String string) {
        this.setColumnName(string);
        return this;
    }

    public AlterExpression withPkColumns(List<String> list) {
        this.setPkColumns(list);
        return this;
    }

    public AlterExpression withUkColumns(List<String> list) {
        this.setUkColumns(list);
        return this;
    }

    public AlterExpression withUkName(String string) {
        this.setUkName(string);
        return this;
    }

    public AlterExpression withIndex(Index index) {
        this.setIndex(index);
        return this;
    }

    public AlterExpression withConstraintName(String string) {
        this.setConstraintName(string);
        return this;
    }

    public AlterExpression withUsingIfExists(boolean bl2) {
        this.setUsingIfExists(bl2);
        return this;
    }

    public AlterExpression withOnDeleteRestrict(boolean bl2) {
        this.setOnDeleteRestrict(bl2);
        return this;
    }

    public AlterExpression withOnDeleteSetNull(boolean bl2) {
        this.setOnDeleteSetNull(bl2);
        return this;
    }

    public AlterExpression withOnDeleteCascade(boolean bl2) {
        this.setOnDeleteCascade(bl2);
        return this;
    }

    public AlterExpression withFkColumns(List<String> list) {
        this.setFkColumns(list);
        return this;
    }

    public AlterExpression withFkSourceSchema(String string) {
        this.setFkSourceTable(string);
        return this;
    }

    public AlterExpression withFkSourceTable(String string) {
        this.setFkSourceTable(string);
        return this;
    }

    public AlterExpression withFkSourceColumns(List<String> list) {
        this.setFkSourceColumns(list);
        return this;
    }

    public AlterExpression withUk(boolean bl2) {
        this.setUk(bl2);
        return this;
    }

    public AlterExpression withUseEqual(boolean bl2) {
        this.setUseEqual(bl2);
        return this;
    }

    public AlterExpression withConstraints(List<ConstraintState> list) {
        this.setConstraints(list);
        return this;
    }

    public AlterExpression withCommentText(String string) {
        this.setCommentText(string);
        return this;
    }

    public AlterExpression withColumnOldName(String string) {
        this.setColumnOldName(string);
        return this;
    }

    public AlterExpression addPkColumns(String ... stringArray) {
        List list = Optional.ofNullable(this.getPkColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withPkColumns(list);
    }

    public AlterExpression addPkColumns(Collection<String> collection) {
        List list = Optional.ofNullable(this.getPkColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withPkColumns(list);
    }

    public AlterExpression addUkColumns(String ... stringArray) {
        List list = Optional.ofNullable(this.getUkColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withUkColumns(list);
    }

    public AlterExpression addUkColumns(Collection<String> collection) {
        List list = Optional.ofNullable(this.getUkColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withUkColumns(list);
    }

    public AlterExpression addFkColumns(String ... stringArray) {
        List list = Optional.ofNullable(this.getFkColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withFkColumns(list);
    }

    public AlterExpression addFkColumns(Collection<String> collection) {
        List list = Optional.ofNullable(this.getFkColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withFkColumns(list);
    }

    public AlterExpression addFkSourceColumns(String ... stringArray) {
        List list = Optional.ofNullable(this.getFkSourceColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withFkSourceColumns(list);
    }

    public AlterExpression addFkSourceColumns(Collection<String> collection) {
        List list = Optional.ofNullable(this.getFkSourceColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withFkSourceColumns(list);
    }

    public AlterExpression addConstraints(ConstraintState ... constraintStateArray) {
        List list = Optional.ofNullable(this.getConstraints()).orElseGet(ArrayList::new);
        Collections.addAll(list, constraintStateArray);
        return this.withConstraints(list);
    }

    public AlterExpression addConstraints(Collection<? extends ConstraintState> collection) {
        List list = Optional.ofNullable(this.getConstraints()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withConstraints(list);
    }
}

