/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.merge;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;

public class MergeInsert
implements Serializable {
    private ExpressionList<Column> columns;
    private ExpressionList<Expression> values;
    private Expression whereCondition;

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> expressionList) {
        this.columns = expressionList;
    }

    public ExpressionList<Expression> getValues() {
        return this.values;
    }

    public void setValues(ExpressionList<Expression> expressionList) {
        this.values = expressionList;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression expression) {
        this.whereCondition = expression;
    }

    public String toString() {
        return " WHEN NOT MATCHED THEN INSERT " + (this.columns != null ? this.columns.toString() : "") + " VALUES " + this.values.toString() + (this.whereCondition != null ? " WHERE " + this.whereCondition : "");
    }

    public MergeInsert withColumns(ExpressionList<Column> expressionList) {
        this.setColumns(expressionList);
        return this;
    }

    public MergeInsert withValues(ExpressionList<Expression> expressionList) {
        this.setValues(expressionList);
        return this;
    }

    public MergeInsert addColumns(Column ... columnArray) {
        return this.addColumns(Arrays.asList(columnArray));
    }

    public MergeInsert addColumns(Collection<? extends Column> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        expressionList.addAll(collection);
        return this.withColumns(expressionList);
    }

    public MergeInsert addValues(Expression ... expressionArray) {
        return this.addValues(Arrays.asList(expressionArray));
    }

    public MergeInsert addValues(Collection<? extends Expression> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getValues()).orElseGet(() -> new ExpressionList(new Expression[0]));
        expressionList.addAll(collection);
        return this.withValues(expressionList);
    }

    public MergeInsert withWhereCondition(Expression expression) {
        this.setWhereCondition(expression);
        return this;
    }

    public <E extends Expression> E getWhereCondition(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhereCondition()));
    }
}

