/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.GroupByVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class GroupByElement
implements Serializable {
    private ExpressionList groupByExpressions = new ExpressionList(new Expression[0]);
    private List<ExpressionList> groupingSets = new ArrayList<ExpressionList>();

    public boolean isUsingBrackets() {
        return this.groupByExpressions.isUsingBrackets();
    }

    public void accept(GroupByVisitor groupByVisitor) {
        groupByVisitor.visit(this);
    }

    public ExpressionList getGroupByExpressionList() {
        return this.groupByExpressions;
    }

    public void setGroupByExpressions(ExpressionList expressionList) {
        this.groupByExpressions = expressionList;
    }

    @Deprecated
    public ExpressionList getGroupByExpressions() {
        return this.groupByExpressions;
    }

    @Deprecated
    public void addGroupByExpression(Expression expression) {
        if (this.groupByExpressions.getExpressions() == null) {
            this.groupByExpressions.setExpressions(new ArrayList());
        }
        this.groupByExpressions.getExpressions().add(expression);
    }

    public List<ExpressionList> getGroupingSets() {
        return this.groupingSets;
    }

    public void setGroupingSets(List<ExpressionList> list) {
        this.groupingSets = list;
    }

    public void addGroupingSet(ExpressionList expressionList) {
        this.groupingSets.add(expressionList);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GROUP BY ");
        if (this.groupByExpressions != null) {
            stringBuilder.append(this.groupByExpressions.toString());
        }
        int n2 = 0;
        if (this.groupingSets.size() > 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2.charAt(stringBuilder2.length() - 1) != ' ') {
                stringBuilder.append(' ');
            }
            stringBuilder.append("GROUPING SETS (");
            for (ExpressionList expressionList : this.groupingSets) {
                stringBuilder.append(n2++ > 0 ? ", " : "").append(Select.getStringList(expressionList, true, expressionList instanceof ParenthesedExpressionList));
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public GroupByElement withGroupByExpressions(ExpressionList expressionList) {
        this.setGroupByExpressions(expressionList);
        return this;
    }

    public GroupByElement withGroupingSets(List list) {
        this.setGroupingSets(list);
        return this;
    }

    public GroupByElement addGroupByExpressions(Expression ... expressionArray) {
        return this.addGroupByExpressions(Arrays.asList(expressionArray));
    }

    public GroupByElement addGroupByExpressions(Collection<? extends Expression> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getGroupByExpressions()).orElseGet(() -> new ExpressionList(new Expression[0]));
        Collections.addAll(expressionList, collection);
        return this.withGroupByExpressions(expressionList);
    }

    public GroupByElement addGroupingSets(Object ... objectArray) {
        List list = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        Collections.addAll(list, objectArray);
        return this.withGroupingSets(list);
    }

    public GroupByElement addGroupingSets(Collection<? extends Object> collection) {
        List list = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withGroupingSets(list);
    }
}

