/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;

public class ParenthesedFromItem
implements FromItem {
    private FromItem fromItem;
    private List<Join> joins;
    private Alias alias;
    private Pivot pivot;
    private UnPivot unPivot;

    public ParenthesedFromItem() {
    }

    public ParenthesedFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public final void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public Join getJoin(int n2) {
        return this.joins.get(n2);
    }

    public FromItem addJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withJoins(list);
    }

    public FromItem withJoins(List<Join> list) {
        this.setJoins(list);
        return this;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        stringBuilder.append(this.fromItem);
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    stringBuilder.append(", ").append(join);
                    continue;
                }
                stringBuilder.append(" ").append(join);
            }
        }
        stringBuilder.append(")");
        if (this.alias != null) {
            stringBuilder.append(this.alias);
        }
        if (this.pivot != null) {
            stringBuilder.append(this.pivot);
        }
        if (this.unPivot != null) {
            stringBuilder.append(this.unPivot);
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unPivot;
    }

    @Override
    public void setUnPivot(UnPivot unPivot) {
        this.unPivot = unPivot;
    }

    public ParenthesedFromItem withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    @Override
    public ParenthesedFromItem withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public <E extends FromItem> E getFromItem(Class<E> clazz) {
        return (E)((FromItem)clazz.cast(this.getFromItem()));
    }
}

