/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperation;

public class SetOperationList
extends Select {
    private List<Select> selects;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    @Override
    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<Select> getSelects() {
        return this.selects;
    }

    public Select getSelect(int n2) {
        return this.selects.get(n2);
    }

    public void setSelects(List<Select> list) {
        this.selects = list;
    }

    public void setOperations(List<SetOperation> list) {
        this.operations = list;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public SetOperation getOperation(int n2) {
        return this.operations.get(n2);
    }

    @Override
    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public void setBracketsOpsAndSelects(List<Select> list, List<SetOperation> list2) {
        this.selects = list;
        this.operations = list2;
    }

    @Override
    public StringBuilder appendSelectBodyTo(StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < this.selects.size(); ++i2) {
            if (i2 != 0) {
                stringBuilder.append(" ").append(this.operations.get(i2 - 1).toString()).append(" ");
            }
            stringBuilder.append(this.selects.get(i2).toString());
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        return stringBuilder;
    }

    public SetOperationList withOperations(List<SetOperation> list) {
        this.setOperations(list);
        return this;
    }

    public SetOperationList withSelects(List<Select> list) {
        this.setSelects(list);
        return this;
    }

    public SetOperationList addSelects(Select ... selectArray) {
        List list = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectArray);
        return this.withSelects(list);
    }

    public SetOperationList addSelects(Collection<? extends Select> collection) {
        List list = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSelects(list);
    }

    public SetOperationList addOperations(SetOperation ... setOperationArray) {
        List list = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        Collections.addAll(list, setOperationArray);
        return this.withOperations(list);
    }

    public SetOperationList addOperations(Collection<? extends SetOperation> collection) {
        List list = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOperations(list);
    }
}

