/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.OutputClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.ReturningClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateModifierPriority;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;

public class Update
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private Expression where;
    private List<UpdateSet> updateSets;
    private FromItem fromItem;
    private List<Join> joins;
    private List<Join> startJoins;
    private OracleHint oracleHint = null;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private ReturningClause returningClause;
    private UpdateModifierPriority modifierPriority;
    private boolean modifierIgnore;
    private OutputClause outputClause;

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    public List<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    public UpdateSet getUpdateSet(int n2) {
        return this.updateSets.get(n2);
    }

    public void setUpdateSets(List<UpdateSet> list) {
        this.updateSets = list;
    }

    public Update withUpdateSets(List<UpdateSet> list) {
        this.setUpdateSets(list);
        return this;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public Update withWithItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public Update addWithItemsList(WithItem ... withItemArray) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(list, withItemArray);
        return this.withWithItemsList(list);
    }

    public Update addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemsList(list);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public Update addUpdateSet(Column column, Expression expression) {
        return this.addUpdateSet(new UpdateSet(column, expression));
    }

    public Update addUpdateSet(UpdateSet updateSet) {
        if (this.updateSets == null) {
            this.updateSets = new ArrayList<UpdateSet>();
        }
        this.updateSets.add(updateSet);
        return this;
    }

    @Deprecated
    public List<Column> getColumns() {
        return this.updateSets.get((int)0).columns;
    }

    @Deprecated
    public List<Expression> getExpressions() {
        return this.updateSets.get((int)0).values;
    }

    @Deprecated
    public void setColumns(List<Column> list) {
        if (this.updateSets.isEmpty()) {
            this.updateSets.add(new UpdateSet());
        }
        this.updateSets.get((int)0).columns.clear();
        this.updateSets.get((int)0).columns.addAll(list);
    }

    @Deprecated
    public void setExpressions(List<Expression> list) {
        this.updateSets.get((int)0).values.clear();
        this.updateSets.get((int)0).values.addAll(list);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public List<Join> getStartJoins() {
        return this.startJoins;
    }

    public void setStartJoins(List<Join> list) {
        this.startJoins = list;
    }

    @Deprecated
    public Select getSelect() {
        Select select = null;
        if (this.updateSets.get((int)0).values.get(0) instanceof Select) {
            select = (Select)this.updateSets.get((int)0).values.get(0);
        }
        return select;
    }

    @Deprecated
    public void setSelect(Select select) {
        if (select != null) {
            if (this.updateSets.get((int)0).values.isEmpty()) {
                this.updateSets.get((int)0).values.add(select);
                return;
            }
            this.updateSets.get((int)0).values.set(0, select);
        }
    }

    @Deprecated
    public boolean isUseColumnsBrackets() {
        return false;
    }

    @Deprecated
    public void setUseColumnsBrackets(boolean bl2) {
    }

    @Deprecated
    public boolean isUseSelect() {
        return false;
    }

    @Deprecated
    public void setUseSelect(boolean bl2) {
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public ReturningClause getReturningClause() {
        return this.returningClause;
    }

    public Update setReturningClause(ReturningClause returningClause) {
        this.returningClause = returningClause;
        return this;
    }

    public UpdateModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(UpdateModifierPriority updateModifierPriority) {
        this.modifierPriority = updateModifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean bl2) {
        this.modifierIgnore = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<ASTNodeAccessImpl> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem aSTNodeAccessImpl = iterator.next();
                stringBuilder.append(aSTNodeAccessImpl);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("UPDATE ");
        if (this.modifierPriority != null) {
            stringBuilder.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            stringBuilder.append("IGNORE ");
        }
        stringBuilder.append(this.table);
        if (this.startJoins != null) {
            for (Join join : this.startJoins) {
                if (join.isSimple()) {
                    stringBuilder.append(", ").append(join);
                    continue;
                }
                stringBuilder.append(" ").append(join);
            }
        }
        stringBuilder.append(" SET ");
        UpdateSet.appendUpdateSetsTo(stringBuilder, this.updateSets);
        if (this.outputClause != null) {
            this.outputClause.appendTo(stringBuilder);
        }
        if (this.fromItem != null) {
            stringBuilder.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        stringBuilder.append(", ").append(join);
                        continue;
                    }
                    stringBuilder.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.where);
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit);
        }
        if (this.returningClause != null) {
            this.returningClause.appendTo(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public Update withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Update withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public Update withJoins(List<Join> list) {
        this.setJoins(list);
        return this;
    }

    public Update withStartJoins(List<Join> list) {
        this.setStartJoins(list);
        return this;
    }

    public Update withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Update withUseColumnsBrackets(boolean bl2) {
        this.setUseColumnsBrackets(bl2);
        return this;
    }

    public Update withUseSelect(boolean bl2) {
        this.setUseSelect(bl2);
        return this;
    }

    public Update withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public Update withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Update withWhere(Expression expression) {
        this.setWhere(expression);
        return this;
    }

    public Update withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public Update withExpressions(List<Expression> list) {
        this.setExpressions(list);
        return this;
    }

    public Update withModifierPriority(UpdateModifierPriority updateModifierPriority) {
        this.setModifierPriority(updateModifierPriority);
        return this;
    }

    public Update withModifierIgnore(boolean bl2) {
        this.setModifierIgnore(bl2);
        return this;
    }

    public Update addColumns(Column ... columnArray) {
        return this.addColumns(Arrays.asList(columnArray));
    }

    public Update addColumns(Collection<? extends Column> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Column column = (Column)object.next();
            this.updateSets.get(this.updateSets.size() - 1).add(column);
        }
        return this;
    }

    public Update addExpressions(Expression ... expressionArray) {
        return this.addExpressions(Arrays.asList(expressionArray));
    }

    public Update addExpressions(Collection<? extends Expression> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Expression expression = (Expression)object.next();
            this.updateSets.get(this.updateSets.size() - 1).add(expression);
        }
        return this;
    }

    public Update addJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withJoins(list);
    }

    public Update addJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withJoins(list);
    }

    public Update addStartJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withStartJoins(list);
    }

    public Update addStartJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withStartJoins(list);
    }

    public Update addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public Update addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }

    public <E extends Expression> E getWhere(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhere()));
    }

    public <E extends FromItem> E getFromItem(Class<E> clazz) {
        return (E)((FromItem)clazz.cast(this.getFromItem()));
    }
}

